/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.events;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryClientConfiguration;
import net.jaams.jaams_weaponry.tooltips.AmmunitionItemTooltip;
import net.jaams.jaams_weaponry.tooltips.AxeItemTooltip;
import net.jaams.jaams_weaponry.tooltips.BattleAxeItemTooltip;
import net.jaams.jaams_weaponry.tooltips.BokkenItemTooltip;
import net.jaams.jaams_weaponry.tooltips.BowItemTooltip;
import net.jaams.jaams_weaponry.tooltips.BroadswordItemTooltip;
import net.jaams.jaams_weaponry.tooltips.BroomItemTooltip;
import net.jaams.jaams_weaponry.tooltips.BusterSwordItemTooltip;
import net.jaams.jaams_weaponry.tooltips.ButterflySwordItemTooltip;
import net.jaams.jaams_weaponry.tooltips.ClawItemTooltip;
import net.jaams.jaams_weaponry.tooltips.CleaverItemTooltip;
import net.jaams.jaams_weaponry.tooltips.CompoundBowItemTooltip;
import net.jaams.jaams_weaponry.tooltips.CopperChokeItemTooltip;
import net.jaams.jaams_weaponry.tooltips.CopperExtendedMagazineItemTooltip;
import net.jaams.jaams_weaponry.tooltips.CopperMuzzleItemTooltip;
import net.jaams.jaams_weaponry.tooltips.CopperQuickDrawMagazineItemTooltip;
import net.jaams.jaams_weaponry.tooltips.CrossbowItemTooltip;
import net.jaams.jaams_weaponry.tooltips.DaggerItemTooltip;
import net.jaams.jaams_weaponry.tooltips.DaggerReverseItemTooltip;
import net.jaams.jaams_weaponry.tooltips.DynamiteItemTooltip;
import net.jaams.jaams_weaponry.tooltips.FlatBowItemTooltip;
import net.jaams.jaams_weaponry.tooltips.FlintHammerItemTooltip;
import net.jaams.jaams_weaponry.tooltips.GauntletItemTooltip;
import net.jaams.jaams_weaponry.tooltips.GiantShurikenItemTooltip;
import net.jaams.jaams_weaponry.tooltips.GreatCrossbowItemTooltip;
import net.jaams.jaams_weaponry.tooltips.GreathammerItemTooltip;
import net.jaams.jaams_weaponry.tooltips.GreatswordItemTooltip;
import net.jaams.jaams_weaponry.tooltips.HammerItemTooltip;
import net.jaams.jaams_weaponry.tooltips.HoeItemTooltip;
import net.jaams.jaams_weaponry.tooltips.HookSwordItemTooltip;
import net.jaams.jaams_weaponry.tooltips.HuntersBoomerangItemTooltip;
import net.jaams.jaams_weaponry.tooltips.HuntersBowItemTooltip;
import net.jaams.jaams_weaponry.tooltips.HuntersCrossbowItemTooltip;
import net.jaams.jaams_weaponry.tooltips.KamaItemTooltip;
import net.jaams.jaams_weaponry.tooltips.KatanaItemTooltip;
import net.jaams.jaams_weaponry.tooltips.KatarItemTooltip;
import net.jaams.jaams_weaponry.tooltips.KnuckleItemTooltip;
import net.jaams.jaams_weaponry.tooltips.KunaiItemTooltip;
import net.jaams.jaams_weaponry.tooltips.LongswordItemTooltip;
import net.jaams.jaams_weaponry.tooltips.MacheteItemTooltip;
import net.jaams.jaams_weaponry.tooltips.NunchakuItemTooltip;
import net.jaams.jaams_weaponry.tooltips.PickaxeItemTooltip;
import net.jaams.jaams_weaponry.tooltips.PistolItemTooltip;
import net.jaams.jaams_weaponry.tooltips.ProngedKunaiItemTooltip;
import net.jaams.jaams_weaponry.tooltips.RingItemTooltip;
import net.jaams.jaams_weaponry.tooltips.RoyalAxeItemTooltip;
import net.jaams.jaams_weaponry.tooltips.RoyalBowItemTooltip;
import net.jaams.jaams_weaponry.tooltips.RoyalCrossbowItemTooltip;
import net.jaams.jaams_weaponry.tooltips.RoyalRapierItemTooltip;
import net.jaams.jaams_weaponry.tooltips.RoyalSpearItemTooltip;
import net.jaams.jaams_weaponry.tooltips.RoyalSwordItemTooltip;
import net.jaams.jaams_weaponry.tooltips.RusticWhipItemTooltip;
import net.jaams.jaams_weaponry.tooltips.SawCleaverItemTooltip;
import net.jaams.jaams_weaponry.tooltips.SawCleaverUnfoldedItemTooltip;
import net.jaams.jaams_weaponry.tooltips.ScattergunItemTooltip;
import net.jaams.jaams_weaponry.tooltips.ScytheItemTooltip;
import net.jaams.jaams_weaponry.tooltips.SharpStoneBladeItemTooltip;
import net.jaams.jaams_weaponry.tooltips.SharpStoneItemTooltip;
import net.jaams.jaams_weaponry.tooltips.ShortBowItemTooltip;
import net.jaams.jaams_weaponry.tooltips.ShotgunItemTooltip;
import net.jaams.jaams_weaponry.tooltips.ShovelItemTooltip;
import net.jaams.jaams_weaponry.tooltips.ShurikenItemTooltip;
import net.jaams.jaams_weaponry.tooltips.SickleItemTooltip;
import net.jaams.jaams_weaponry.tooltips.SmokeBombItemTooltip;
import net.jaams.jaams_weaponry.tooltips.SpearItemTooltip;
import net.jaams.jaams_weaponry.tooltips.StakeCrossbowItemTooltip;
import net.jaams.jaams_weaponry.tooltips.StakeItemTooltip;
import net.jaams.jaams_weaponry.tooltips.StoneSlingshotItemTooltip;
import net.jaams.jaams_weaponry.tooltips.SwordItemTooltip;
import net.jaams.jaams_weaponry.tooltips.TessenFoldedItemTooltip;
import net.jaams.jaams_weaponry.tooltips.TessenItemTooltip;
import net.jaams.jaams_weaponry.tooltips.TridentItemTooltip;
import net.jaams.jaams_weaponry.tooltips.TwinbladeItemTooltip;
import net.jaams.jaams_weaponry.tooltips.WarPickItemTooltip;
import net.jaams.jaams_weaponry.tooltips.WoodenSlingshotItemTooltip;
import net.jaams.jaams_weaponry.tooltips.ZweihanderItemTooltip;
import net.jaams.jaams_weaponry.util.ModEnums;
import net.jaams.jaams_weaponry.util.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public abstract class ItemTooltipHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        List tooltip = event.getToolTip();
        ItemTooltipHandler handler = ItemTooltipHandler.getHandlerForItem(itemStack);
        if (handler != null) {
            handler.applyTooltips(itemStack, tooltip);
        }
    }

    protected abstract boolean canHandleItem(ItemStack var1);

    protected abstract List<ToolProperty> getToolProperties(ItemStack var1);

    protected abstract String getLongDescriptionKey(ItemStack var1);

    protected abstract List<Component> getExtraInfoComponents(ItemStack var1);

    protected boolean showLongDescription(ItemStack itemStack) {
        return this.getLongDescriptionKey(itemStack) != null;
    }

    protected boolean showExtraInfo(ItemStack itemStack) {
        return !this.getExtraInfoComponents(itemStack).isEmpty();
    }

    protected void applyTooltips(ItemStack itemStack, List<Component> tooltip) {
        boolean needsInstructionalMessages;
        if (tooltip == null || itemStack == null) {
            return;
        }
        List<ToolProperty> properties = this.getToolProperties(itemStack);
        String longDescKey = this.getLongDescriptionKey(itemStack);
        List<Component> extraInfoComponents = this.getExtraInfoComponents(itemStack);
        boolean showLongDesc = this.showLongDescription(itemStack);
        boolean showExtraInfo = this.showExtraInfo(itemStack);
        int index = 1;
        if (showExtraInfo && Screen.m_96637_()) {
            for (Component component : extraInfoComponents) {
                if (this.containsTooltipText(tooltip, component.getString())) continue;
                tooltip.add(index++, component);
            }
        }
        if (showLongDesc && Screen.m_96639_() && !this.containsTooltipText(tooltip, Component.m_237115_((String)longDescKey).getString())) {
            tooltip.add(index++, (Component)Component.m_237115_((String)longDescKey).m_130940_(ChatFormatting.GRAY));
        }
        if (!(showLongDesc && Screen.m_96639_() || showExtraInfo && Screen.m_96637_())) {
            index = this.addPropertiesWithShift(tooltip, properties, index);
        }
        boolean bl = needsInstructionalMessages = !Screen.m_96638_() && !properties.isEmpty() && (!showExtraInfo || !Screen.m_96637_()) && (!showLongDesc || !Screen.m_96639_()) || showLongDesc && !Screen.m_96639_() || showExtraInfo && !Screen.m_96637_();
        if (needsInstructionalMessages) {
            if (tooltip.size() > 1) {
                tooltip.add((Component)Component.m_237113_((String)""));
            }
            if (!(Screen.m_96638_() || properties.isEmpty() || showExtraInfo && Screen.m_96637_() || showLongDesc && Screen.m_96639_() || this.containsTooltipText(tooltip, "tooltip", "shift_details"))) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.jaams_weaponry.shift_details").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true))));
            }
            if (showLongDesc && !Screen.m_96639_() && !this.containsTooltipText(tooltip, "tooltip", "alt_desc")) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.jaams_weaponry.alt_desc").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true))));
            }
            if (showExtraInfo && !Screen.m_96637_() && !this.containsTooltipText(tooltip, "tooltip", "ctrl_info")) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.jaams_weaponry.ctrl_info").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true))));
            }
            if (itemStack.m_204117_(ModTags.GUNS) && !this.containsTooltipText(tooltip, "tooltip", "gun_inventory")) {
                ModEnums.KeyOption gunInvKeyOption = (ModEnums.KeyOption)((Object)JaamsWeaponryClientConfiguration.GUNINVKEY.get());
                String gunInvKeyName = InputConstants.m_84827_((int)gunInvKeyOption.leftKey, (int)-1).m_84875_().getString();
                tooltip.add((Component)Component.m_237110_((String)"tooltip.jaams_weaponry.gun_inventory", (Object[])new Object[]{gunInvKeyName}).m_130940_(ChatFormatting.GRAY).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true))));
            }
        }
    }

    protected int addPropertiesWithShift(List<Component> tooltip, List<ToolProperty> properties, int index) {
        for (ToolProperty property : properties) {
            if (this.containsTooltipText(tooltip, Component.m_237115_((String)property.getTranslationKey()).getString())) continue;
            tooltip.add(index++, (Component)Component.m_237115_((String)property.getTranslationKey()).m_130940_(property.getColor()));
            if (!Screen.m_96638_() || this.containsTooltipText(tooltip, Component.m_237115_((String)property.getShiftDescriptionKey()).getString())) continue;
            tooltip.add(index++, (Component)Component.m_237115_((String)property.getShiftDescriptionKey()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return index;
    }

    protected boolean containsTooltipText(List<Component> tooltip, String text) {
        return tooltip.stream().anyMatch(component -> component.getString().equals(text));
    }

    protected boolean containsTooltipText(List<Component> tooltip, String ... keyParts) {
        return tooltip.stream().anyMatch(component -> {
            String translationKey;
            if (!(component instanceof MutableComponent)) {
                return false;
            }
            ComponentContents patt11382$temp = component.m_214077_();
            if (patt11382$temp instanceof TranslatableContents) {
                TranslatableContents translatable = (TranslatableContents)patt11382$temp;
                v0 = translatable.m_237508_();
            } else {
                v0 = translationKey = null;
            }
            if (translationKey == null) {
                return false;
            }
            List<String> parts = Arrays.asList(translationKey.split("\\."));
            return parts.size() >= 2 && parts.contains(keyParts[0]) && parts.contains(keyParts[1]);
        });
    }

    private static ItemTooltipHandler getHandlerForItem(ItemStack itemStack) {
        ArrayList<ItemTooltipHandler> handlers = new ArrayList<ItemTooltipHandler>();
        handlers.add(new SwordItemTooltip());
        handlers.add(new AxeItemTooltip());
        handlers.add(new PickaxeItemTooltip());
        handlers.add(new HoeItemTooltip());
        handlers.add(new ShovelItemTooltip());
        handlers.add(new TridentItemTooltip());
        handlers.add(new CrossbowItemTooltip());
        handlers.add(new BowItemTooltip());
        handlers.add(new GauntletItemTooltip());
        handlers.add(new SharpStoneBladeItemTooltip());
        handlers.add(new RusticWhipItemTooltip());
        handlers.add(new HuntersBoomerangItemTooltip());
        handlers.add(new FlintHammerItemTooltip());
        handlers.add(new NunchakuItemTooltip());
        handlers.add(new TessenItemTooltip());
        handlers.add(new TessenFoldedItemTooltip());
        handlers.add(new ShurikenItemTooltip());
        handlers.add(new GiantShurikenItemTooltip());
        handlers.add(new ProngedKunaiItemTooltip());
        handlers.add(new KunaiItemTooltip());
        handlers.add(new StakeItemTooltip());
        handlers.add(new SharpStoneItemTooltip());
        handlers.add(new DaggerItemTooltip());
        handlers.add(new DaggerReverseItemTooltip());
        handlers.add(new KnuckleItemTooltip());
        handlers.add(new CleaverItemTooltip());
        handlers.add(new RingItemTooltip());
        handlers.add(new KamaItemTooltip());
        handlers.add(new ClawItemTooltip());
        handlers.add(new MacheteItemTooltip());
        handlers.add(new KatarItemTooltip());
        handlers.add(new HammerItemTooltip());
        handlers.add(new BattleAxeItemTooltip());
        handlers.add(new SickleItemTooltip());
        handlers.add(new LongswordItemTooltip());
        handlers.add(new ZweihanderItemTooltip());
        handlers.add(new GreatswordItemTooltip());
        handlers.add(new BroadswordItemTooltip());
        handlers.add(new BusterSwordItemTooltip());
        handlers.add(new KatanaItemTooltip());
        handlers.add(new ButterflySwordItemTooltip());
        handlers.add(new HookSwordItemTooltip());
        handlers.add(new ScytheItemTooltip());
        handlers.add(new GreathammerItemTooltip());
        handlers.add(new SpearItemTooltip());
        handlers.add(new TwinbladeItemTooltip());
        handlers.add(new SawCleaverItemTooltip());
        handlers.add(new SawCleaverUnfoldedItemTooltip());
        handlers.add(new RoyalRapierItemTooltip());
        handlers.add(new RoyalSwordItemTooltip());
        handlers.add(new RoyalSpearItemTooltip());
        handlers.add(new RoyalAxeItemTooltip());
        handlers.add(new BroomItemTooltip());
        handlers.add(new BokkenItemTooltip());
        handlers.add(new WarPickItemTooltip());
        handlers.add(new SmokeBombItemTooltip());
        handlers.add(new DynamiteItemTooltip());
        handlers.add(new ShortBowItemTooltip());
        handlers.add(new FlatBowItemTooltip());
        handlers.add(new HuntersBowItemTooltip());
        handlers.add(new CompoundBowItemTooltip());
        handlers.add(new RoyalBowItemTooltip());
        handlers.add(new HuntersCrossbowItemTooltip());
        handlers.add(new StakeCrossbowItemTooltip());
        handlers.add(new GreatCrossbowItemTooltip());
        handlers.add(new RoyalCrossbowItemTooltip());
        handlers.add(new WoodenSlingshotItemTooltip());
        handlers.add(new StoneSlingshotItemTooltip());
        handlers.add(new PistolItemTooltip());
        handlers.add(new ScattergunItemTooltip());
        handlers.add(new ShotgunItemTooltip());
        handlers.add(new CopperChokeItemTooltip());
        handlers.add(new CopperMuzzleItemTooltip());
        handlers.add(new CopperExtendedMagazineItemTooltip());
        handlers.add(new CopperQuickDrawMagazineItemTooltip());
        handlers.add(new AmmunitionItemTooltip());
        for (ItemTooltipHandler handler : handlers) {
            if (!handler.canHandleItem(itemStack)) continue;
            return handler;
        }
        return null;
    }

    protected static class ToolProperty {
        private final String translationKey;
        private final String shiftDescriptionKey;
        private final ChatFormatting color;

        public ToolProperty(String translationKey, String shiftDescriptionKey, ChatFormatting color) {
            this.translationKey = translationKey;
            this.shiftDescriptionKey = shiftDescriptionKey;
            this.color = color;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public String getShiftDescriptionKey() {
            return this.shiftDescriptionKey;
        }

        public ChatFormatting getColor() {
            return this.color;
        }
    }
}

