/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.events;

import net.jaams.jaams_weaponry.weapons.GreathammerItem;
import net.jaams.jaams_weaponry.weapons.HammerItem;
import net.jaams.jaams_weaponry.weapons.KnuckleItem;
import net.jaams.jaams_weaponry.weapons.ScytheItem;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WeaponEventsHandler {
    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            boolean hasHammer = player.m_21205_().m_41720_() instanceof HammerItem && player.m_21206_().m_41720_() instanceof HammerItem;
            boolean hasGreathammer = player.m_21205_().m_41720_() instanceof GreathammerItem || player.m_21206_().m_41720_() instanceof GreathammerItem;
            boolean isHammerSmashActive = player.getPersistentData().m_128471_("HammerSmashActive");
            if (isHammerSmashActive) {
                event.setDamageMultiplier(0.0f);
                player.getPersistentData().m_128473_("HammerSmashActive");
            } else if (hasGreathammer || hasHammer) {
                event.setDamageMultiplier(2.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        ItemStack heldItem = player.m_21205_();
        BlockState blockState = event.getState();
        float originalSpeed = event.getOriginalSpeed();
        float multiplier = 1.0f;
        if (heldItem.m_41720_() instanceof ScytheItem && WeaponEventsHandler.isHoeEffectiveBlock(blockState)) {
            multiplier = 12.0f;
        } else if (heldItem.m_41720_() instanceof GreathammerItem) {
            multiplier = 3.0f;
        } else if (heldItem.m_41720_() instanceof HammerItem) {
            multiplier = 2.0f;
        } else if (heldItem.m_41720_() instanceof KnuckleItem) {
            multiplier = 3.0f;
        }
        event.setNewSpeed(originalSpeed * multiplier);
    }

    private static boolean isHoeEffectiveBlock(BlockState state) {
        Block block = state.m_60734_();
        return block == Blocks.f_220855_ || block == Blocks.f_220856_ || block == Blocks.f_220857_ || block == Blocks.f_220858_ || block == Blocks.f_152500_ || block == Blocks.f_50335_ || block instanceof LeavesBlock || block == Blocks.f_50451_ || block == Blocks.f_50692_ || block == Blocks.f_50716_ || block == Blocks.f_152544_ || block == Blocks.f_50056_ || block == Blocks.f_50057_ || block == Blocks.f_50093_ || block == Blocks.f_152481_ || block == Blocks.f_50701_ || block == Blocks.f_50133_ || block == Blocks.f_50143_ || block == Blocks.f_50186_ || block == Blocks.f_50092_ || block == Blocks.f_50249_ || block == Blocks.f_50250_ || block == Blocks.f_50444_ || block == Blocks.f_50200_ || block == Blocks.f_50130_ || block == Blocks.f_50685_ || block == Blocks.f_50262_ || block == Blocks.f_50577_ || block == Blocks.f_50180_ || block == Blocks.f_50181_ || block == Blocks.f_50182_ || block == Blocks.f_50571_ || block == Blocks.f_50196_;
    }
}

