/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.guns;

import net.jaams.jaams_weaponry.init.JaamsWeaponryModEnchantments;
import net.jaams.jaams_weaponry.particles.CustomExplosionParticleData;
import net.jaams.jaams_weaponry.particles.GunSparkParticleData;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class GunActionsHandler {
    private static final float SOUND_VOLUME = 1.0f;
    private static final float SOUND_PITCH = 1.0f;
    private static final int PICKUP_DELAY = 10;

    public static void handleGunShot(LevelAccessor level, Entity entity, ItemStack itemstack, float baseParticleSize, float particleDistance) {
        LivingEntity living;
        block10: {
            block9: {
                if (entity == null || itemstack == null || level.m_5776_() || !(entity instanceof LivingEntity)) break block9;
                living = (LivingEntity)entity;
                if (level instanceof ServerLevel) break block10;
            }
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean isMainHand = ItemStack.m_41656_((ItemStack)itemstack, (ItemStack)living.m_21205_());
        living.m_21011_(isMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, true);
        Vec3 lookVec = living.m_20154_().m_82541_();
        Vec3 rightVec = lookVec.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        float offset = isMainHand ? 0.15f : -0.15f;
        AABB hitbox = living.m_20191_();
        float hitboxScale = (float)Math.sqrt(hitbox.m_82362_() * hitbox.m_82385_() / 2.0);
        float adjustedParticleSize = baseParticleSize * hitboxScale;
        double startX = living.m_20185_() + rightVec.f_82479_ * (double)offset;
        double startY = living.m_20186_() + (double)living.m_20192_();
        double startZ = living.m_20189_() + rightVec.f_82481_ * (double)offset;
        Vec3 startPos = new Vec3(startX, startY, startZ);
        Vec3 endPos = startPos.m_82549_(lookVec.m_82490_((double)particleDistance));
        ClipContext clipContext = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)living);
        BlockHitResult blockHit = level.m_45547_(clipContext);
        EntityHitResult entityHit = ModUtils.getEntityHitResult(serverLevel, living, startPos, endPos);
        double adjustedDistance = particleDistance;
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            adjustedDistance = Math.min(adjustedDistance, startPos.m_82554_(blockHit.m_82450_()));
        }
        if (entityHit != null) {
            adjustedDistance = Math.min(adjustedDistance, startPos.m_82554_(entityHit.m_82450_()));
        }
        adjustedDistance = Math.max(adjustedDistance - (double)0.1f, (double)0.1f);
        double particleX = startX + lookVec.f_82479_ * adjustedDistance;
        double particleY = startY + lookVec.f_82480_ * adjustedDistance;
        double particleZ = startZ + lookVec.f_82481_ * adjustedDistance;
        int backblastLevel = itemstack.getEnchantmentLevel((Enchantment)JaamsWeaponryModEnchantments.BACKBLAST.get());
        float finalParticleSize = adjustedParticleSize * (1.0f + (float)backblastLevel * 0.1f);
        if (backblastLevel > 0) {
            float colorBase;
            float r = colorBase = serverLevel.f_46441_.m_188501_() * 0.5f + 0.5f;
            float g = colorBase;
            float b = colorBase;
            serverLevel.m_8767_((ParticleOptions)new CustomExplosionParticleData(r, g, b, finalParticleSize), particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
        } else {
            serverLevel.m_8767_((ParticleOptions)new GunSparkParticleData(finalParticleSize), particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (living.m_5842_()) {
            RandomSource random = serverLevel.f_46441_;
            int bubbleCount = 6;
            for (int i = 0; i < bubbleCount; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, particleX + (random.m_188500_() - 0.5) * 0.2, particleY + (random.m_188500_() - 0.5) * 0.2, particleZ + (random.m_188500_() - 0.5) * 0.2, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void handleGunBreak(LevelAccessor level, double x, double y, double z, Entity entity, ItemStack itemstack) {
        ServerLevel serverLevel;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_7500_()) {
            return;
        }
        if (level instanceof ServerLevel && itemstack.m_220157_(1, (serverLevel = (ServerLevel)level).m_213780_(), (ServerPlayer)player)) {
            itemstack.m_41774_(1);
            if (itemstack.m_41619_()) {
                GunActionsHandler.playSound(level, x, y, z, "entity.item.break");
                itemstack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                    for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                        ItemStack slotStack = itemHandler.getStackInSlot(slot);
                        if (slotStack.m_41619_()) continue;
                        GunActionsHandler.spawnItemEntity(serverLevel, x, y, z, slotStack.m_41777_());
                        itemHandler.extractItem(slot, slotStack.m_41613_(), false);
                    }
                });
            }
        }
    }

    public static void applyBackblastRecoil(LivingEntity entity, float recoilDistance, float crouchRecoilReduction, float verticalRecoilMultiplier, float backblastBonus, float fireDurationBonus, float baseDamage) {
        float f;
        Player player;
        Player player2;
        if (entity == null || recoilDistance <= 0.0f) {
            return;
        }
        double recoilMultiplier = recoilDistance * (1.0f + backblastBonus);
        if (entity instanceof Player && (player2 = (Player)entity).m_6047_() && !player2.m_7500_()) {
            recoilMultiplier *= (double)crouchRecoilReduction;
            if (!player2.m_7500_()) {
                player2.m_36324_().m_38703_(0.2f);
            }
        } else if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
            player.m_36324_().m_38703_(0.5f);
        }
        double knockbackResistance = Math.max(0.0, Math.min(1.0, entity.m_21133_(Attributes.f_22278_)));
        double knockbackReduction = 1.0 - Math.pow(1.0 - knockbackResistance, 2.0);
        recoilMultiplier *= 1.0 - knockbackReduction * 0.3;
        double movementSpeed = entity.m_21133_(Attributes.f_22279_);
        double baseMovementSpeed = 0.1;
        double movementSpeedMultiplier = Math.max(0.7, Math.min(1.5, movementSpeed / baseMovementSpeed));
        double horizontalRecoil = 1.2 * (recoilMultiplier *= movementSpeedMultiplier);
        double verticalRecoil = 1.2 * (double)verticalRecoilMultiplier * recoilMultiplier;
        horizontalRecoil = Math.max(0.0, horizontalRecoil);
        verticalRecoil = Math.max(0.0, verticalRecoil);
        if (horizontalRecoil < 0.01 && verticalRecoil < 0.01) {
            return;
        }
        float yaw = entity.m_6080_() * ((float)Math.PI / 180);
        if (entity instanceof Player) {
            Player player3 = (Player)entity;
            f = player3.m_146909_() * ((float)Math.PI / 180);
        } else {
            f = 0.0f;
        }
        float pitch = f;
        double motionX = Math.sin(yaw) * horizontalRecoil * Math.cos(pitch);
        double motionZ = -Math.cos(yaw) * horizontalRecoil * Math.cos(pitch);
        double motionY = 0.0;
        float MIN_PITCH_FOR_VERTICAL_DEGREES = 45.0f;
        float minPitchForVertical = (float)Math.toRadians(45.0);
        double horizontalScale = 1.0;
        if (pitch > minPitchForVertical) {
            float pitchFactor = (pitch - minPitchForVertical) / (1.5707964f - minPitchForVertical);
            pitchFactor = Math.min(1.0f, pitchFactor);
            double verticalScale = Math.cos((double)pitchFactor * Math.PI / 2.0);
            motionY = verticalRecoil * (1.0 - verticalScale);
            horizontalScale = Math.max(0.5, 1.0 - (double)pitchFactor * 0.5);
            motionX *= horizontalScale;
            motionZ *= horizontalScale;
        }
        motionX = Mth.m_14008_((double)motionX, (double)-1.5, (double)1.5);
        motionY = Mth.m_14008_((double)motionY, (double)(-1.5 * (double)verticalRecoilMultiplier), (double)(1.5 * (double)verticalRecoilMultiplier));
        motionZ = Mth.m_14008_((double)motionZ, (double)-1.5, (double)1.5);
        entity.m_20256_(entity.m_20184_().m_82520_(motionX, motionY, motionZ));
        entity.f_19864_ = true;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)entity));
        } else if (!entity.m_9236_().f_46443_) {
            entity.m_9236_().m_45933_(null, entity.m_20191_().m_82400_(10.0)).stream().filter(e -> e instanceof ServerPlayer).forEach(e -> ((ServerPlayer)e).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)entity)));
        }
        if (!entity.m_9236_().f_46443_) {
            AABB aoeArea = new AABB(entity.m_20185_() - 1.5, entity.m_20186_() - 1.5, entity.m_20189_() - 1.5, entity.m_20185_() + 1.5, entity.m_20186_() + 1.5, entity.m_20189_() + 1.5);
            Vec3 sourcePos = entity.m_20182_();
            entity.m_9236_().m_45933_((Entity)entity, aoeArea).stream().filter(e -> e instanceof LivingEntity).map(e -> (LivingEntity)e).forEach(target -> {
                DamageSource damageSource = entity.m_269291_().m_269387_();
                if (target.m_6469_(damageSource, baseDamage * (1.0f + backblastBonus))) {
                    int fireDurationSeconds = Math.max(1, (int)(3.0f * (1.0f + fireDurationBonus)));
                    target.m_20254_(fireDurationSeconds);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (target instanceof Mob) {
                            Mob mob = (Mob)target;
                            if (!player.m_7500_()) {
                                mob.m_6710_((LivingEntity)player);
                            }
                        }
                    }
                    Vec3 targetPos = target.m_20182_();
                    Vec3 direction = targetPos.m_82546_(sourcePos).m_82541_();
                    double knockbackStrength = 0.5 * (1.0 + (double)backblastBonus);
                    double knockbackX = direction.f_82479_ * knockbackStrength;
                    double knockbackY = 0.2 * (1.0 + (double)backblastBonus);
                    double knockbackZ = direction.f_82481_ * knockbackStrength;
                    knockbackX = Mth.m_14008_((double)knockbackX, (double)-1.0, (double)1.0);
                    knockbackY = Mth.m_14008_((double)knockbackY, (double)0.0, (double)0.5);
                    knockbackZ = Mth.m_14008_((double)knockbackZ, (double)-1.0, (double)1.0);
                    target.m_20256_(target.m_20184_().m_82520_(knockbackX, knockbackY, knockbackZ));
                    target.f_19864_ = true;
                    if (target instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)target;
                        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)target));
                    }
                }
            });
        }
    }

    public static void updateAmmoCount(ItemStack itemstack) {
        if (itemstack.m_41619_()) {
            return;
        }
        IItemHandler itemHandler = (IItemHandler)itemstack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (itemHandler != null) {
            int ammoCount = itemHandler.getStackInSlot(1).m_41613_();
            itemstack.m_41784_().m_128405_("bulletamount", ammoCount);
        }
    }

    private static void playSound(LevelAccessor level, double x, double y, double z, String soundResource) {
        if (level instanceof Level) {
            Level levelInstance = (Level)level;
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(soundResource));
            if (!levelInstance.m_5776_()) {
                levelInstance.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                levelInstance.m_7785_(x, y, z, sound, SoundSource.PLAYERS, 1.0f, 1.0f, false);
            }
        }
    }

    private static void spawnItemEntity(ServerLevel level, double x, double y, double z, ItemStack stack) {
        ItemEntity entityToSpawn = new ItemEntity((Level)level, x, y, z, stack);
        entityToSpawn.m_32010_(10);
        level.m_7967_((Entity)entityToSpawn);
    }
}

