/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.guns;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryClientConfiguration;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.util.ModEnums;
import net.jaams.jaams_weaponry.util.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class GunGuiHandler {
    private static final int SLOT_WIDTH = 20;
    private static final int SLOT_HEIGHT = 20;

    @SubscribeEvent
    public static void renderGameOverlayEvent(CustomizeGuiOverlayEvent.DebugText event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91066_.f_92062_ || !((Boolean)JaamsWeaponryCommonConfiguration.ENABLEGUNINVENTORY.get()).booleanValue() || !((Boolean)JaamsWeaponryClientConfiguration.SHOWOVERLAY.get()).booleanValue()) {
            return;
        }
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        boolean isRightArm = player.m_5737_() == HumanoidArm.RIGHT;
        int mainHandX = screenWidth - 60;
        if (!isRightArm) {
            mainHandX = 40;
        }
        int mainHandY = screenHeight - 40;
        if (JaamsWeaponryClientConfiguration.OVERLAY_POSITION.get() == ModEnums.OverlayPosition.TOP) {
            mainHandY = 20;
        }
        int offHandX = 40;
        if (!isRightArm) {
            offHandX = screenWidth - 60;
        }
        int offHandY = screenHeight - 40;
        if (JaamsWeaponryClientConfiguration.OVERLAY_POSITION.get() == ModEnums.OverlayPosition.TOP) {
            offHandY = 20;
        }
        try {
            int mainHandXOffset = (Integer)JaamsWeaponryClientConfiguration.MAINHAND_X.get();
            int mainHandYOffset = (Integer)JaamsWeaponryClientConfiguration.MAINHAND_Y.get();
            int offHandXOffset = (Integer)JaamsWeaponryClientConfiguration.OFFHAND_X.get();
            int offHandYOffset = (Integer)JaamsWeaponryClientConfiguration.OFFHAND_Y.get();
            mainHandX += mainHandXOffset;
            mainHandY += mainHandYOffset;
            offHandX += offHandXOffset;
            offHandY += offHandYOffset;
            mainHandX = Mth.m_14045_((int)mainHandX, (int)-20, (int)screenWidth);
            mainHandY = Mth.m_14045_((int)mainHandY, (int)-20, (int)screenHeight);
            offHandX = Mth.m_14045_((int)offHandX, (int)-20, (int)screenWidth);
            offHandY = Mth.m_14045_((int)offHandY, (int)-20, (int)screenHeight);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GunGuiHandler.renderGunOverlay(mc, player.m_21205_(), event, mainHandX, mainHandY);
        GunGuiHandler.renderGunOverlay(mc, player.m_21206_(), event, offHandX, offHandY);
    }

    private static void renderGunOverlay(Minecraft mc, ItemStack gunItem, CustomizeGuiOverlayEvent.DebugText event, int x, int y) {
        if (!gunItem.m_204117_(ModTags.GUNS)) {
            return;
        }
        GunGuiHandler.renderBulletInGui(mc, gunItem, event, x, y);
    }

    private static void renderBulletInGui(Minecraft mc, ItemStack gunItem, CustomizeGuiOverlayEvent.DebugText event, int x, int y) {
        ItemStack bulletItem = GunGuiHandler.getBulletFromGun(gunItem);
        gunItem.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(handler -> {
            int itemCount = GunGuiHandler.countRenderSlots(handler, bulletItem);
            if (itemCount == 0) {
                return;
            }
            int adjustedX = x - (itemCount - 1) * 10;
            int adjustedY = y;
            GuiGraphics guiGraphics = event.getGuiGraphics();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_(0.0, 0.0, -300.0);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)515);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            if (((Boolean)JaamsWeaponryClientConfiguration.BACKGROUND_ENABLED.get()).booleanValue()) {
                int backgroundColor = ((ModEnums.BackgroundColorOption)((Object)((Object)JaamsWeaponryClientConfiguration.BACKGROUND_COLOR.get()))).getColor() | ((ModEnums.TransparencyOption)((Object)((Object)JaamsWeaponryClientConfiguration.BACKGROUND_TRANSPARENCY.get()))).getAlpha();
                int borderColor = ((ModEnums.BackgroundColorOption)((Object)((Object)JaamsWeaponryClientConfiguration.BORDER_COLOR.get()))).getColor();
                int borderThickness = (Integer)JaamsWeaponryClientConfiguration.BORDER_THICKNESS.get();
                GunGuiHandler.renderBackgroundWithBorder(guiGraphics, adjustedX - 2, adjustedY - 2, itemCount * 20, 20, backgroundColor, borderColor, borderThickness);
            }
            int currentX = adjustedX;
            for (int slot = 0; slot < 3; ++slot) {
                if (!GunGuiHandler.shouldRenderSlot(slot, handler, bulletItem)) continue;
                GunGuiHandler.renderItemSlot(mc, GunGuiHandler.getSlotItem(handler, slot, bulletItem), guiGraphics, currentX, adjustedY);
                currentX += 20;
            }
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.depthFunc((int)515);
            guiGraphics.m_280168_().m_85849_();
        });
    }

    private static int countRenderSlots(IItemHandler handler, ItemStack bulletItem) {
        return ((Boolean)JaamsWeaponryClientConfiguration.RENDERSLOT0.get() != false && !handler.getStackInSlot(0).m_41619_() ? 1 : 0) + ((Boolean)JaamsWeaponryClientConfiguration.RENDERSLOT1.get() != false && (Boolean)JaamsWeaponryCommonConfiguration.AMMOFROMGUN.get() != false && !bulletItem.m_41619_() ? 1 : 0) + ((Boolean)JaamsWeaponryClientConfiguration.RENDERSLOT2.get() != false && !handler.getStackInSlot(2).m_41619_() ? 1 : 0);
    }

    private static boolean shouldRenderSlot(int slot, IItemHandler handler, ItemStack bulletItem) {
        return slot == 0 && (Boolean)JaamsWeaponryClientConfiguration.RENDERSLOT0.get() != false && !handler.getStackInSlot(0).m_41619_() || slot == 1 && (Boolean)JaamsWeaponryClientConfiguration.RENDERSLOT1.get() != false && !bulletItem.m_41619_() && (Boolean)JaamsWeaponryCommonConfiguration.AMMOFROMGUN.get() != false || slot == 2 && (Boolean)JaamsWeaponryClientConfiguration.RENDERSLOT2.get() != false && !handler.getStackInSlot(2).m_41619_();
    }

    private static ItemStack getSlotItem(IItemHandler handler, int slot, ItemStack bulletItem) {
        return slot == 1 ? bulletItem : handler.getStackInSlot(slot);
    }

    private static void renderItemSlot(Minecraft mc, ItemStack itemStack, GuiGraphics guiGraphics, int x, int y) {
        if (!itemStack.m_41619_()) {
            guiGraphics.m_280480_(itemStack, x, y);
            guiGraphics.m_280370_(mc.f_91062_, itemStack, x, y);
        }
    }

    private static void renderBackgroundWithBorder(GuiGraphics guiGraphics, int x, int y, int width, int height, int backgroundColor, int borderColor, int borderThickness) {
        guiGraphics.m_280509_(x - borderThickness, y - borderThickness, x + width + borderThickness, y, borderColor);
        guiGraphics.m_280509_(x - borderThickness, y + height, x + width + borderThickness, y + height + borderThickness, borderColor);
        guiGraphics.m_280509_(x - borderThickness, y, x, y + height, borderColor);
        guiGraphics.m_280509_(x + width, y, x + width + borderThickness, y + height, borderColor);
        guiGraphics.m_280509_(x, y, x + width, y + height, backgroundColor);
    }

    private static ItemStack getBulletFromGun(ItemStack gunStack) {
        return gunStack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(capability -> {
            ItemStack bulletItem = capability.getStackInSlot(1);
            if (GunGuiHandler.isValidBullet(bulletItem)) {
                return bulletItem;
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
    }

    private static boolean isValidBullet(ItemStack stack) {
        return !stack.m_41619_();
    }
}

