/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.guns;

import java.util.concurrent.atomic.AtomicReference;
import net.jaams.jaams_weaponry.JaamsWeaponryMod;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryClientConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.registries.ForgeRegistries;

public class GunSoundHandler {
    private static final int DEFAULT_COOLDOWN = 20;
    private static final float SOUND_VOLUME = 1.0f;
    private static final float SOUND_PITCH = 1.0f;
    private static final double BULLET_DROP_CHANCE = 0.7;
    private static final int AFTER_SHOT_DELAY = 10;

    public static void playEmptyWeaponSound(LevelAccessor level, double x, double y, double z, Entity entity, ItemStack itemstack, String soundResource, String messageKey) {
        if (entity == null || level.m_5776_()) {
            return;
        }
        if (level instanceof Level) {
            Level levelInstance = (Level)level;
            ResourceLocation soundLocation = new ResourceLocation("jaams_weaponry:" + soundResource);
            if (!levelInstance.m_5776_()) {
                levelInstance.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation), SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                levelInstance.m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation), SoundSource.PLAYERS, 1.0f, 1.0f, false);
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((Boolean)JaamsWeaponryClientConfiguration.EMPTYCLICK.get()).booleanValue() && !player.m_9236_().m_5776_()) {
                player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)messageKey).getString()), true);
            }
            player.m_36335_().m_41524_(itemstack.m_41720_(), 20);
        }
    }

    public static void playPistolEmptySound(LevelAccessor level, double x, double y, double z, Entity entity, ItemStack itemstack) {
        GunSoundHandler.playEmptyWeaponSound(level, x, y, z, entity, itemstack, "pistol_empty", "message.gun.empty_click");
    }

    public static void playScattergunEmptySound(LevelAccessor level, double x, double y, double z, Entity entity, ItemStack itemstack) {
        GunSoundHandler.playEmptyWeaponSound(level, x, y, z, entity, itemstack, "scattergun_empty", "message.gun.empty_click");
    }

    public static void playShotgunEmptySound(LevelAccessor level, double x, double y, double z, Entity entity, ItemStack itemstack) {
        GunSoundHandler.playEmptyWeaponSound(level, x, y, z, entity, itemstack, "shotgun_empty", "message.gun.empty_click");
    }

    public static void playScattergunOneBulletSound(LevelAccessor level, double x, double y, double z, Entity entity, ItemStack itemstack) {
        GunSoundHandler.playEmptyWeaponSound(level, x, y, z, entity, itemstack, "scattergun_empty", "message.gun.need_other_bullet");
    }

    private static ItemStack getItemStackFromSlot(int slotId, ItemStack itemStack) {
        AtomicReference<ItemStack> result = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> result.set(capability.getStackInSlot(slotId).m_41777_()));
        return result.get();
    }

    private static void playSound(LevelAccessor level, double x, double y, double z, String soundResource) {
        if (level.m_5776_()) {
            return;
        }
        if (level instanceof Level) {
            Level levelInstance = (Level)level;
            ResourceLocation soundLocation = new ResourceLocation("jaams_weaponry:" + soundResource);
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation);
            if (!levelInstance.m_5776_()) {
                levelInstance.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                levelInstance.m_7785_(x, y, z, sound, SoundSource.PLAYERS, 1.0f, 1.0f, false);
            }
        }
    }

    public static void handleWeaponFire(LevelAccessor level, double x, double y, double z, Entity entity, ItemStack itemstack, Item muzzleAttachment, String muzzleShootSound, String defaultShootSound, Item magazineAttachment, String magazineAfterShootSound, String defaultAfterShootSound, String dropSound, double shakeAmount) {
        if (entity == null) {
            return;
        }
        boolean hasMuzzle = GunSoundHandler.getItemStackFromSlot(0, itemstack).m_41720_() == muzzleAttachment;
        GunSoundHandler.playSound(level, x, y, z, hasMuzzle ? muzzleShootSound : defaultShootSound);
        boolean hasMagazine = GunSoundHandler.getItemStackFromSlot(2, itemstack).m_41720_() == magazineAttachment;
        JaamsWeaponryMod.queueServerWork(10, () -> {
            GunSoundHandler.playSound(level, x, y, z, hasMagazine ? magazineAfterShootSound : defaultAfterShootSound);
            if (Math.random() < 0.7) {
                GunSoundHandler.playSound(level, x, y, z, dropSound);
            }
        });
    }

    public static void playPistolAttachmentSound(LevelAccessor level, double x, double y, double z, Entity entity, ItemStack itemstack) {
        GunSoundHandler.handleWeaponFire(level, x, y, z, entity, itemstack, (Item)JaamsWeaponryModItems.COPPER_MUZZLE.get(), "pistol_muzzle_shoot", "pistol_shoot", (Item)JaamsWeaponryModItems.COPPER_QUICK_DRAW_MAGAZINE.get(), "pistol_magazine_after_shot", "pistol_after_shoot", "bullet_drop", 1.5);
    }

    public static void playScattergunAttachmentSound(LevelAccessor level, double x, double y, double z, Entity entity, ItemStack itemstack) {
        GunSoundHandler.handleWeaponFire(level, x, y, z, entity, itemstack, (Item)JaamsWeaponryModItems.COPPER_CHOKE.get(), "scattergun_muzzle_shoot", "scattergun_shoot", (Item)JaamsWeaponryModItems.COPPER_QUICK_DRAW_MAGAZINE.get(), "scattergun_magazine_after_shoot", "scattergun_after_shoot", "bullet_drop", 2.0);
    }

    public static void playShotgunAttachmentSound(LevelAccessor level, double x, double y, double z, Entity entity, ItemStack itemstack) {
        GunSoundHandler.handleWeaponFire(level, x, y, z, entity, itemstack, (Item)JaamsWeaponryModItems.COPPER_CHOKE.get(), "shotgun_choke_shoot", "shotgun_shoot", (Item)JaamsWeaponryModItems.COPPER_EXTENDED_MAGAZINE.get(), "shotgun_magazine_after_shoot", "shotgun_after_shoot", "shotshell_drop", 3.0);
    }
}

