/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.guns;

import java.util.Random;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEnchantments;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class GunStorageHandler {
    public static void handleOneShot(ItemStack itemstack) {
        GunStorageHandler.processGunSystem(itemstack, 1);
    }

    public static void handleScattergun(ItemStack itemstack) {
        GunStorageHandler.processGunSystem(itemstack, 2);
    }

    private static void processGunSystem(ItemStack itemstack, int damageAmount) {
        if (itemstack.m_41619_()) {
            return;
        }
        IItemHandler itemHandler = (IItemHandler)itemstack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (itemHandler == null) {
            return;
        }
        ItemStack ammoStack = itemHandler.getStackInSlot(1);
        if (!ammoStack.m_41619_()) {
            int ghostClipLevel = itemstack.getEnchantmentLevel((Enchantment)JaamsWeaponryModEnchantments.GHOST_CLIP.get());
            boolean consumeAmmo = true;
            if (ghostClipLevel > 0) {
                double noConsumeChance = 0.15 * (double)ghostClipLevel;
                Random random = new Random();
                if (random.nextDouble() < noConsumeChance) {
                    consumeAmmo = false;
                }
            }
            if (consumeAmmo) {
                ammoStack.m_41774_(damageAmount);
            }
        }
        GunStorageHandler.processAttachment(itemHandler, 0, damageAmount, itemstack);
        GunStorageHandler.processAttachment(itemHandler, 2, damageAmount, itemstack);
    }

    private static void processAttachment(IItemHandler itemHandler, int slot, int damageAmount, ItemStack itemstack) {
        ItemStack stack = itemHandler.getStackInSlot(slot);
        if (!stack.m_41619_()) {
            int frameGuardLevel = itemstack.getEnchantmentLevel((Enchantment)JaamsWeaponryModEnchantments.FRAMEGUARD.get());
            boolean damageAttachment = true;
            if (frameGuardLevel > 0) {
                double noDamageChance = 0.15 * (double)frameGuardLevel;
                Random random = new Random();
                if (random.nextDouble() < noDamageChance) {
                    damageAttachment = false;
                }
            }
            if (damageAttachment) {
                int currentDamage = stack.m_41773_();
                int maxDamage = stack.m_41776_();
                stack.m_41721_(currentDamage + damageAmount);
                if (stack.m_41773_() >= maxDamage || stack.m_41773_() == 0) {
                    stack.m_41774_(1);
                } else if (stack.m_41773_() > 0) {
                    itemHandler.insertItem(slot, stack, false);
                }
            }
        }
    }
}

