/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.mechanics;

import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.particles.CustomHitParticleData;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BackstabHandler {
    public static boolean isBackstab(LivingEntity attacker, LivingEntity target, double maxDistance, double maxAngle) {
        if (attacker == null || target == null || !target.m_6084_() || !attacker.m_6084_()) {
            return false;
        }
        double distance = attacker.m_20270_((Entity)target);
        if (distance > maxDistance) {
            return false;
        }
        if (!attacker.m_142582_((Entity)target)) {
            return false;
        }
        Vec3 attackDirection = attacker.m_20154_().m_82541_();
        Vec3 targetDirection = target.m_20154_().m_82541_();
        double dotProduct = attackDirection.f_82479_ * targetDirection.f_82479_ + attackDirection.f_82481_ * targetDirection.f_82481_;
        double angle = Math.acos(Mth.m_14008_((double)dotProduct, (double)-1.0, (double)1.0));
        boolean withinAngle = angle < maxAngle;
        boolean withinGrace = angle < maxAngle * 1.5 && attacker.m_20184_().m_82556_() > 0.1;
        return withinAngle || withinGrace;
    }

    public static float calculateBackstabMultiplier(LivingEntity attacker, LivingEntity target, Level level, float multiplierNormal, float multiplierSneaking, float multiplierInvisible, float multiplierSneakingInvisible, float darknessBonus, float movingTargetPenalty) {
        float multiplier = multiplierNormal;
        boolean isSneaking = attacker.m_6047_();
        boolean isInvisible = attacker.m_21023_(MobEffects.f_19609_);
        if (isSneaking && isInvisible) {
            multiplier = Math.max(multiplier, multiplierSneakingInvisible);
        } else if (isInvisible) {
            multiplier = Math.max(multiplier, multiplierInvisible);
        } else if (isSneaking) {
            multiplier = Math.max(multiplier, multiplierSneaking);
        }
        float lightLevel = level.m_7146_(target.m_20183_());
        if (lightLevel < 7.0f) {
            multiplier += darknessBonus * (1.0f - lightLevel / 15.0f);
        }
        if (target.m_20184_().m_82556_() > 0.1) {
            multiplier = Math.max(1.0f, multiplier - movingTargetPenalty);
        }
        return Math.max(1.0f, multiplier);
    }

    public static void performBackstab(LivingEntity attacker, LivingEntity entity, ItemStack itemstack, Level level, float durabilityPenalty, float weaknessChance, int weaknessDuration, int weaknessLevel, float multiplierNormal, float multiplierSneaking, float multiplierInvisible, float multiplierSneakingInvisible, float darknessBonus, float movingTargetPenalty) {
        float baseDamage = attacker.getCapability(AmountProvider.AMOUNT).map(amount -> Float.valueOf(amount.getDamage())).orElse(Float.valueOf((float)attacker.m_21133_(Attributes.f_22281_))).floatValue();
        float backstabMultiplier = BackstabHandler.calculateBackstabMultiplier(attacker, entity, level, multiplierNormal, multiplierSneaking, multiplierInvisible, multiplierSneakingInvisible, darknessBonus, movingTargetPenalty);
        float enchantmentBonus = EnchantmentHelper.m_44833_((ItemStack)itemstack, (MobType)entity.m_6336_());
        float bonusDamage = (baseDamage *= 1.3f) * (backstabMultiplier - 1.0f);
        float additionalDamage = bonusDamage + enchantmentBonus;
        BackstabHandler.applyLeftClickBackstabEffects(attacker, entity, itemstack, level, additionalDamage, durabilityPenalty, weaknessChance, weaknessDuration, weaknessLevel);
    }

    public static void performRightClickBackstab(LivingEntity attacker, LivingEntity entity, ItemStack itemstack, Level level, float baseDamage, float durabilityPenalty, float rightClickDurabilityMultiplier, float rightClickForwardImpulse, float weaknessChance, int weaknessDuration, int weaknessLevel, float multiplierNormal, float multiplierSneaking, float multiplierInvisible, float multiplierSneakingInvisible, float darknessBonus, float movingTargetPenalty, float rightClickDamageBonus) {
        DamageSource damageSource;
        if (attacker == null || entity == null || !entity.m_6084_()) {
            return;
        }
        float backstabMultiplier = BackstabHandler.calculateBackstabMultiplier(attacker, entity, level, multiplierNormal, multiplierSneaking, multiplierInvisible, multiplierSneakingInvisible, darknessBonus, movingTargetPenalty);
        float enchantmentBonus = EnchantmentHelper.m_44833_((ItemStack)itemstack, (MobType)entity.m_6336_());
        float bonusDamage = (baseDamage /= 2.0f) * (backstabMultiplier - 1.0f);
        float totalDamage = baseDamage + bonusDamage + rightClickDamageBonus + enchantmentBonus;
        float finalDurabilityPenalty = durabilityPenalty * rightClickDurabilityMultiplier;
        try {
            damageSource = new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("jaams_weaponry:backstab"))), (Entity)attacker);
        }
        catch (Exception e) {
            damageSource = level.m_269111_().m_269333_(attacker);
        }
        entity.m_6469_(damageSource, totalDamage);
        BackstabHandler.applyWeaponEnchantmentEffects(entity, attacker, itemstack);
        BackstabHandler.applyRightClickBackstabEffects(attacker, entity, itemstack, level, totalDamage, finalDurabilityPenalty, rightClickForwardImpulse, weaknessChance, weaknessDuration, weaknessLevel);
    }

    private static void applyLeftClickBackstabEffects(LivingEntity attacker, LivingEntity entity, ItemStack itemstack, Level level, float damage, float durabilityPenalty, float weaknessChance, int weaknessDuration, int weaknessLevel) {
        try {
            DamageSource damageSource = new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("jaams_weaponry:backstab"))), (Entity)attacker);
        }
        catch (Exception e2) {
            DamageSource damageSource = level.m_269111_().m_269333_(attacker);
        }
        ModUtils.applyBackstabDamage(attacker, entity, itemstack, damage);
        if (entity.m_6084_() && level.f_46441_.m_188501_() < weaknessChance) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, weaknessDuration, weaknessLevel - 1));
        }
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12313_, SoundSource.HOSTILE, 1.0f, 1.0f);
        if (!level.f_46443_) {
            ModUtils.spawnCustomParticlesInFront(attacker, itemstack, new CustomHitParticleData(1.0f, 1.0f, 1.0f, 0.5f), 1.0f, 1.0f, 1.0f, 0.5f, 1.0f, 1, false);
        }
        itemstack.m_41622_((int)durabilityPenalty, attacker, e -> e.m_21190_(e.m_7655_()));
    }

    private static void applyRightClickBackstabEffects(LivingEntity attacker, LivingEntity entity, ItemStack itemstack, Level level, float damage, float durabilityPenalty, float rightClickForwardImpulse, float weaknessChance, int weaknessDuration, int weaknessLevel) {
        if (entity.m_6084_()) {
            if (level.f_46441_.m_188501_() < weaknessChance) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, weaknessDuration, weaknessLevel - 1));
            }
            EnchantmentHelper.m_44896_((LivingEntity)attacker, (Entity)entity);
            EnchantmentHelper.m_44823_((LivingEntity)entity, (Entity)attacker);
        }
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12313_, SoundSource.HOSTILE, 1.0f, 1.0f);
        if (!level.f_46443_) {
            ModUtils.spawnCustomParticlesInFront(attacker, itemstack, new CustomHitParticleData(1.0f, 1.0f, 1.0f, 0.5f), 1.0f, 1.0f, 1.0f, 0.5f, 1.0f, 1, false);
        }
        Vec3 lookDirection = attacker.m_20154_().m_82541_().m_82490_((double)rightClickForwardImpulse);
        attacker.m_20256_(attacker.m_20184_().m_82520_(lookDirection.f_82479_, 0.0, lookDirection.f_82481_));
        attacker.f_19864_ = true;
        itemstack.m_41622_((int)durabilityPenalty, attacker, e -> e.m_21190_(e.m_7655_()));
    }

    public static void applyWeaponEnchantmentEffects(LivingEntity nearby, LivingEntity attacker, ItemStack weaponItem) {
        int knockbackLevel;
        int baneOfArthropodsLevel;
        int fireAspectLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)weaponItem);
        if (fireAspectLevel > 0) {
            nearby.m_20254_(fireAspectLevel * 4);
        }
        if ((baneOfArthropodsLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44979_, (ItemStack)weaponItem)) > 0 && nearby.m_6336_() == MobType.f_21642_) {
            nearby.m_7292_(new MobEffectInstance(MobEffects.f_19597_, baneOfArthropodsLevel * 50, 3));
        }
        if ((knockbackLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)weaponItem)) > 0) {
            double motionZ;
            double knockbackStrength = (double)knockbackLevel * 0.5;
            double motionX = nearby.m_20185_() - attacker.m_20185_();
            double distance = Math.sqrt(motionX * motionX + (motionZ = nearby.m_20189_() - attacker.m_20189_()) * motionZ);
            if (distance > 0.0) {
                nearby.m_5997_(motionX / distance * knockbackStrength, 0.1, motionZ / distance * knockbackStrength);
            }
        }
    }
}

