/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.mechanics;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class BreakingHandler {
    public static void damageArmorPieces(LivingEntity entity, int damageAmount, EquipmentSlot ... slots) {
        if (entity == null || entity.m_9236_().f_46443_ || damageAmount <= 0) {
            return;
        }
        if (BreakingHandler.isExemptFromDamage(entity)) {
            return;
        }
        for (EquipmentSlot slot : slots) {
            ItemStack armorPiece = entity.m_6844_(slot);
            if (armorPiece == null || !armorPiece.m_41763_()) continue;
            armorPiece.m_41622_(damageAmount, entity, e -> e.m_21166_(slot));
        }
    }

    public static void damageHeldItem(LivingEntity entity, int damageAmount) {
        ItemStack offHandItem;
        if (entity == null || entity.m_9236_().f_46443_ || damageAmount <= 0) {
            return;
        }
        if (BreakingHandler.isExemptFromDamage(entity)) {
            return;
        }
        ItemStack mainHandItem = entity.m_21205_();
        if (mainHandItem != null && mainHandItem.m_41763_()) {
            mainHandItem.m_41622_(damageAmount, entity, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        }
        if ((offHandItem = entity.m_21206_()) != null && offHandItem.m_41763_()) {
            offHandItem.m_41622_(damageAmount, entity, e -> e.m_21166_(EquipmentSlot.OFFHAND));
        }
    }

    public static boolean isExemptFromDamage(LivingEntity entity) {
        ResourceLocation entityKey = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        return entityKey != null && "dummmmmmy:target_dummy".equals(entityKey.toString());
    }
}

