/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.mechanics;

import java.util.HashMap;
import net.jaams.jaams_weaponry.particles.CustomSweepParticleData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class DecapitationHandler {
    public static void handleDecapitation(Level world, double x, double y, double z, LivingEntity entity, LivingEntity sourceEntity, double playerHeadDropChance, double zombieHeadDropChance, double skeletonHeadDropChance, double witherSkeletonHeadDropChance, double creeperHeadDropChance, double endermanHeadDropChance, double mimeHeadDropChance, double piglinHeadDropChance, double criticalDecapitationChance) {
        boolean isCritical = sourceEntity.m_21256_() > 0 || sourceEntity.m_20142_();
        ResourceLocation entityId = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
        if (entityId == null) {
            return;
        }
        HashMap<ResourceLocation, HeadDropConfig> specificHeadDrops = new HashMap<ResourceLocation, HeadDropConfig>();
        specificHeadDrops.put(new ResourceLocation("minecraft:zombie"), new HeadDropConfig("minecraft:zombie_head", zombieHeadDropChance));
        specificHeadDrops.put(new ResourceLocation("minecraft:skeleton"), new HeadDropConfig("minecraft:skeleton_skull", skeletonHeadDropChance));
        specificHeadDrops.put(new ResourceLocation("minecraft:wither_skeleton"), new HeadDropConfig("minecraft:wither_skeleton_skull", witherSkeletonHeadDropChance));
        specificHeadDrops.put(new ResourceLocation("minecraft:creeper"), new HeadDropConfig("minecraft:creeper_head", creeperHeadDropChance));
        specificHeadDrops.put(new ResourceLocation("minecraft:piglin"), new HeadDropConfig("minecraft:piglin_head", piglinHeadDropChance));
        if (ModList.get().isLoaded("supplementaries")) {
            specificHeadDrops.put(new ResourceLocation("minecraft:enderman"), new HeadDropConfig("supplementaries:enderman_head", endermanHeadDropChance));
        }
        if (ModList.get().isLoaded("caverns_and_chasms")) {
            specificHeadDrops.put(new ResourceLocation("caverns_and_chasms:mime"), new HeadDropConfig("caverns_and_chasms:mime_head", mimeHeadDropChance));
        }
        if (entity instanceof Player) {
            DecapitationHandler.handlePlayerHeadDrop(world, x, y, z, entity, isCritical, playerHeadDropChance, criticalDecapitationChance);
            return;
        }
        HeadDropConfig config = (HeadDropConfig)specificHeadDrops.get(entityId);
        if (config != null) {
            DecapitationHandler.handleHeadDrop(world, x, y, z, entity, config.headItemId, config.dropChance, isCritical, criticalDecapitationChance);
            return;
        }
        String entityName = entityId.m_135815_();
        Item targetItem = null;
        for (Item item : BuiltInRegistries.f_257033_) {
            String itemPath;
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
            if (itemId == null || !(itemPath = itemId.m_135815_()).equals(entityName + "_head") && !itemPath.equals(entityName + "_skull")) continue;
            targetItem = item;
            break;
        }
        if (targetItem != null) {
            DecapitationHandler.handleHeadDrop(world, x, y, z, entity, BuiltInRegistries.f_257033_.m_7981_(targetItem).toString(), 0.3, isCritical, criticalDecapitationChance);
        }
    }

    private static void handlePlayerHeadDrop(Level world, double x, double y, double z, LivingEntity entity, boolean isCritical, double playerHeadDropChance, double criticalDecapitationChance) {
        if ((Math.random() < playerHeadDropChance || isCritical && Math.random() < criticalDecapitationChance) && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            ItemStack headItem = new ItemStack((ItemLike)Items.f_42680_);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                CompoundTag nbt = new CompoundTag();
                nbt.m_128359_("SkullOwner", player.m_36316_().getName());
                headItem.m_41751_(nbt);
            }
            ItemEntity headEntity = new ItemEntity((Level)serverLevel, x, y, z, headItem);
            headEntity.m_32010_(10);
            serverLevel.m_7967_((Entity)headEntity);
            DecapitationHandler.playSoundAndParticles(serverLevel, x, y, z);
        }
    }

    private static void handleHeadDrop(Level world, double x, double y, double z, LivingEntity entity, String headItemId, double dropChance, boolean isCritical, double criticalDecapitationChance) {
        if ((Math.random() < dropChance || isCritical && Math.random() < criticalDecapitationChance) && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            ResourceLocation itemId = new ResourceLocation(headItemId);
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
            if (item == Items.f_41852_) {
                return;
            }
            ItemStack headItem = new ItemStack((ItemLike)item);
            ItemEntity headEntity = new ItemEntity((Level)serverLevel, x, y, z, headItem);
            headEntity.m_32010_(10);
            serverLevel.m_7967_((Entity)headEntity);
            DecapitationHandler.playSoundAndParticles(serverLevel, x, y, z);
        }
    }

    private static void playSoundAndParticles(ServerLevel serverLevel, double x, double y, double z) {
        serverLevel.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:scythe_decapitation")), SoundSource.PLAYERS, 1.0f, 1.0f);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float size = 1.0f;
        double yOffset = (double)serverLevel.f_46441_.m_188501_() * 0.5 - 0.25;
        double particleY = y + yOffset;
        serverLevel.m_8767_((ParticleOptions)new CustomSweepParticleData(r, g, b, size), x, particleY, z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private record HeadDropConfig(String headItemId, double dropChance) {
    }
}

