/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.mechanics;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;

public class DisablerHandler {
    public static void disableShieldOrWeapon(LivingEntity entity, int cooldownTicks) {
        if (entity == null || cooldownTicks <= 0 || !entity.m_21254_() && !entity.m_6117_()) {
            return;
        }
        ItemStack mainHandItem = entity.m_21205_();
        ItemStack offHandItem = entity.m_21206_();
        DisablerHandler.disableItemIfDisablable(entity, mainHandItem, cooldownTicks);
        DisablerHandler.disableItemIfDisablable(entity, offHandItem, cooldownTicks);
    }

    public static void disableActiveItem(LivingEntity entity, int cooldownTicks) {
        if (entity == null || cooldownTicks <= 0 || !entity.m_6117_() && !entity.m_21254_()) {
            return;
        }
        ItemStack mainHandItem = entity.m_21205_();
        ItemStack offHandItem = entity.m_21206_();
        if (!mainHandItem.m_41619_() && (entity.m_6117_() || entity.m_21254_())) {
            entity.m_5810_();
            DisablerHandler.applyCooldown(entity, mainHandItem, cooldownTicks);
            if (!entity.m_9236_().f_46443_) {
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        if (!offHandItem.m_41619_() && (entity.m_6117_() || entity.m_21254_())) {
            entity.m_5810_();
            DisablerHandler.applyCooldown(entity, offHandItem, cooldownTicks);
            if (!entity.m_9236_().f_46443_) {
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public static void disableItemIfDisablable(LivingEntity entity, ItemStack item, int cooldownTicks) {
        if (DisablerHandler.isDisablableItem(item)) {
            entity.m_5810_();
            DisablerHandler.applyCooldown(entity, item, cooldownTicks);
            if (!entity.m_9236_().f_46443_) {
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public static boolean isDisablableItem(ItemStack item) {
        if (item == null || item.m_41619_()) {
            return false;
        }
        return item.m_41720_() instanceof ShieldItem || item.m_41720_() instanceof SwordItem;
    }

    public static void applyCooldown(LivingEntity entity, ItemStack item, int cooldownTicks) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).m_36335_().m_41519_(item.m_41720_())) {
            player.m_36335_().m_41524_(item.m_41720_(), cooldownTicks);
        }
    }
}

