/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.mechanics;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEnchantments;
import net.jaams.jaams_weaponry.particles.MiniSweepParticleData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class DisarmHandler {
    private static final double HAND_HEIGHT_FACTOR = 0.6;
    private static final double ARMOR_HEIGHT_HEAD = 1.8;
    private static final double ARMOR_HEIGHT_CHEST = 1.2;
    private static final double ARMOR_HEIGHT_LEGS = 0.8;
    private static final double ARMOR_HEIGHT_FEET = 0.2;

    public static boolean disarmEnemy(LivingEntity entity, LivingEntity sourceEntity) {
        for (EquipmentSlot slot : EnumSet.of(EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND)) {
            if (!DisarmHandler.disarmSlot(entity, sourceEntity, slot)) continue;
            return true;
        }
        return false;
    }

    public static boolean disarmArmor(LivingEntity entity, LivingEntity sourceEntity, EquipmentSlot armorSlot) {
        return armorSlot.m_20743_() == EquipmentSlot.Type.ARMOR && DisarmHandler.disarmSlot(entity, sourceEntity, armorSlot);
    }

    public static boolean disarmFullArmor(LivingEntity entity, LivingEntity sourceEntity) {
        boolean disarmedAny = false;
        for (EquipmentSlot slot : EnumSet.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET)) {
            if (!DisarmHandler.disarmSlot(entity, sourceEntity, slot)) continue;
            disarmedAny = true;
        }
        return disarmedAny;
    }

    public static boolean disarmArmorWithPriority(LivingEntity entity, LivingEntity sourceEntity) {
        for (EquipmentSlot slot : EnumSet.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET)) {
            if (!DisarmHandler.disarmSlot(entity, sourceEntity, slot)) continue;
            return true;
        }
        return false;
    }

    public static boolean disarmRandomArmorPiece(LivingEntity entity, LivingEntity sourceEntity) {
        Level level = entity.m_9236_();
        List<EquipmentSlot> equippedSlots = EnumSet.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET).stream().filter(slot -> !entity.m_6844_(slot).m_41619_()).toList();
        if (!equippedSlots.isEmpty()) {
            EquipmentSlot randomSlot = equippedSlots.get(level.f_46441_.m_188503_(equippedSlots.size()));
            return DisarmHandler.disarmSlot(entity, sourceEntity, randomSlot);
        }
        return false;
    }

    public static boolean disarmSlot(LivingEntity entity, LivingEntity sourceEntity, EquipmentSlot slot) {
        Level level = entity.m_9236_();
        ItemStack itemStack = entity.m_6844_(slot);
        if (!itemStack.m_41619_() && DisarmHandler.canBeDisarmed(itemStack)) {
            ItemStack stolenItem = itemStack.m_41777_();
            if (itemStack.m_41613_() > 1) {
                stolenItem.m_41764_(1);
                itemStack.m_41774_(1);
            } else {
                entity.m_8061_(slot, ItemStack.f_41583_);
            }
            if (!level.f_46443_) {
                entity.m_5552_(stolenItem, 0.5f);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12316_, SoundSource.PLAYERS, 1.0f, 1.0f);
                DisarmHandler.spawnDisarmParticles((ServerLevel)level, entity, sourceEntity, slot);
            }
            return true;
        }
        return false;
    }

    public static boolean canBeDisarmed(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemID != null && ((List)JaamsWeaponryCommonConfiguration.NONDISARMABLEITEMS.get()).contains(itemID.toString())) {
            return false;
        }
        return enchantments.keySet().stream().noneMatch(enchantment -> enchantment == JaamsWeaponryModEnchantments.SECURE_GRIP.get() || enchantment == Enchantments.f_44975_);
    }

    public static void spawnDisarmParticles(ServerLevel level, LivingEntity entity, LivingEntity sourceEntity, EquipmentSlot slot) {
        Vec3 particlePosition = DisarmHandler.getSlotPosition(entity, slot);
        MiniSweepParticleData particle = new MiniSweepParticleData(1.0f, 1.0f, 1.0f, 0.4f);
        level.m_8767_((ParticleOptions)particle, particlePosition.f_82479_, particlePosition.f_82480_, particlePosition.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public static Vec3 getSlotPosition(LivingEntity entity, EquipmentSlot slot) {
        Vec3 basePosition = entity.m_20182_();
        switch (slot) {
            case MAINHAND: {
                return basePosition.m_82549_(entity.m_20154_().m_82490_(0.4)).m_82520_(0.0, (double)entity.m_20206_() * 0.6, 0.0);
            }
            case OFFHAND: {
                return basePosition.m_82549_(entity.m_20154_().m_82490_(-0.4)).m_82520_(0.0, (double)entity.m_20206_() * 0.6, 0.0);
            }
            case HEAD: {
                return basePosition.m_82520_(0.0, (double)entity.m_20206_() * 1.8, 0.0);
            }
            case CHEST: {
                return basePosition.m_82520_(0.0, (double)entity.m_20206_() * 1.2, 0.0);
            }
            case LEGS: {
                return basePosition.m_82520_(0.0, (double)entity.m_20206_() * 0.8, 0.0);
            }
            case FEET: {
                return basePosition.m_82520_(0.0, (double)entity.m_20206_() * 0.2, 0.0);
            }
        }
        return basePosition;
    }
}

