/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.mechanics;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.jaams.jaams_weaponry.properties.EquipmentProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class EntityEquipmentHandler {
    protected abstract double getEquipChance(Difficulty var1);

    protected abstract List<EquipmentProperties.EquipmentEntry> getEquipmentList(Difficulty var1);

    protected void applyCustomNBT(ItemStack stack, Difficulty difficulty, Random random) {
    }

    protected EquipmentProperties.EquipmentEntry getRandomEquipmentEntry(Difficulty difficulty, Random random) {
        List<EquipmentProperties.EquipmentEntry> equipment = this.getEquipmentList(difficulty);
        if (equipment.isEmpty()) {
            return null;
        }
        double totalWeight = equipment.stream().filter(entry -> entry.isModLoaded()).mapToDouble(EquipmentProperties.EquipmentEntry::getSpawnChance).sum();
        if (totalWeight <= 0.0) {
            return null;
        }
        double rand = random.nextDouble() * totalWeight;
        double currentWeight = 0.0;
        for (EquipmentProperties.EquipmentEntry entry2 : equipment) {
            if (!entry2.isModLoaded() || !(rand <= (currentWeight += entry2.getSpawnChance()))) continue;
            return entry2;
        }
        return null;
    }

    protected ItemStack getItemStackFromEntry(String itemId, String tag, Random random, int minStack, int maxStack, Difficulty difficulty) {
        ItemStack stack = ItemStack.f_41583_;
        if (!itemId.isEmpty()) {
            try {
                ResourceLocation id = new ResourceLocation(itemId);
                Item item2 = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
                if (item2 != BuiltInRegistries.f_257033_.m_7745_(BuiltInRegistries.f_257033_.m_122315_())) {
                    stack = new ItemStack((ItemLike)item2);
                }
            }
            catch (Exception id) {}
        } else if (!tag.isEmpty()) {
            try {
                List validItems;
                ResourceLocation tagId = new ResourceLocation(tag);
                TagKey tagKey = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)tagId);
                Optional holderSet = BuiltInRegistries.f_257033_.m_203431_(tagKey);
                if (holderSet.isPresent() && !(validItems = ((HolderSet.Named)holderSet.get()).m_203614_().map(Holder::m_203334_).filter(item -> item != BuiltInRegistries.f_257033_.m_7745_(BuiltInRegistries.f_257033_.m_122315_())).collect(Collectors.toList())).isEmpty()) {
                    Item selectedItem = (Item)validItems.get(random.nextInt(validItems.size()));
                    stack = new ItemStack((ItemLike)selectedItem);
                }
            }
            catch (Exception tagId) {
                // empty catch block
            }
        }
        if (!stack.m_41619_()) {
            if (stack.m_41753_() && minStack > 0 && maxStack >= minStack) {
                int stackSize = minStack + random.nextInt(maxStack - minStack + 1);
                stack.m_41764_(Math.min(stackSize, stack.m_41741_()));
            }
            this.applyCustomNBT(stack, difficulty, random);
        }
        return stack;
    }

    protected void equipEntity(Mob mob, Level level, Difficulty difficulty, Random random) {
        EquipmentProperties.EquipmentEntry entry;
        if (level.m_5776_() || mob == null || difficulty == null || random == null) {
            return;
        }
        if (random.nextDouble() < this.getEquipChance(difficulty) && (entry = this.getRandomEquipmentEntry(difficulty, random)) != null && entry.isModLoaded()) {
            ItemStack offHandStack;
            ItemStack mainHandStack;
            ItemStack mainHand = mob.m_6844_(EquipmentSlot.MAINHAND);
            ItemStack offHand = mob.m_6844_(EquipmentSlot.OFFHAND);
            if (mainHand.m_41619_() && !(mainHandStack = this.getItemStackFromEntry(entry.getMainHandItemId(), entry.getMainHandTag(), random, entry.getMainHandMinStack(), entry.getMainHandMaxStack(), difficulty)).m_41619_()) {
                mob.m_8061_(EquipmentSlot.MAINHAND, mainHandStack);
                mob.m_21409_(EquipmentSlot.MAINHAND, entry.getDropChance());
            }
            if (offHand.m_41619_() && entry.isDualWield() && !(offHandStack = this.getItemStackFromEntry(entry.getOffHandItemId(), entry.getOffHandTag(), random, entry.getOffHandMinStack(), entry.getOffHandMaxStack(), difficulty)).m_41619_()) {
                mob.m_8061_(EquipmentSlot.OFFHAND, offHandStack);
                mob.m_21409_(EquipmentSlot.OFFHAND, entry.getDropChance());
            }
        }
    }

    protected List<EquipmentProperties.EquipmentEntry> adjustSpawnChances(List<EquipmentProperties.EquipmentEntry> original, double multiplier) {
        ArrayList<EquipmentProperties.EquipmentEntry> result = new ArrayList<EquipmentProperties.EquipmentEntry>();
        for (EquipmentProperties.EquipmentEntry entry : original) {
            boolean isValid;
            if (!entry.isModLoaded()) continue;
            boolean bl = isValid = !entry.getMainHandItemId().isEmpty() || this.isTagValid(entry.getMainHandTag());
            if (!entry.getOffHandItemId().isEmpty() || !entry.getOffHandTag().isEmpty()) {
                isValid &= !entry.getOffHandItemId().isEmpty() || this.isTagValid(entry.getOffHandTag());
            }
            if (!isValid) continue;
            result.add(new EquipmentProperties.EquipmentEntry(entry.getMainHandItemId(), entry.getOffHandItemId(), entry.getSpawnChance() * multiplier, entry.getDropChance(), entry.getMainHandMinStack(), entry.getMainHandMaxStack(), entry.getOffHandMinStack(), entry.getOffHandMaxStack(), entry.getModid()));
        }
        return result;
    }

    private boolean isTagValid(String tag) {
        if (tag.isEmpty()) {
            return false;
        }
        try {
            ResourceLocation tagId = new ResourceLocation(tag);
            TagKey tagKey = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)tagId);
            return BuiltInRegistries.f_257033_.m_203431_(tagKey).map(holderSet -> !holderSet.m_203614_().toList().isEmpty()).orElse(false);
        }
        catch (Exception e) {
            return false;
        }
    }
}

