/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.mechanics;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class ItemSwitchHandler {
    public static void switchItem(LevelAccessor level, double x, double y, double z, Entity entity, Item originalItem, Item targetItem, int mainHandCooldown, int offHandCooldown, String soundEvent, List<Item> noCooldownItems, List<ResourceLocation> noCooldownTags) {
        Player player;
        ServerLevel serverLevel;
        LivingEntity livingEntity;
        block20: {
            block19: {
                if (level.m_5776_() || entity == null || !(entity instanceof LivingEntity)) break block19;
                livingEntity = (LivingEntity)entity;
                if (originalItem != null && targetItem != null) break block20;
            }
            return;
        }
        ItemStack mainHandItem = livingEntity.m_21205_();
        ItemStack offHandItem = livingEntity.m_21206_();
        boolean mainHandChanged = false;
        boolean offHandChanged = false;
        if (ItemSwitchHandler.canSwitchItem(mainHandItem, livingEntity, originalItem)) {
            mainHandChanged = true;
        }
        if (ItemSwitchHandler.canSwitchItem(offHandItem, livingEntity, originalItem)) {
            offHandChanged = true;
        }
        if (mainHandChanged) {
            Item originalMainItem = mainHandItem.m_41720_();
            ItemSwitchHandler.replaceItem(livingEntity, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)targetItem), mainHandItem);
            ItemSwitchHandler.playSoundOnServer((ServerLevel)level, x, y, z, soundEvent, entity);
            if (livingEntity.m_5842_() && level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                ItemSwitchHandler.spawnBubbleParticles(serverLevel, livingEntity, InteractionHand.MAIN_HAND);
            }
            if (livingEntity instanceof Player) {
                player = (Player)livingEntity;
                ItemSwitchHandler.applyCooldown(player, originalMainItem, mainHandCooldown);
                ItemSwitchHandler.applyCooldown(player, targetItem, mainHandCooldown);
            }
        }
        if (offHandChanged) {
            Item originalOffItem = offHandItem.m_41720_();
            ItemSwitchHandler.replaceItem(livingEntity, InteractionHand.OFF_HAND, new ItemStack((ItemLike)targetItem), offHandItem);
            ItemSwitchHandler.playSoundOnServer((ServerLevel)level, x, y, z, soundEvent, entity);
            if (livingEntity.m_5842_() && level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                ItemSwitchHandler.spawnBubbleParticles(serverLevel, livingEntity, InteractionHand.OFF_HAND);
            }
            if (livingEntity instanceof Player) {
                player = (Player)livingEntity;
                ItemSwitchHandler.applyCooldown(player, originalOffItem, offHandCooldown);
                ItemSwitchHandler.applyCooldown(player, targetItem, offHandCooldown);
            }
        }
        if (mainHandChanged || offHandChanged) {
            ItemStack otherHandItem = mainHandChanged ? offHandItem : mainHandItem;
            Item otherItem = otherHandItem.m_41720_();
            boolean applyCooldownToOther = true;
            if (!otherHandItem.m_41619_()) {
                if (noCooldownItems != null && !noCooldownItems.isEmpty()) {
                    for (Item item : noCooldownItems) {
                        if (otherItem != item) continue;
                        applyCooldownToOther = false;
                        break;
                    }
                }
                if (applyCooldownToOther && noCooldownTags != null && !noCooldownTags.isEmpty()) {
                    for (ResourceLocation tag : noCooldownTags) {
                        if (!otherHandItem.m_204117_(ItemTags.create((ResourceLocation)tag))) continue;
                        applyCooldownToOther = false;
                        break;
                    }
                }
            }
            if (applyCooldownToOther && otherItem != targetItem && livingEntity instanceof Player) {
                Player player2 = (Player)livingEntity;
                int otherCooldown = mainHandChanged ? offHandCooldown : mainHandCooldown;
                ItemSwitchHandler.applyCooldown(player2, otherItem, otherCooldown);
            }
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            serverPlayer.m_150109_().m_6596_();
        }
    }

    private static boolean canSwitchItem(ItemStack stack, LivingEntity entity, Item originalItem) {
        if (stack.m_41619_() || stack.m_41720_() != originalItem) {
            return false;
        }
        Item currentItem = stack.m_41720_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.m_36335_().m_41519_(currentItem);
        }
        return true;
    }

    private static void replaceItem(LivingEntity entity, InteractionHand hand, ItemStack newItem, ItemStack oldItem) {
        CompoundTag nbt = oldItem.m_41783_();
        if (nbt != null) {
            newItem.m_41751_(nbt.m_6426_());
        }
        newItem.m_41764_(oldItem.m_41613_());
        entity.m_21008_(hand, newItem);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.m_150109_().m_6596_();
        }
    }

    private static void applyCooldown(Player player, Item item, int cooldownTicks) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (item != null && cooldownTicks > 0 && !serverPlayer.m_36335_().m_41519_(item)) {
                serverPlayer.m_36335_().m_41524_(item, cooldownTicks);
            }
        }
    }

    private static void playSoundOnServer(ServerLevel level, double x, double y, double z, String soundEvent, Entity entity) {
        SoundEvent sound = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(soundEvent));
        SoundSource source = entity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
        level.m_6263_(null, x, y, z, sound, source, 1.0f, 1.0f);
    }

    private static void spawnBubbleParticles(ServerLevel serverLevel, LivingEntity entity, InteractionHand hand) {
        if (serverLevel.m_5776_()) {
            return;
        }
        RandomSource random = serverLevel.f_46441_;
        Vec3 handPos = ItemSwitchHandler.getHandPosition(entity, hand);
        int particleCount = 5;
        for (int i = 0; i < particleCount; ++i) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, handPos.f_82479_ + (random.m_188500_() - 0.5) * 0.2, handPos.f_82480_ + (random.m_188500_() - 0.5) * 0.2, handPos.f_82481_ + (random.m_188500_() - 0.5) * 0.2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static Vec3 getHandPosition(LivingEntity entity, InteractionHand hand) {
        Vec3 lookVec = entity.m_20154_().m_82541_();
        double offsetX = hand == InteractionHand.MAIN_HAND ? 0.4 : -0.4;
        Vec3 sideVec = lookVec.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_(offsetX);
        return new Vec3(entity.m_20185_() + sideVec.f_82479_, entity.m_20186_() + (double)entity.m_20192_() * 0.5, entity.m_20189_() + sideVec.f_82481_);
    }
}

