/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.mechanics;

import net.jaams.jaams_weaponry.weapons.ScytheItem;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class PullTowardsHandler {
    public static void pullEnemyTowardsPlayer(LivingEntity entity, LivingEntity sourceEntity, float attackStrength, ItemStack itemStack, float basePullStrength, float maxPullDistance, double maxPullSpeed, float attackStrengthPullModifier, double baseMovementSpeed, float maxVerticalPull, float verticalPullDampening, float pullDistanceScaling, int durabilityCostPull) {
        PullTowardsHandler.applyPull(entity, sourceEntity, attackStrength, itemStack, basePullStrength, maxPullDistance, maxPullSpeed, attackStrengthPullModifier, baseMovementSpeed, maxVerticalPull, verticalPullDampening, pullDistanceScaling, durabilityCostPull, false);
    }

    public static void pullTowardsEnemy(LivingEntity entity, LivingEntity sourceEntity, float attackStrength, ItemStack itemStack, float basePullStrength, float maxPullDistance, double maxPullSpeed, float attackStrengthPullModifier, double baseMovementSpeed, float maxVerticalPull, float verticalPullDampening, float pullDistanceScaling, int durabilityCostPull) {
        boolean isSneaking = sourceEntity.m_6144_();
        LivingEntity pulledEntity = isSneaking ? entity : sourceEntity;
        LivingEntity targetEntity = isSneaking ? sourceEntity : entity;
        PullTowardsHandler.applyPull(pulledEntity, targetEntity, attackStrength, itemStack, basePullStrength, maxPullDistance, maxPullSpeed, attackStrengthPullModifier, baseMovementSpeed, maxVerticalPull, verticalPullDampening, pullDistanceScaling, durabilityCostPull, pulledEntity == sourceEntity);
    }

    private static void applyPull(LivingEntity pulledEntity, LivingEntity targetEntity, float attackStrength, ItemStack itemStack, float basePullStrength, float maxPullDistance, double maxPullSpeed, float attackStrengthPullModifier, double baseMovementSpeed, float maxVerticalPull, float verticalPullDampening, float pullDistanceScaling, int durabilityCostPull, boolean isPullingSelf) {
        Vec3 currentMotion;
        Vec3 newMotion;
        if (pulledEntity.m_20270_((Entity)targetEntity) > maxPullDistance) {
            return;
        }
        Vec3 pulledPos = pulledEntity.m_20182_();
        Vec3 targetPos = targetEntity.m_20182_();
        double distance = pulledEntity.m_20270_((Entity)targetEntity);
        if (distance < 0.001) {
            return;
        }
        Vec3 direction = targetPos.m_82546_(pulledPos).m_82541_();
        float pullFactor = Math.min(1.0f, (float)distance / maxPullDistance) * pullDistanceScaling;
        double pullMultiplier = basePullStrength * pullFactor * attackStrength * attackStrengthPullModifier;
        double knockbackResistance = Math.max(0.0, Math.min(1.0, pulledEntity.m_21133_(Attributes.f_22278_)));
        double knockbackReduction = isPullingSelf ? knockbackResistance * 1.2 : 1.0 - Math.pow(1.0 - knockbackResistance, 4.0);
        pullMultiplier *= 1.0 - knockbackReduction;
        double movementSpeed = pulledEntity.m_21133_(Attributes.f_22279_);
        double movementSpeedMultiplier = Math.max(0.1, movementSpeed / baseMovementSpeed);
        double heightDiff = targetPos.f_82480_ - pulledPos.f_82480_;
        double verticalDampening = 1.0 / (1.0 + Math.abs(heightDiff) * (double)verticalPullDampening);
        double verticalPull = direction.f_82480_ * verticalDampening;
        Vec3 pullMotion = new Vec3(direction.f_82479_, Math.max((double)(-maxVerticalPull), Math.min((double)maxVerticalPull, verticalPull)), direction.f_82481_).m_82541_().m_82490_(pullMultiplier *= movementSpeedMultiplier);
        double distanceToTarget = targetPos.m_82546_(pulledPos).m_82553_();
        if (pullMotion.m_82553_() > distanceToTarget) {
            pullMotion = pullMotion.m_82541_().m_82490_(distanceToTarget * 0.99);
        }
        if ((newMotion = (currentMotion = pulledEntity.m_20184_()).m_82490_(0.5).m_82549_(pullMotion)).m_82553_() > maxPullSpeed) {
            newMotion = newMotion.m_82541_().m_82490_(maxPullSpeed);
        }
        pulledEntity.m_20256_(newMotion);
        pulledEntity.f_19864_ = true;
        if (itemStack != null && (itemStack.m_41720_() instanceof ScytheItem || !isPullingSelf)) {
            itemStack.m_41622_(durabilityCostPull, targetEntity, p -> p.m_21190_(targetEntity.m_7655_()));
        }
        pulledEntity.m_9236_().m_6263_(null, pulledEntity.m_20182_().f_82479_, pulledEntity.m_20182_().f_82480_, pulledEntity.m_20182_().f_82481_, SoundEvents.f_12316_, SoundSource.PLAYERS, 1.0f, 1.0f);
        PullTowardsHandler.updateClientMotion(pulledEntity);
    }

    private static void updateClientMotion(LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)entity));
        } else if (!entity.m_9236_().f_46443_) {
            entity.m_9236_().m_45933_(null, entity.m_20191_().m_82400_(10.0)).stream().filter(e -> e instanceof ServerPlayer).forEach(e -> ((ServerPlayer)e).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)entity)));
        }
    }
}

