/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.mechanics;

import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModMobEffects;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModSounds;
import net.jaams.jaams_weaponry.particles.CustomSmokeParticleData;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SlamAttackHandler {
    private static final float DEBUFF_REDUCTION_PER_LEVEL = 0.1f;

    private static float calculateDamage(ItemStack itemStack, Player player, boolean isArthropod, boolean isUndead) {
        int smiteLevel;
        int baneLevel;
        float baseDamage = itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().findFirst().map(modifier -> Float.valueOf((float)modifier.m_22218_())).orElse(Float.valueOf(1.0f)).floatValue();
        float playerAttackDamage = (float)player.m_21133_(Attributes.f_22281_);
        float strengthMultiplier = 1.0f;
        if (player != null) {
            MobEffectInstance warriorsGrace;
            MobEffectInstance strength = player.m_21124_(MobEffects.f_19600_);
            if (strength != null) {
                strengthMultiplier += 0.1f * (float)(strength.m_19564_() + 1);
            }
            if ((warriorsGrace = player.m_21124_((MobEffect)JaamsWeaponryModMobEffects.WARRIORS_GRACE.get())) != null) {
                strengthMultiplier += 0.05f * (float)(warriorsGrace.m_19564_() + 1);
            }
        }
        float totalDamage = (baseDamage + playerAttackDamage) * strengthMultiplier;
        if (isArthropod && (baneLevel = itemStack.getEnchantmentLevel(Enchantments.f_44979_)) > 0) {
            totalDamage += (float)baneLevel * 2.5f;
        }
        if (isUndead && (smiteLevel = itemStack.getEnchantmentLevel(Enchantments.f_44978_)) > 0) {
            totalDamage += (float)smiteLevel * 2.5f;
        }
        return totalDamage;
    }

    private static float calculateDebuffReductionFactor(Player player) {
        float reductionFactor = 1.0f;
        if (player != null) {
            MobEffectInstance depletion;
            MobEffectInstance weakness = player.m_21124_(MobEffects.f_19613_);
            if (weakness != null) {
                reductionFactor -= 0.1f * (float)(weakness.m_19564_() + 1);
            }
            if ((depletion = player.m_21124_((MobEffect)JaamsWeaponryModMobEffects.DEPLETION.get())) != null) {
                reductionFactor -= 0.1f * (float)(depletion.m_19564_() + 1);
            }
        }
        return Math.max(0.1f, reductionFactor);
    }

    public static void applyAreaAttack(Player player, Level level, ItemStack itemStack, BlockPos impactPos, float attackStrength, float baseDamageMultiplier, float maxBonusDamage, float maxResidualDamage, float smashRadius, float minKnockbackStrength, float maxKnockbackStrength, float knockbackScalingFactor, int particleCount, float shakeIntensity, int shakeResetDelay, int smashDurabilityDamageBase, int smashMaxDurabilityDamage, float exhaustion, float depletionChance, int depletionLevel, int depletionDuration, int depletionMaxLevel, int depletionMaxDuration, boolean enableDepletion, float playerVerticalImpulse, float entityVerticalImpulse) {
        if (level.m_5776_() || player == null || itemStack == null || impactPos == null) {
            return;
        }
        float debuffReductionFactor = SlamAttackHandler.calculateDebuffReductionFactor(player);
        float adjustedAttackStrength = attackStrength * debuffReductionFactor;
        float adjustedMinKnockbackStrength = minKnockbackStrength * debuffReductionFactor;
        float adjustedMaxKnockbackStrength = maxKnockbackStrength * debuffReductionFactor;
        int adjustedParticleCount = Math.max(1, (int)((float)particleCount * debuffReductionFactor));
        float adjustedPlayerVerticalImpulse = playerVerticalImpulse * debuffReductionFactor;
        float adjustedShakeIntensity = shakeIntensity * debuffReductionFactor;
        float weaponDamage = SlamAttackHandler.calculateDamage(itemStack, player, false, false);
        float baseSlamDamage = Math.min(weaponDamage * baseDamageMultiplier, maxBonusDamage) * adjustedAttackStrength;
        SlamAttackHandler.spawnBlockParticles(level, impactPos, adjustedParticleCount, smashRadius, player);
        SlamAttackHandler.playSlamSound(level, impactPos);
        SlamAttackHandler.applyShockwave(player, level, itemStack, impactPos, adjustedAttackStrength, smashRadius, baseSlamDamage, maxResidualDamage, adjustedMinKnockbackStrength, adjustedMaxKnockbackStrength, knockbackScalingFactor, entityVerticalImpulse);
        SlamAttackHandler.applyShakeEffects(player, level, impactPos, smashRadius, adjustedShakeIntensity, shakeResetDelay);
        SlamAttackHandler.applyPlayerVerticalImpulse(player, weaponDamage, adjustedPlayerVerticalImpulse);
        SlamAttackHandler.applyDurabilityDamage(player, itemStack, smashDurabilityDamageBase, smashMaxDurabilityDamage);
        if (!player.m_7500_()) {
            player.m_36399_(exhaustion);
        }
        SlamAttackHandler.applyDepletionEffect(level, player, depletionChance, depletionLevel, depletionDuration, depletionMaxLevel, depletionMaxDuration, enableDepletion);
    }

    public static void applyCriticalKnockedUpEffect(Player player, LivingEntity target, float criticalChance, int duration, int level) {
        if (player == null || target == null || player.m_9236_().m_5776_()) {
            return;
        }
        if (player.m_9236_().f_46441_.m_188501_() < criticalChance) {
            MobEffectInstance knockedUpEffect = new MobEffectInstance((MobEffect)JaamsWeaponryModMobEffects.KNOCKED_UP.get(), duration, level - 1, false, false, true);
            target.m_7292_(knockedUpEffect);
        }
    }

    private static void applyShockwave(Player player, Level level, ItemStack itemStack, BlockPos impactPos, float attackStrength, float smashRadius, float baseSlamDamage, float maxResidualDamage, float minKnockbackStrength, float maxKnockbackStrength, float knockbackScalingFactor, float entityVerticalImpulse) {
        AABB affectedArea = new AABB(impactPos).m_82377_((double)smashRadius, 0.5, (double)smashRadius);
        Vec3 impactCenter = Vec3.m_82512_((Vec3i)impactPos);
        float baseKnockback = SlamAttackHandler.calculateKnockback(minKnockbackStrength, maxKnockbackStrength, knockbackScalingFactor);
        DamageSource damageSource = new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("jaams_weaponry:smash"))), (Entity)player);
        int fireAspectLevel = itemStack.getEnchantmentLevel(Enchantments.f_44981_);
        int knockbackLevel = itemStack.getEnchantmentLevel(Enchantments.f_44980_);
        if (fireAspectLevel > 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, (double)impactPos.m_123341_() + 0.5, (double)impactPos.m_123342_() + 0.5, (double)impactPos.m_123343_() + 0.5, 5, 0.2, 0.2, 0.2, 0.0);
        }
        level.m_6249_((Entity)player, affectedArea, e -> e.m_6084_() && !(e instanceof ItemEntity)).forEach(entity -> {
            double distance;
            float distanceFactor;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                boolean isArthropod = livingEntity.m_6336_() == MobType.f_21642_;
                boolean isUndead = livingEntity.m_6336_() == MobType.f_21641_;
                float weaponDamage = SlamAttackHandler.calculateDamage(itemStack, player, isArthropod, isUndead);
                double distance2 = entity.m_20182_().m_82554_(impactCenter);
                float distanceFactor2 = Math.max(0.0f, 1.0f - (float)(distance2 / (double)smashRadius));
                float effectiveDamage = Math.min(weaponDamage * 0.3f, maxResidualDamage) * attackStrength * distanceFactor2;
                if (effectiveDamage > 0.0f) {
                    livingEntity.m_6469_(damageSource, effectiveDamage);
                    if (fireAspectLevel > 0) {
                        livingEntity.m_20254_(fireAspectLevel * 4);
                    }
                    if (!player.m_7500_() && livingEntity instanceof Mob) {
                        Mob mob = (Mob)livingEntity;
                        mob.m_6710_((LivingEntity)player);
                    }
                }
                SlamAttackHandler.applyEntityKnockback(livingEntity, impactCenter, baseKnockback, attackStrength, distanceFactor2, entityVerticalImpulse, knockbackLevel);
            } else if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                double distance3 = entity.m_20182_().m_82554_(impactCenter);
                float distanceFactor3 = Math.max(0.0f, 1.0f - (float)(distance3 / (double)smashRadius));
                if (distanceFactor3 > 0.0f) {
                    AbstractArrow arrow;
                    if (projectile instanceof AbstractArrow && (arrow = (AbstractArrow)projectile).m_20184_().m_82556_() < 0.001) {
                        arrow.m_36790_(false);
                        arrow.m_20334_(0.0, 0.2 * (double)entityVerticalImpulse * (double)distanceFactor3, 0.0);
                    }
                    Vec3 currentMotion = projectile.m_20184_();
                    Vec3 newMotion = currentMotion.m_82490_(-0.1 * (double)attackStrength * (double)distanceFactor3).m_82520_(0.0, 0.1 * (double)entityVerticalImpulse * (double)distanceFactor3, 0.0);
                    projectile.m_20256_(newMotion);
                    projectile.m_146922_(projectile.m_146908_() + 180.0f);
                    projectile.f_19859_ = projectile.m_146908_();
                    projectile.f_19864_ = true;
                }
            } else if (entity.m_6094_() && (distanceFactor = Math.max(0.0f, 1.0f - (float)((distance = entity.m_20182_().m_82554_(impactCenter)) / (double)smashRadius))) > 0.0f) {
                double knockbackResistance = 0.0;
                double knockbackReduction = 1.0 - Math.pow(1.0 - knockbackResistance, 3.0);
                double movementSpeed = entity instanceof Boat || entity instanceof Minecart ? 0.1 : 0.4;
                double movementSpeedMultiplier = Math.max(0.1, movementSpeed / 0.1);
                float effectiveKnockback = baseKnockback * (1.0f - (float)knockbackReduction) * attackStrength * distanceFactor * (float)movementSpeedMultiplier;
                if ((effectiveKnockback += (float)knockbackLevel * 0.4f) > 0.0f) {
                    Vec3 knockbackVector = entity.m_20182_().m_82546_(impactCenter).m_82541_().m_82490_((double)effectiveKnockback).m_82520_(0.0, Mth.m_14008_((double)(0.2 * movementSpeedMultiplier), (double)0.1, (double)entityVerticalImpulse), 0.0);
                    knockbackVector = new Vec3(Mth.m_14008_((double)knockbackVector.f_82479_, (double)-1.2, (double)1.2), Mth.m_14008_((double)knockbackVector.f_82480_, (double)0.0, (double)entityVerticalImpulse), Mth.m_14008_((double)knockbackVector.f_82481_, (double)-1.2, (double)1.2));
                    entity.m_5997_(knockbackVector.f_82479_, knockbackVector.f_82480_, knockbackVector.f_82481_);
                    entity.f_19864_ = true;
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entity));
                    } else if (!entity.m_9236_().m_5776_()) {
                        entity.m_9236_().m_45933_(null, entity.m_20191_().m_82400_(10.0)).stream().filter(e -> e instanceof ServerPlayer).forEach(e -> ((ServerPlayer)e).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entity)));
                    }
                }
            }
        });
    }

    private static void applyEntityKnockback(LivingEntity entity, Vec3 impactCenter, float baseKnockback, float attackStrength, float distanceFactor, float entityVerticalImpulse, int knockbackLevel) {
        double knockbackResistance = Math.max(0.0, Math.min(1.0, entity.m_21133_(Attributes.f_22278_)));
        double knockbackReduction = 1.0 - Math.pow(1.0 - knockbackResistance, 3.0);
        double movementSpeed = entity.m_21133_(Attributes.f_22279_);
        double movementSpeedMultiplier = Math.max(0.1, movementSpeed / 0.1);
        float effectiveKnockback = baseKnockback * (1.0f - (float)knockbackReduction) * attackStrength * distanceFactor * (float)movementSpeedMultiplier;
        if ((effectiveKnockback += (float)knockbackLevel * 0.4f) > 0.0f) {
            Vec3 knockbackVector = entity.m_20182_().m_82546_(impactCenter).m_82541_().m_82490_((double)effectiveKnockback).m_82520_(0.0, Mth.m_14008_((double)(0.2 * movementSpeedMultiplier), (double)0.1, (double)entityVerticalImpulse), 0.0);
            knockbackVector = new Vec3(Mth.m_14008_((double)knockbackVector.f_82479_, (double)-1.2, (double)1.2), Mth.m_14008_((double)knockbackVector.f_82480_, (double)0.0, (double)entityVerticalImpulse), Mth.m_14008_((double)knockbackVector.f_82481_, (double)-1.2, (double)1.2));
            entity.m_5997_(knockbackVector.f_82479_, knockbackVector.f_82480_, knockbackVector.f_82481_);
            entity.f_19864_ = true;
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)entity));
            } else if (!entity.m_9236_().m_5776_()) {
                entity.m_9236_().m_45933_(null, entity.m_20191_().m_82400_(10.0)).stream().filter(e -> e instanceof ServerPlayer).forEach(e -> ((ServerPlayer)e).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)entity)));
            }
        }
    }

    private static void applyPlayerVerticalImpulse(Player player, float weaponDamage, float playerVerticalImpulse) {
        double knockbackResistance = Math.max(0.0, Math.min(1.0, player.m_21133_(Attributes.f_22278_)));
        double knockbackReduction = 1.0 - Math.pow(1.0 - knockbackResistance, 3.0);
        double movementSpeed = player.m_21133_(Attributes.f_22279_);
        double movementSpeedMultiplier = Math.max(0.1, movementSpeed / 0.1);
        float damageScaling = Math.min(1.0f + weaponDamage / 10.0f, 2.0f);
        float effectiveImpulse = playerVerticalImpulse * damageScaling * (float)(1.0 - knockbackReduction) * (float)movementSpeedMultiplier;
        if ((effectiveImpulse = Mth.m_14036_((float)effectiveImpulse, (float)0.3f, (float)playerVerticalImpulse)) > 0.0f) {
            player.m_5997_(0.0, (double)effectiveImpulse, 0.0);
            player.f_19864_ = true;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
            }
        }
    }

    private static void spawnBlockParticles(Level level, BlockPos impactPos, int particleCount, float smashRadius, Player player) {
        ServerLevel serverLevel;
        block10: {
            block9: {
                if (!(level instanceof ServerLevel)) break block9;
                serverLevel = (ServerLevel)level;
                if (impactPos != null && player != null) break block10;
            }
            return;
        }
        int radius = (int)Math.ceil(smashRadius);
        int particlesPerBlock = Math.max(1, particleCount / (radius * radius));
        int smokeParticlesPerBlock = Math.max(1, particlesPerBlock / 5);
        int bubbleParticlesPerBlock = Math.max(3, particlesPerBlock * 2);
        RandomSource random = level.f_46441_;
        boolean isUnderWater = player.m_5842_();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                double offsetZ;
                double offsetX;
                double distance;
                double maxDistance;
                double angle;
                int i;
                BlockPos pos;
                BlockState state;
                double distanceSquared = x * x + z * z;
                if (distanceSquared > (double)(smashRadius * smashRadius) || (state = level.m_8055_(pos = impactPos.m_7918_(x, 0, z))).m_60795_()) continue;
                double yPos = (double)pos.m_123342_() + 1.0 + 0.05;
                for (i = 0; i < particlesPerBlock; ++i) {
                    angle = random.m_188500_() * 2.0 * Math.PI;
                    double blockDistance = random.m_188500_() * 0.3;
                    double offsetX2 = Math.cos(angle) * blockDistance;
                    double offsetZ2 = Math.sin(angle) * blockDistance;
                    double velocityY = 0.15 + random.m_188500_() * 0.25;
                    serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + 0.5 + offsetX2, yPos, (double)pos.m_123343_() + 0.5 + offsetZ2, 1, 0.1, velocityY, 0.1, 0.08);
                }
                if (isUnderWater) {
                    for (i = 0; i < bubbleParticlesPerBlock; ++i) {
                        angle = random.m_188500_() * 2.0 * Math.PI;
                        maxDistance = 0.6 * (1.0 - Math.sqrt(distanceSquared) / (double)smashRadius);
                        distance = random.m_188500_() * maxDistance;
                        offsetX = Math.cos(angle) * distance;
                        offsetZ = Math.sin(angle) * distance;
                        double velocityY = 0.3 + random.m_188500_() * 0.4;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, (double)pos.m_123341_() + 0.5 + offsetX, player.m_20182_().f_82480_ + 0.3, (double)pos.m_123343_() + 0.5 + offsetZ, 1, 0.1, velocityY, 0.1, 0.1);
                    }
                    continue;
                }
                for (i = 0; i < smokeParticlesPerBlock; ++i) {
                    angle = random.m_188500_() * 2.0 * Math.PI;
                    maxDistance = 0.6 * (1.0 - Math.sqrt(distanceSquared) / (double)smashRadius);
                    distance = random.m_188500_() * maxDistance;
                    offsetX = Math.cos(angle) * distance;
                    offsetZ = Math.sin(angle) * distance;
                    float baseSize = 0.65f;
                    float sizeVariation = random.m_188501_() * 0.35f;
                    float grayScale = 0.5f + random.m_188501_() * 0.4f;
                    CustomSmokeParticleData smokeParticle = new CustomSmokeParticleData(grayScale, grayScale, grayScale, Mth.m_14036_((float)(baseSize + sizeVariation), (float)0.2f, (float)1.8f));
                    serverLevel.m_8767_((ParticleOptions)smokeParticle, (double)pos.m_123341_() + 0.5 + offsetX, player.m_20182_().f_82480_ + 0.3, (double)pos.m_123343_() + 0.5 + offsetZ, 1, 0.08, 0.15 + random.m_188500_() * 0.2, 0.08, 0.04);
                }
            }
        }
    }

    private static void playSlamSound(Level level, BlockPos impactPos) {
        level.m_5594_(null, impactPos, SoundEvents.f_11913_, SoundSource.PLAYERS, 0.9f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
        level.m_5594_(null, impactPos, (SoundEvent)JaamsWeaponryModSounds.HAMMER_SLAM.get(), SoundSource.PLAYERS, 0.9f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
    }

    private static float calculateKnockback(float minKnockbackStrength, float maxKnockbackStrength, float knockbackScalingFactor) {
        return minKnockbackStrength + (maxKnockbackStrength - minKnockbackStrength) * knockbackScalingFactor;
    }

    private static void applyShakeEffects(Player player, Level level, BlockPos impactPos, float smashRadius, float shakeIntensity, int shakeResetDelay) {
        ModUtils.applyShakeEffect((Entity)player, shakeIntensity * 0.8f, shakeResetDelay);
        AABB affectedArea = new AABB(impactPos).m_82377_((double)smashRadius, 0.5, (double)smashRadius);
        level.m_6443_(Player.class, affectedArea, p -> p != player && p.m_6084_()).forEach(p -> ModUtils.applyShakeEffect((Entity)p, shakeIntensity * 0.6f, shakeResetDelay));
    }

    private static void applyDurabilityDamage(Player player, ItemStack itemStack, int smashDurabilityDamageBase, int smashMaxDurabilityDamage) {
        int durabilityDamage = Math.min(smashDurabilityDamageBase, smashMaxDurabilityDamage);
        itemStack.m_41622_(durabilityDamage, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
    }

    private static void applyDepletionEffect(Level level, Player player, float depletionChance, int depletionLevel, int depletionDuration, int depletionMaxLevel, int depletionMaxDuration, boolean enableDepletion) {
        if (!enableDepletion || !((Boolean)JaamsWeaponryCommonConfiguration.DEPLETION.get()).booleanValue() || level.m_5776_() || player == null) {
            return;
        }
        if (level.f_46441_.m_188501_() < depletionChance) {
            int calculatedDepletionLevel = Math.min(depletionLevel, depletionMaxLevel);
            int calculatedDepletionDuration = Math.min(depletionDuration, depletionMaxDuration);
            MobEffectInstance depletionEffect = new MobEffectInstance((MobEffect)JaamsWeaponryModMobEffects.DEPLETION.get(), calculatedDepletionDuration, calculatedDepletionLevel - 1, false, false, true);
            player.m_7292_(depletionEffect);
        }
    }
}

