/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.mechanics;

import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModMobEffects;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SmashAttackHandler {
    public static void applySmashLogic(LivingEntity attacker, LivingEntity target, ItemStack itemstack, float attackStrength, float fallDistance, float damagePerBlock, float maxBonusDamage, float residualDamageBase, float residualDamagePerBlock, float maxResidualDamage, float smashRadius, float minKnockbackStrength, float maxKnockbackStrength, float knockbackScalingFactor, int particleCount, float maxEffectiveFallDistance, float shakeIntensity, int shakeResetDelay, float allyDamageMultiplier, int smashDurabilityDamageBase, float smashDurabilityDamagePerBlock, int smashMaxDurabilityDamage, float knockedUpBaseChance, float knockedUpChancePerBlock, int knockedUpDuration, int knockedUpLevel, float depletionChance, int depletionLevel, int depletionDuration, float depletionBlocksPerLevel, float depletionTicksPerBlock, int depletionMaxLevel, int depletionMaxDuration, boolean enableDepletion) {
        Player player;
        float effectiveFallDistance = Math.min(fallDistance, maxEffectiveFallDistance);
        float damageBonus = Math.min(effectiveFallDistance * damagePerBlock, maxBonusDamage) * attackStrength;
        attacker.getPersistentData().m_128379_("SmashActive", true);
        ModUtils.applySmashDamage(attacker, target, itemstack, damageBonus);
        SmashAttackHandler.applySmashKnockedUpEffect(attacker, target, effectiveFallDistance, knockedUpBaseChance, knockedUpChancePerBlock, knockedUpDuration, knockedUpLevel);
        SmashAttackHandler.applyShockwave(attacker, target, attacker.m_9236_(), itemstack, effectiveFallDistance, attackStrength, smashRadius, residualDamageBase, residualDamagePerBlock, maxResidualDamage, minKnockbackStrength, maxKnockbackStrength, knockbackScalingFactor, allyDamageMultiplier);
        ModUtils.applyShakeEffect((Entity)attacker, shakeIntensity, shakeResetDelay);
        ModUtils.applyShakeEffect((Entity)target, shakeIntensity, shakeResetDelay);
        SmashAttackHandler.applyDepletionEffect(attacker.m_9236_(), attacker, effectiveFallDistance, depletionChance, depletionLevel, depletionDuration, depletionBlocksPerLevel, depletionTicksPerBlock, depletionMaxLevel, depletionMaxDuration, enableDepletion);
        SmashAttackHandler.spawnBlockParticles(attacker.m_9236_(), target.m_20183_(), particleCount, effectiveFallDistance, maxEffectiveFallDistance);
        SmashAttackHandler.spawnCritParticles(attacker.m_9236_(), target, particleCount);
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11913_, attacker instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE, 0.8f, 1.0f);
        attacker.f_19789_ = 0.0f;
        if (attacker instanceof Player) {
            player = (Player)attacker;
            player.m_36399_(0.1f);
        }
        if (!(attacker instanceof Player) || !(player = (Player)attacker).m_7500_()) {
            int durabilityDamage = smashDurabilityDamageBase + Math.round(effectiveFallDistance * smashDurabilityDamagePerBlock);
            if ((durabilityDamage = Math.min(durabilityDamage, smashMaxDurabilityDamage)) > 0) {
                itemstack.m_41622_(durabilityDamage, attacker, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
    }

    public static void applyCriticalKnockedUpEffect(LivingEntity attacker, LivingEntity entity, float knockedUpCriticalChance, int knockedUpDuration, int knockedUpLevel) {
        ArmorItem armor;
        Item item;
        ItemStack helmet = entity.m_6844_(EquipmentSlot.HEAD);
        if (!helmet.m_41619_() && (item = helmet.m_41720_()) instanceof ArmorItem && (armor = (ArmorItem)item).m_40401_() != ArmorMaterials.LEATHER && attacker.m_9236_().f_46441_.m_188501_() < knockedUpCriticalChance) {
            entity.m_7292_(new MobEffectInstance((MobEffect)JaamsWeaponryModMobEffects.KNOCKED_UP.get(), knockedUpDuration, knockedUpLevel, true, false, true));
            if (!(entity instanceof Player)) {
                ModUtils.playSound((Entity)entity, "jaams_weaponry:knocked_up_started");
            }
        }
    }

    public static void applySmashKnockedUpEffect(LivingEntity attacker, LivingEntity entity, float fallDistance, float knockedUpBaseChance, float knockedUpChancePerBlock, int knockedUpDuration, int knockedUpLevel) {
        ArmorItem armor;
        Item item;
        ItemStack helmet = entity.m_6844_(EquipmentSlot.HEAD);
        if (!helmet.m_41619_() && (item = helmet.m_41720_()) instanceof ArmorItem && (armor = (ArmorItem)item).m_40401_() != ArmorMaterials.LEATHER) {
            float knockUpChance = knockedUpBaseChance + fallDistance * knockedUpChancePerBlock;
            knockUpChance = Math.min(knockUpChance, 1.0f);
            if (attacker.m_9236_().f_46441_.m_188501_() < knockUpChance) {
                entity.m_7292_(new MobEffectInstance((MobEffect)JaamsWeaponryModMobEffects.KNOCKED_UP.get(), knockedUpDuration, knockedUpLevel, true, false, true));
                if (!(entity instanceof Player)) {
                    ModUtils.playSound((Entity)entity, "jaams_weaponry:knocked_up_started");
                }
            }
        }
    }

    public static void applyDepletionEffect(Level level, LivingEntity attacker, float fallDistance, float depletionChance, int depletionLevel, int depletionDuration, float depletionBlocksPerLevel, float depletionTicksPerBlock, int depletionMaxLevel, int depletionMaxDuration, boolean enableDepletion) {
        if (!enableDepletion || !((Boolean)JaamsWeaponryCommonConfiguration.DEPLETION.get()).booleanValue() || level.m_5776_()) {
            return;
        }
        if (level.f_46441_.m_188501_() < depletionChance) {
            int calculatedDepletionLevel = depletionLevel + (int)(fallDistance / depletionBlocksPerLevel);
            calculatedDepletionLevel = Math.min(calculatedDepletionLevel, depletionMaxLevel);
            int calculatedDepletionDuration = depletionDuration + (int)(fallDistance * depletionTicksPerBlock);
            calculatedDepletionDuration = Math.min(calculatedDepletionDuration, depletionMaxDuration);
            MobEffectInstance depletionEffect = new MobEffectInstance((MobEffect)JaamsWeaponryModMobEffects.DEPLETION.get(), calculatedDepletionDuration, calculatedDepletionLevel - 1, false, false, true);
            if (depletionEffect.m_19544_() != null) {
                attacker.m_7292_(depletionEffect);
            }
        }
    }

    public static void applyShockwave(LivingEntity attacker, LivingEntity target, Level level, ItemStack itemstack, float fallDistance, float attackStrength, float smashRadius, float residualDamageBase, float residualDamagePerBlock, float maxResidualDamage, float minKnockbackStrength, float maxKnockbackStrength, float knockbackScalingFactor, float allyDamageMultiplier) {
        AABB area = new AABB(target.m_20183_()).m_82377_((double)smashRadius, 0.5, (double)smashRadius);
        float residualDamage = Math.min(residualDamageBase + fallDistance * residualDamagePerBlock, maxResidualDamage) * attackStrength;
        float knockbackStrength = SmashAttackHandler.calculateKnockback(fallDistance, minKnockbackStrength, maxKnockbackStrength, knockbackScalingFactor);
        DamageSource damageSource = new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("jaams_weaponry:smash"))), (Entity)attacker);
        level.m_6249_((Entity)attacker, area, e -> e != target && e.m_6084_() && !(e instanceof ItemEntity)).forEach(entity -> {
            float f;
            Player player;
            float effectiveDamage = residualDamage;
            if (attacker instanceof Player && ModUtils.isAlliedEntity(player = (Player)attacker, entity)) {
                effectiveDamage *= allyDamageMultiplier;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (effectiveDamage > 0.0f) {
                    livingEntity.m_6469_(damageSource, effectiveDamage);
                }
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                f = (float)living.m_21133_(Attributes.f_22278_);
            } else {
                f = 0.0f;
            }
            float knockbackResistance = f;
            float effectiveKnockback = knockbackStrength * (1.0f - knockbackResistance);
            if (effectiveKnockback > 0.0f) {
                Vec3 knockbackVector = entity.m_20182_().m_82546_(target.m_20182_()).m_82541_().m_82490_((double)effectiveKnockback).m_82520_(0.0, 0.3, 0.0);
                entity.m_5997_(knockbackVector.f_82479_, Math.min(knockbackVector.f_82480_, 0.5), knockbackVector.f_82481_);
            }
        });
    }

    public static float calculateKnockback(float fallDistance, float minKnockbackStrength, float maxKnockbackStrength, float knockbackScalingFactor) {
        float t = Math.min(fallDistance * knockbackScalingFactor, 1.0f);
        return minKnockbackStrength + t * (maxKnockbackStrength - minKnockbackStrength);
    }

    public static void spawnBlockParticles(Level level, BlockPos impactPos, int particleCount, float effectiveFallDistance, float maxEffectiveFallDistance) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos basePos = impactPos.m_7495_();
        RandomSource random = level.f_46441_;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos pos = basePos.m_7918_(x, 0, z);
                BlockState state = level.m_8055_(pos);
                if (state.m_60795_() || !level.m_8055_(pos.m_7494_()).m_60795_()) continue;
                for (int i = 0; i < particleCount / 2; ++i) {
                    double offsetX = random.m_188583_() * 0.3;
                    double offsetY = random.m_188500_() * 0.5 + 0.5;
                    double offsetZ = random.m_188583_() * 0.3;
                    serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + 1.0 + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, 1, 0.1, 0.1, 0.1, 0.0);
                }
            }
        }
    }

    public static void spawnCritParticles(Level level, LivingEntity target, int particleCount) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (int i = 0; i < particleCount / 2; ++i) {
            double offsetX = level.f_46441_.m_188583_() * 0.2;
            double offsetY = level.f_46441_.m_188583_() * 0.2 + 1.0;
            double offsetZ = level.f_46441_.m_188583_() * 0.2;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, target.m_20185_() + offsetX, target.m_20186_() + offsetY, target.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

