/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.mechanics;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.particles.CustomSweepParticleData;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;

public class SweepAttackHandler {
    public static float SWEEP_DOT_THRESHOLD = 0.5f;
    public static float SWEEP_BASE_DAMAGE_PERCENT = 1.0f;
    public static float SWEEP_KNOCKBACK_STRENGTH = 0.5f;
    public static int SWEEP_WEAPON_DAMAGE_PENALTY = 1;
    public static float SWEEP_ENCHANTMENT_BONUS = 2.0f;
    public static float PARTICLE_SIZE_DEFAULT = 1.0f;
    public static float PARTICLE_DISTANCE = 1.5f;
    public static float PARTICLE_OFFSET_Y = 0.6f;
    public static float PARTICLE_COLOR_R_DEFAULT = 1.0f;

    public static void performSweepAttack(ItemStack itemstack, LivingEntity target, LivingEntity attacker, float sweepRange, float baseDamagePercent, int weaponDamagePenalty, boolean damageByEnemyCount, SoundEvent soundEvent, ParticleOptions particle, Predicate<LivingEntity> entityFilter) {
        Player player;
        if (!attacker.m_6084_() || attacker instanceof Player && ModUtils.isAlliedEntity(player = (Player)attacker, (Entity)target)) {
            return;
        }
        if (attacker instanceof Player && ModUtils.isCritical(player = (Player)attacker, (Entity)target, player.m_36403_(0.5f))) {
            return;
        }
        float baseDamage = SweepAttackHandler.getSweepDamage(attacker, itemstack, baseDamagePercent);
        if (baseDamage <= 0.0f) {
            return;
        }
        SweepAttackHandler.performAreaAttack(attacker, (Entity)target, itemstack, baseDamage, sweepRange, SWEEP_KNOCKBACK_STRENGTH, true, soundEvent, particle, entityFilter);
        Level level = target.m_9236_();
        AABB sweepArea = new AABB(target.m_20182_().m_82520_((double)(-sweepRange), (double)(-sweepRange), (double)(-sweepRange)), target.m_20182_().m_82520_((double)sweepRange, (double)sweepRange, (double)sweepRange));
        List nearbyEnemies = level.m_6443_(LivingEntity.class, sweepArea, nearby -> entityFilter.test((LivingEntity)nearby));
        if (!nearbyEnemies.isEmpty()) {
            int durabilityDamage = damageByEnemyCount ? nearbyEnemies.size() * weaponDamagePenalty : weaponDamagePenalty;
            itemstack.m_41622_(durabilityDamage, attacker, e -> e.m_21190_(attacker.m_7655_()));
        }
    }

    public static void performAreaAttack(LivingEntity attacker, Entity target, ItemStack weapon, float baseDamage, float areaRadius, float knockbackStrength, boolean applySweepingEdge, SoundEvent soundEvent, ParticleOptions particle, Predicate<LivingEntity> entityFilter) {
        Level level = attacker.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        float areaDamage = baseDamage;
        if (applySweepingEdge) {
            int sweepingLevel = weapon.getEnchantmentLevel(Enchantments.f_44983_);
            areaDamage += (float)sweepingLevel / (float)(sweepingLevel + 1) * baseDamage;
        }
        AABB hitBox = new AABB(target.m_20182_().m_82492_((double)areaRadius, (double)areaRadius, (double)areaRadius), target.m_20182_().m_82520_((double)areaRadius, (double)areaRadius, (double)areaRadius));
        for (LivingEntity nearbyEntity : attacker.m_9236_().m_45976_(LivingEntity.class, hitBox)) {
            Player player;
            if (nearbyEntity == attacker || nearbyEntity == target || attacker instanceof Player && ModUtils.isAlliedEntity(player = (Player)attacker, (Entity)nearbyEntity) || !entityFilter.test(nearbyEntity) || !(attacker.m_20280_((Entity)nearbyEntity) <= (double)Mth.m_14207_((float)SweepAttackHandler.getEntityReach(attacker)))) continue;
            if (knockbackStrength > 0.0f) {
                float rad = SweepAttackHandler.getYRot(attacker) * ((float)Math.PI / 180);
                nearbyEntity.m_147240_((double)knockbackStrength, (double)Mth.m_14031_((float)rad), (double)(-Mth.m_14089_((float)rad)));
            }
            nearbyEntity.m_6469_(attacker.m_269291_().m_269333_(attacker), areaDamage);
            if (!nearbyEntity.m_6084_()) continue;
            SweepAttackHandler.applyWeaponEnchantmentEffects(nearbyEntity, attacker, weapon);
        }
        if (soundEvent != null) {
            serverLevel.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), soundEvent, attacker.m_5720_(), 1.0f, 1.0f);
        }
        if (!(particle == null || ModList.get().isLoaded("bettercombat") || ModUtils.hasEpicFightAttribute(attacker) || ModUtils.isEntityInBattleMode((Entity)attacker))) {
            float particleSize = PARTICLE_SIZE_DEFAULT;
            float particleDistance = PARTICLE_DISTANCE;
            float r = PARTICLE_COLOR_R_DEFAULT;
            float g = 1.0f;
            float b = 1.0f;
            int fireAspectLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)weapon);
            if (fireAspectLevel > 0) {
                r = 1.0f;
                g = 0.5f;
                b = 0.0f;
            }
            SweepAttackHandler.spawnParticleInFront((LevelAccessor)serverLevel, attacker, particle, particleSize, particleDistance, r, g, b);
        }
    }

    private static float getSweepDamage(LivingEntity attacker, ItemStack itemstack, float baseDamagePercent) {
        AtomicReference<Float> baseDamage = new AtomicReference<Float>(Float.valueOf(0.0f));
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            player.getCapability(AmountProvider.AMOUNT).ifPresent(amount -> {
                float damage = amount.getDamage() * baseDamagePercent;
                int sweepingEdgeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44983_, (ItemStack)itemstack);
                if (sweepingEdgeLevel > 0) {
                    damage += SWEEP_ENCHANTMENT_BONUS * (float)sweepingEdgeLevel;
                }
                baseDamage.set(Float.valueOf(Math.max(0.0f, damage)));
            });
        } else {
            float damage = 1.0f * baseDamagePercent;
            int sweepingEdgeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44983_, (ItemStack)itemstack);
            if (sweepingEdgeLevel > 0) {
                damage += SWEEP_ENCHANTMENT_BONUS * (float)sweepingEdgeLevel;
            }
            baseDamage.set(Float.valueOf(Math.max(0.0f, damage)));
        }
        return baseDamage.get().floatValue();
    }

    private static void applyWeaponEnchantmentEffects(LivingEntity nearby, LivingEntity attacker, ItemStack weaponItem) {
        int knockbackLevel;
        int smiteLevel;
        int baneOfArthropodsLevel;
        int fireAspectLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)weaponItem);
        if (fireAspectLevel > 0) {
            nearby.m_20254_(fireAspectLevel * 4);
        }
        if ((baneOfArthropodsLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44979_, (ItemStack)weaponItem)) > 0 && nearby.m_6336_() == MobType.f_21642_) {
            nearby.m_7292_(new MobEffectInstance(MobEffects.f_19597_, baneOfArthropodsLevel * 50, 3));
        }
        if ((smiteLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44978_, (ItemStack)weaponItem)) > 0 && nearby.m_6336_() == MobType.f_21641_) {
            float smiteDamage = (float)smiteLevel * 2.5f;
            nearby.m_6469_(attacker.m_269291_().m_269333_(attacker), smiteDamage);
        }
        if ((knockbackLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)weaponItem)) > 0) {
            double motionZ;
            double knockbackStrength = (double)knockbackLevel * 0.5;
            double motionX = nearby.m_20185_() - attacker.m_20185_();
            double distance = Math.sqrt(motionX * motionX + (motionZ = nearby.m_20189_() - attacker.m_20189_()) * motionZ);
            if (distance > 0.0) {
                nearby.m_5997_(motionX / distance * knockbackStrength, 0.1, motionZ / distance * knockbackStrength);
            }
        }
    }

    public static boolean isValidSweepTarget(LivingEntity nearby, LivingEntity entity, LivingEntity attacker, Vec3 lookVec) {
        Player player;
        if (nearby == entity || nearby == attacker || !nearby.m_6084_()) {
            return false;
        }
        if (nearby instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)nearby;
            if (attacker instanceof Player) {
                Player player2 = (Player)attacker;
                if (tamable.m_21824_() && tamable.m_269323_() != null && (tamable.m_269323_() == player2 || player2.m_5647_() != null && tamable.m_269323_().m_5647_() != null && player2.m_5647_().m_83536_(tamable.m_269323_().m_5647_()))) {
                    return false;
                }
            }
        }
        if (attacker instanceof Player && !(player = (Player)attacker).m_6779_(nearby)) {
            return false;
        }
        if (attacker instanceof Player && (player = (Player)attacker).m_5647_() != null && nearby.m_5647_() != null && player.m_5647_().m_83536_(nearby.m_5647_())) {
            return false;
        }
        Vec3 toTarget = nearby.m_20182_().m_82546_(attacker.m_20182_()).m_82541_();
        double dot = lookVec.m_82526_(toTarget);
        return dot > (double)SWEEP_DOT_THRESHOLD;
    }

    public static void spawnParticleInFront(LevelAccessor level, LivingEntity entity, ParticleOptions particleType, float particleSize, float particleDistance, float r, float g, float b) {
        float grayValue;
        ServerLevel serverLevel;
        block6: {
            block5: {
                if (entity == null || level.m_5776_() || !(level instanceof ServerLevel)) break block5;
                serverLevel = (ServerLevel)level;
                if (particleType != null) break block6;
            }
            return;
        }
        Vec3 lookVec = entity.m_20154_().m_82541_();
        double startX = entity.m_20185_();
        double startY = entity.m_20186_() + (double)(entity.m_20192_() * PARTICLE_OFFSET_Y);
        double startZ = entity.m_20189_();
        Vec3 startPos = new Vec3(startX, startY, startZ);
        Vec3 endPos = startPos.m_82549_(lookVec.m_82490_((double)particleDistance));
        ClipContext clipContext = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        BlockHitResult blockHit = level.m_45547_(clipContext);
        EntityHitResult entityHit = ModUtils.getEntityHitResult(serverLevel, entity, startPos, endPos);
        double adjustedDistance = particleDistance;
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            adjustedDistance = Math.min(adjustedDistance, startPos.m_82554_(blockHit.m_82450_()));
        }
        if (entityHit != null) {
            adjustedDistance = Math.min(adjustedDistance, startPos.m_82554_(entityHit.m_82450_()));
        }
        adjustedDistance = Math.max(adjustedDistance - (double)0.1f, (double)0.1f);
        double particleX = startX + lookVec.f_82479_ * adjustedDistance;
        double particleY = startY + lookVec.f_82480_ * adjustedDistance;
        double particleZ = startZ + lookVec.f_82481_ * adjustedDistance;
        RandomSource random = serverLevel.f_46441_;
        r = grayValue = 0.4f + random.m_188501_() * 0.6f;
        g = grayValue;
        b = grayValue;
        CustomSweepParticleData finalParticleType = new CustomSweepParticleData(r, g, b, particleSize);
        serverLevel.m_8767_((ParticleOptions)finalParticleType, particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static float getEntityReach(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return (float)player.getEntityReach();
        }
        return 3.0f;
    }

    private static float getYRot(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_146908_();
        }
        return entity.m_6080_();
    }
}

