/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import net.jaams.jaams_weaponry.handler.mechanics.SmashAttackHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class FlintHammerItem
extends PickaxeItem {
    public static final float DAMAGE_PER_BLOCK = 0.5f;
    public static final float MAX_BONUS_DAMAGE = 55.0f;
    public static final float RESIDUAL_DAMAGE_BASE = 1.0f;
    public static final float RESIDUAL_DAMAGE_PER_BLOCK = 0.2f;
    public static final float MAX_RESIDUAL_DAMAGE = 20.0f;
    public static final float SMASH_RADIUS = 1.0f;
    public static final float MIN_KNOCKBACK_STRENGTH = 0.1f;
    public static final float MAX_KNOCKBACK_STRENGTH = 0.2f;
    public static final float KNOCKBACK_SCALING_FACTOR = 0.01f;
    public static final int PARTICLE_COUNT = 5;
    public static final int CRIT_PARTICLE_COUNT = 10;
    public static final float MIN_FALL_DISTANCE = 2.0f;
    public static final float MAX_EFFECTIVE_FALL_DISTANCE = 100.0f;
    public static final float SHAKE_INTENSITY = 1.5f;
    public static final int SHAKE_RESET_DELAY = 5;
    public static final float ALLY_DAMAGE_MULTIPLIER = 0.1f;
    public static final int SMASH_DURABILITY_DAMAGE_BASE = 5;
    public static final float SMASH_DURABILITY_DAMAGE_PER_BLOCK = 1.0f;
    public static final int SMASH_MAX_DURABILITY_DAMAGE = 1000;
    public static final int KNOCKED_UP_DURATION = 60;
    public static final int KNOCKED_UP_LEVEL = 1;
    public static final float KNOCKED_UP_BASE_CHANCE = 0.05f;
    public static final float KNOCKED_UP_CHANCE_PER_BLOCK = 0.01f;
    public static final float KNOCKED_UP_CRITICAL_CHANCE = 0.1f;
    public static final int DEPLETION_DURATION = 80;
    public static final int DEPLETION_LEVEL = 0;
    public static final float DEPLETION_CHANCE = 0.5f;
    public static final float DEPLETION_BLOCKS_PER_LEVEL = 40.0f;
    public static final float DEPLETION_TICKS_PER_BLOCK = 8.0f;
    public static final int DEPLETION_MAX_LEVEL = 3;
    public static final int DEPLETION_MAX_DURATION = 1200;
    public static final boolean ENABLE_DEPLETION = false;

    public FlintHammerItem() {
        super(new Tier(){

            public int m_6609_() {
                return 56;
            }

            public float m_6624_() {
                return 4.0f;
            }

            public float m_6631_() {
                return 1.0f;
            }

            public int m_6604_() {
                return 0;
            }

            public int m_6601_() {
                return 5;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42484_)});
            }
        }, 3, -3.0f, new Item.Properties());
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.PICKAXE_DIG) || toolAction.equals(ToolActions.SWORD_SWEEP);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemstack) {
        ItemStack retval = itemstack.m_41777_();
        retval.m_41721_(itemstack.m_41773_() + 1);
        if (retval.m_41773_() >= retval.m_41776_()) {
            return ItemStack.f_41583_;
        }
        return retval;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44983_ || enchantment == Enchantments.f_44978_ || enchantment == Enchantments.f_44979_ || enchantment == Enchantments.f_44982_ || enchantment == Enchantments.f_44980_ || enchantment == Enchantments.f_44981_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean isPlayer = sourceentity instanceof Player;
        boolean isCritical = isPlayer ? ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f)) : sourceentity.m_9236_().f_46441_.m_188501_() < 0.05f;
        float attackStrength = isPlayer ? ((Player)sourceentity).m_36403_(0.5f) : 1.0f;
        float fallDistance = isPlayer ? ((Player)sourceentity).f_19789_ : sourceentity.m_9236_().f_46441_.m_188501_() * 98.0f + 2.0f;
        Level level = entity.m_9236_();
        String displayName = itemstack.m_41611_().getString().toLowerCase();
        if (displayName.equalsIgnoreCase("[bonk]")) {
            ModUtils.playSound((Entity)entity, "jaams_weaponry:bonk", SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (fallDistance >= 2.0f && !sourceentity.m_20069_() && !sourceentity.m_20077_()) {
            this.applySmashLogic(sourceentity, entity, itemstack, attackStrength, fallDistance);
        }
        this.applyAttackEffects(sourceentity, entity, itemstack, attackStrength);
        return retval;
    }

    public void applySmashLogic(LivingEntity sourceentity, LivingEntity entity, ItemStack itemstack, float attackStrength, float fallDistance) {
        SmashAttackHandler.applySmashLogic(sourceentity, entity, itemstack, attackStrength, fallDistance, 0.5f, 55.0f, 1.0f, 0.2f, 20.0f, 1.0f, 0.1f, 0.2f, 0.01f, 5, 100.0f, 1.5f, 5, 0.1f, 5, 1.0f, 1000, 0.05f, 0.01f, 60, 1, 0.5f, 0, 80, 40.0f, 8.0f, 3, 1200, false);
    }

    public void applyAttackEffects(LivingEntity sourceentity, LivingEntity entity, ItemStack itemstack, float attackStrength) {
        boolean isCritical;
        boolean bl = sourceentity instanceof Player ? ModUtils.isCritical((Player)sourceentity, (Entity)entity, attackStrength) : (isCritical = sourceentity.m_9236_().f_46441_.m_188501_() < 0.05f);
        if (isCritical) {
            SmashAttackHandler.applyCriticalKnockedUpEffect(sourceentity, entity, 0.1f, 60, 1);
        }
    }
}

