/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.jaams.jaams_weaponry.dyeable.IDyeableItem;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;

public class GauntletItem
extends Item
implements IDyeableItem {
    public static final float KNOCKBACK_FORCE = 0.5f;

    public GauntletItem() {
        super(new Item.Properties().m_41503_(220).m_41497_(Rarity.COMMON));
    }

    @Override
    public int getDefaultColor() {
        return -6265536;
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public int m_6473_() {
        return 10;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.BLOCK;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44978_ || enchantment == Enchantments.f_44979_ || enchantment == Enchantments.f_44981_ || enchantment == Enchantments.f_44982_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.m_7167_(equipmentSlot));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Item modifier", 1.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Item modifier", -2.4, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.m_7167_(equipmentSlot);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player entity, InteractionHand hand) {
        ItemStack itemStack = entity.m_21120_(hand);
        if (!ModList.get().isLoaded("epicfight")) {
            entity.m_6672_(hand);
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)entity.m_21120_(hand));
        }
        return new InteractionResultHolder(InteractionResult.CONSUME, (Object)entity.m_21120_(hand));
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean isCritical = sourceentity instanceof Player && ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f));
        boolean isFullyCharged = sourceentity instanceof Player && ((Player)sourceentity).m_36403_(0.5f) >= 1.0f;
        ModUtils.playSound((Entity)entity, "jaams_weaponry:gauntlet_hit");
        if (ModUtils.isEntityInBattleMode((Entity)entity)) {
            float knockbackForce;
            double deltaZ;
            double deltaX = sourceentity.m_20185_() - entity.m_20185_();
            double distance = Math.sqrt(deltaX * deltaX + (deltaZ = sourceentity.m_20189_() - entity.m_20189_()) * deltaZ);
            if (distance > 0.0) {
                deltaX /= distance;
                deltaZ /= distance;
            }
            float f = knockbackForce = isFullyCharged ? 0.5f : 0.0f;
            if (isCritical) {
                knockbackForce += 0.5f;
            }
            if (knockbackForce > 0.0f) {
                entity.m_20334_(deltaX * (double)knockbackForce, 0.2, deltaZ * (double)knockbackForce);
                entity.f_19864_ = true;
            }
        } else {
            if (isFullyCharged) {
                entity.m_147240_(0.5, sourceentity.m_20185_() - entity.m_20185_(), sourceentity.m_20189_() - entity.m_20189_());
            }
            if (isCritical) {
                entity.m_147240_(0.75, sourceentity.m_20185_() - entity.m_20185_(), sourceentity.m_20189_() - entity.m_20189_());
            }
        }
        return retval;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (this.hasColor(stack)) {
            int color = this.getColor(stack);
            if (flag.m_7050_()) {
                String hexColor = String.format("#%06X", 0xFFFFFF & color);
                tooltip.add((Component)Component.m_237113_((String)"Color: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)hexColor).m_130940_(ChatFormatting.GRAY)));
            } else if (color != -1 && color != -6265536) {
                tooltip.add((Component)Component.m_237115_((String)"translation.tooltip.dyed").m_130938_(style -> style.m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GRAY)));
            }
        }
    }
}

