/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import java.util.ArrayList;
import java.util.List;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GreatCrossbowItem
extends CrossbowItem {
    public static final float maxVelocity = 4.0f;
    public static final int loadTime = 40;
    public boolean startSoundPlayed = false;
    public boolean midLoadSoundPlayed = true;
    public static final float RECOIL_DISTANCE = 0.65f;
    public static final float CROUCH_RECOIL_REDUCTION = 0.6f;
    public static final float VERTICAL_RECOIL_MULTIPLIER = 0.7f;
    public static final float XROT_RECOIL_INTENSITY = 4.5f;

    public GreatCrossbowItem() {
        super(new Item.Properties().m_41503_(426).m_41497_(Rarity.COMMON));
    }

    public int m_6473_() {
        return 10;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.CROSSBOW;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44988_ || enchantment == Enchantments.f_44989_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (GreatCrossbowItem.m_40932_((ItemStack)itemstack)) {
            GreatCrossbowItem.executeShooting(level, (LivingEntity)player, hand, itemstack, GreatCrossbowItem.m_40945_(itemstack), 2.0f);
            GreatCrossbowItem.m_40884_((ItemStack)itemstack, (boolean)false);
            player.m_6858_(false);
            player.m_146926_(player.m_146909_() - 4.5f);
            ModUtils.applyRecoil((LivingEntity)player, 0.65f, 0.6f, 0.7f);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (!player.m_6298_(itemstack).m_41619_()) {
            if (!GreatCrossbowItem.m_40932_((ItemStack)itemstack)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                player.m_6672_(hand);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        int i = this.m_8105_(stack) - timeLeft;
        float f = GreatCrossbowItem.m_40853_(i, stack);
        if (f >= 1.0f && !GreatCrossbowItem.m_40932_((ItemStack)stack) && GreatCrossbowItem.m_40859_(entityLiving, stack)) {
            GreatCrossbowItem.m_40884_((ItemStack)stack, (boolean)true);
            SoundSource soundsource = entityLiving instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            level.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_11841_, soundsource, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public static float m_40945_(ItemStack crossbowStack) {
        return GreatCrossbowItem.m_40871_((ItemStack)crossbowStack, (Item)Items.f_42688_) ? 0.7f : 4.0f;
    }

    public static float m_40853_(int useTime, ItemStack crossbowStack) {
        float f = (float)useTime / (float)GreatCrossbowItem.m_40939_(crossbowStack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static boolean m_40859_(LivingEntity shooter, ItemStack crossbowStack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)crossbowStack);
        int j = i == 0 ? 1 : 3;
        boolean flag = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
        ItemStack itemstack = shooter.m_6298_(crossbowStack);
        ItemStack itemstack1 = itemstack.m_41777_();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.m_41777_();
            }
            if (itemstack.m_41619_() && flag) {
                itemstack = new ItemStack((ItemLike)Items.f_42412_);
                itemstack1 = itemstack.m_41777_();
            }
            if (GreatCrossbowItem.m_40862_(shooter, crossbowStack, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    public static boolean m_40862_(LivingEntity shooter, ItemStack crossbowStack, ItemStack ammoStack, boolean hasAmmo, boolean isCreative) {
        ItemStack itemstack;
        boolean flag;
        if (ammoStack.m_41619_()) {
            return false;
        }
        boolean bl = flag = isCreative && ammoStack.m_41720_() instanceof ArrowItem;
        if (!(flag || isCreative || hasAmmo)) {
            itemstack = ammoStack.m_41620_(1);
            if (ammoStack.m_41619_() && shooter instanceof Player) {
                ((Player)shooter).m_150109_().m_36057_(ammoStack);
            }
        } else {
            itemstack = ammoStack.m_41777_();
        }
        GreatCrossbowItem.m_40928_(crossbowStack, itemstack);
        return true;
    }

    public static void m_40928_(ItemStack crossbowStack, ItemStack ammoStack) {
        CompoundTag compoundtag = crossbowStack.m_41784_();
        ListTag listtag = compoundtag.m_128425_("ChargedProjectiles", 9) ? compoundtag.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag compoundtag1 = new CompoundTag();
        ammoStack.m_41739_(compoundtag1);
        listtag.add((Object)compoundtag1);
        compoundtag.m_128365_("ChargedProjectiles", (Tag)listtag);
    }

    public static int m_40939_(ItemStack crossbowStack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)crossbowStack);
        return i == 0 ? 40 : 40 - GreatCrossbowItem.getChargeTimeReductionPerQuickChargeLevel() * i;
    }

    public static int getChargeTimeReductionPerQuickChargeLevel() {
        return 6;
    }

    public int m_8105_(ItemStack p_40938_) {
        return GreatCrossbowItem.m_40939_(p_40938_) + 3;
    }

    private static void fireProjectile(Level level, LivingEntity entity, InteractionHand hand, ItemStack crossbow, ItemStack projectileItem, float soundPitch, boolean isCreative, float velocity, float inaccuracy, float rotation) {
        if (!level.f_46443_) {
            AbstractArrow projectile;
            boolean isFirework = projectileItem.m_150930_(Items.f_42688_);
            if (isFirework) {
                projectile = new FireworkRocketEntity(level, projectileItem, (Entity)entity, entity.m_20185_(), entity.m_20188_() - 0.15, entity.m_20189_(), true);
            } else {
                projectile = GreatCrossbowItem.createArrowProjectile(level, entity, crossbow, projectileItem);
                if (isCreative || rotation != 0.0f) {
                    projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            if (entity instanceof CrossbowAttackMob) {
                CrossbowAttackMob crossbowAttackMob = (CrossbowAttackMob)entity;
                crossbowAttackMob.m_5811_(crossbowAttackMob.m_5448_(), crossbow, (Projectile)projectile, rotation);
            } else {
                Vec3 upVector = entity.m_20289_(1.0f);
                Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis((double)(rotation * (float)Math.PI / 180.0f), upVector.f_82479_, upVector.f_82480_, upVector.f_82481_);
                Vec3 viewVector = entity.m_20252_(1.0f);
                Vector3f rotatedVector = viewVector.m_252839_().rotate((Quaternionfc)rotationQuaternion);
                projectile.m_6686_((double)rotatedVector.x(), (double)rotatedVector.y(), (double)rotatedVector.z(), velocity, inaccuracy);
            }
            crossbow.m_41622_(isFirework ? 3 : 1, entity, e -> e.m_21190_(hand));
            level.m_7967_((Entity)projectile);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, soundPitch);
        }
    }

    private static AbstractArrow createArrowProjectile(Level level, LivingEntity shooter, ItemStack crossbowStack, ItemStack arrowStack) {
        int punchLevel;
        int powerLevel;
        int piercingLevel;
        ArrowItem arrowItem = (ArrowItem)(arrowStack.m_41720_() instanceof ArrowItem ? arrowStack.m_41720_() : Items.f_42412_);
        AbstractArrow arrow = arrowItem.m_6394_(level, arrowStack, shooter);
        if (shooter instanceof Player) {
            arrow.m_36762_(true);
        }
        arrow.m_36740_(SoundEvents.f_11840_);
        arrow.m_36793_(true);
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)crossbowStack) > 0) {
            arrow.m_20254_(60);
        }
        if ((piercingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crossbowStack)) > 0) {
            arrow.m_36767_((byte)piercingLevel);
        }
        if ((powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)crossbowStack)) > 0) {
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.3 + 0.3);
        }
        if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)crossbowStack)) > 0) {
            arrow.m_36735_(punchLevel);
        }
        return arrow;
    }

    public static void executeShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack crossbowStack, float velocity, float inaccuracy) {
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (ForgeEventFactory.onArrowLoose((ItemStack)crossbowStack, (Level)shooter.m_9236_(), (Player)player, (int)1, (boolean)true) < 0) {
                return;
            }
        }
        List<ItemStack> chargedProjectiles = GreatCrossbowItem.m_40941_(crossbowStack);
        float[] shotPitches = GreatCrossbowItem.generateShotPitches(shooter.m_217043_());
        for (int i = 0; i < chargedProjectiles.size(); ++i) {
            boolean isCreative;
            ItemStack projectileStack = chargedProjectiles.get(i);
            boolean bl = isCreative = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
            if (projectileStack.m_41619_()) continue;
            if (i == 0) {
                GreatCrossbowItem.fireProjectile(level, shooter, hand, crossbowStack, projectileStack, shotPitches[i], isCreative, velocity, inaccuracy, 0.0f);
                continue;
            }
            if (i == 1) {
                GreatCrossbowItem.fireProjectile(level, shooter, hand, crossbowStack, projectileStack, shotPitches[i], isCreative, velocity, inaccuracy, -10.0f);
                continue;
            }
            if (i != 2) continue;
            GreatCrossbowItem.fireProjectile(level, shooter, hand, crossbowStack, projectileStack, shotPitches[i], isCreative, velocity, inaccuracy, 10.0f);
        }
        GreatCrossbowItem.handleCrossbowShot(level, shooter, crossbowStack);
    }

    private static void handleCrossbowShot(Level level, LivingEntity shooter, ItemStack crossbowStack) {
        if (shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            if (!level.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverPlayer, crossbowStack);
            }
            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)crossbowStack.m_41720_()));
        }
        GreatCrossbowItem.m_40943_(crossbowStack);
    }

    private static float[] generateShotPitches(RandomSource randomSource) {
        boolean flag = randomSource.m_188499_();
        return new float[]{1.0f, GreatCrossbowItem.m_220025_(flag, randomSource), GreatCrossbowItem.m_220025_(!flag, randomSource)};
    }

    private static List<ItemStack> m_40941_(ItemStack crossbowStack) {
        ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
        CompoundTag compoundTag = crossbowStack.m_41783_();
        if (compoundTag != null && compoundTag.m_128425_("ChargedProjectiles", 9)) {
            ListTag listTag = compoundTag.m_128437_("ChargedProjectiles", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag projectileTag = listTag.m_128728_(i);
                projectiles.add(ItemStack.m_41712_((CompoundTag)projectileTag));
            }
        }
        return projectiles;
    }

    private static void m_40943_(ItemStack p_40944_) {
        CompoundTag compoundtag = p_40944_.m_41783_();
        if (compoundtag != null) {
            ListTag listtag = compoundtag.m_128437_("ChargedProjectiles", 9);
            listtag.clear();
            compoundtag.m_128365_("ChargedProjectiles", (Tag)listtag);
        }
    }

    private static float m_220025_(boolean p_220026_, RandomSource p_220027_) {
        float f = p_220026_ ? 0.63f : 0.43f;
        return 1.0f / (p_220027_.m_188501_() * 0.5f + 1.8f) + f;
    }
}

