/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import net.jaams.jaams_weaponry.entity.HuntersBoomerangProjectileEntity;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class HuntersBoomerangItem
extends SwordItem {
    public static final float MAX_DRAW_DURATION = 20.0f;
    public static final float MIN_PROJECTILE_SPEED = 1.0f;
    public static final float MAX_PROJECTILE_SPEED = 2.5f;
    public static final double BASE_WEAPON_RANGE = 1.0;
    public static final double MAX_WEAPON_RANGE = 30.0;

    public HuntersBoomerangItem() {
        super(new Tier(){

            public int m_6609_() {
                return 220;
            }

            public float m_6624_() {
                return 4.0f;
            }

            public float m_6631_() {
                return -0.5f;
            }

            public int m_6604_() {
                return 0;
            }

            public int m_6601_() {
                return 15;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_151265_();
            }
        }, 3, -1.8f, new Item.Properties());
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.SPEAR;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SWORD_DIG);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44983_) {
            return false;
        }
        if (enchantment == Enchantments.f_44961_ || enchantment == Enchantments.f_44955_ || enchantment == Enchantments.f_44959_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean isCritical = sourceentity instanceof Player && ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f));
        boolean isFullyCharged = sourceentity instanceof Player && ((Player)sourceentity).m_36403_(0.5f) >= 1.0f;
        Level level = entity.m_9236_();
        return retval;
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity entity, int durationUsed) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int remainingDuration = this.m_8105_(itemStack) - durationUsed;
            if (remainingDuration >= 5 && !level.f_46443_) {
                float power = HuntersBoomerangItem.getPowerForTime(remainingDuration);
                float speed = this.calculateProjectileSpeed(power);
                boolean isCreative = player.m_150110_().f_35937_;
                boolean hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)itemStack) > 0;
                int projectileCount = hasMultishot ? 3 : 1;
                float[] shotPitches = HuntersBoomerangItem.generateShotPitches(level.m_213780_(), projectileCount);
                int pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)itemStack);
                for (int i = 0; i < projectileCount; ++i) {
                    HuntersBoomerangProjectileEntity projectile = new HuntersBoomerangProjectileEntity(level, (LivingEntity)player, itemStack.m_41777_());
                    int slotIndex = entity.m_7655_() == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40;
                    projectile.setOriginalSlotIndex(slotIndex);
                    if (ModUtils.isProjectileCritical(player, power)) {
                        projectile.setCritical(true);
                    }
                    projectile.setPiercingLevel(projectile.getPiercingLevel() + pierceLevel);
                    if (hasMultishot) {
                        AbstractArrow.Pickup pickup = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : (projectile.f_36705_ = i == 0 ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED);
                        if (i != 0) {
                            projectile.getPersistentData().m_128379_("IsMultishotClone", true);
                        }
                        float spreadAngle = 10.0f;
                        float rotation = i == 0 ? 0.0f : (i == 1 ? -spreadAngle : spreadAngle);
                        Vec3 upVector = player.m_20289_(1.0f);
                        Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis(rotation * (float)Math.PI / 180.0f, (float)upVector.f_82479_, (float)upVector.f_82480_, (float)upVector.f_82481_);
                        Vec3 viewVector = player.m_20252_(1.0f);
                        Vector3f rotatedVector = new Vector3f((float)viewVector.f_82479_, (float)viewVector.f_82480_, (float)viewVector.f_82481_).rotate((Quaternionfc)rotationQuaternion);
                        if (i == 0) {
                            float forwardOffset = 1.0f;
                            Vec3 offset = viewVector.m_82490_((double)forwardOffset);
                            projectile.m_6034_(player.m_20185_() + offset.f_82479_, player.m_20188_() + offset.f_82480_, player.m_20189_() + offset.f_82481_);
                        }
                        projectile.m_6686_(rotatedVector.x(), rotatedVector.y(), rotatedVector.z(), speed, 1.0f);
                    } else {
                        projectile.f_36705_ = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                        projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, speed, 1.0f);
                    }
                    projectile.setWeaponItem(itemStack.m_41777_());
                    double weaponRange = 1.0 + (double)power * 30.0;
                    projectile.setWeaponRange((float)Math.min(weaponRange, 30.0));
                    level.m_7967_((Entity)projectile);
                    SoundEvent shootSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:hunters_boomerang_throw"));
                    level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), shootSound != null ? shootSound : SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, shotPitches[i]);
                }
                if (!isCreative) {
                    itemStack.m_41622_(1, (LivingEntity)player, brokenItemStack -> brokenItemStack.m_21190_(entity.m_7655_()));
                    player.m_150109_().m_36057_(itemStack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public static float getPowerForTime(int duration) {
        float f = (float)duration / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    private float calculateProjectileSpeed(float power) {
        float speedRange = 1.5f;
        float scaledPower = power * power;
        return 1.0f + speedRange * scaledPower;
    }

    public static float[] generateShotPitches(RandomSource random, int projectileCount) {
        float[] pitches = new float[projectileCount];
        for (int i = 0; i < projectileCount; ++i) {
            boolean flag = random.m_188499_();
            pitches[i] = 1.0f / (random.m_188501_() * 0.5f + 1.8f) + (flag ? 0.63f : 0.43f);
        }
        return pitches;
    }
}

