/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.jaams.jaams_weaponry.entity.KunaiProjectileEntity;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class KunaiItem
extends Item {
    public static final float BREAK_CHANCE = 0.3f;
    public static final int ITEM_BREAK_PARTICLE_COUNT = 5;
    public static final int MAX_DRAW_DURATION = 20;
    public static final float MIN_PROJECTILE_SPEED = 0.4f;
    public static final float MAX_PROJECTILE_SPEED = 2.5f;

    public KunaiItem() {
        super(new Item.Properties().m_41487_(16).m_41497_(Rarity.COMMON));
    }

    public int m_6473_() {
        return 0;
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.SPEAR;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.m_7167_(equipmentSlot));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Item modifier", 1.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Item modifier", -2.4, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.m_7167_(equipmentSlot);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = InteractionResultHolder.m_19096_((Object)entity.m_21120_(hand));
        entity.m_6672_(hand);
        return ar;
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (!player.m_150110_().f_35937_) {
                ModUtils.handleItemBreak(itemStack, (LivingEntity)player, 0.3f, 5, "minecraft:item.shield.break");
            }
        }
        return true;
    }

    public void m_5551_(ItemStack itemstack, Level level, LivingEntity entity, int durationUsed) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int remainingDuration = this.m_8105_(itemstack) - durationUsed;
            if (remainingDuration >= 5 && !level.f_46443_) {
                float power = KunaiItem.getPowerForTime(remainingDuration);
                float speed = this.calculateProjectileSpeed(power);
                KunaiProjectileEntity projectile = new KunaiProjectileEntity((EntityType<? extends KunaiProjectileEntity>)((EntityType)JaamsWeaponryModEntities.KUNAI_PROJECTILE.get()), (LivingEntity)player, level, itemstack);
                int slotIndex = entity.m_7655_() == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40;
                projectile.setOriginalSlotIndex(slotIndex);
                if (ModUtils.isProjectileCritical(player, power)) {
                    projectile.setCritical(true);
                }
                projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, speed, 1.0f);
                projectile.setWeaponItem(itemstack.m_41777_());
                if (player.m_150110_().f_35937_) {
                    projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                level.m_7967_((Entity)projectile);
                SoundEvent shootSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:kunai_throw"));
                level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), shootSound != null ? shootSound : SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public static float getPowerForTime(int duration) {
        float f = (float)duration / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    private float calculateProjectileSpeed(float power) {
        float speedRange = 2.1f;
        float scaledPower = power * power;
        return 0.4f + speedRange * scaledPower;
    }
}

