/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Consumer;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class NunchakuItem
extends SwordItem {
    public static final int ITEM_DAMAGE_INTERVAL = 20;
    public static final int ATTACK_INTERVAL = 5;
    public static final float BASE_DAMAGE = 2.0f;
    public static final double BASE_ATTACK_RANGE = 2.5;
    public static final double DUAL_WIELD_RANGE_MULTIPLIER = 1.5;
    public static final int ITEM_DAMAGE_AMOUNT = 2;
    public static final float DUAL_WIELD_DAMAGE_MULTIPLIER = 2.0f;
    public static final float MAX_DAMAGE_CAP = 8.0f;
    public static final int SINGLE_WIELD_BLOCK_DAMAGE = 2;
    public static final int DUAL_WIELD_BLOCK_DAMAGE = 4;
    public static final double USE_DISTANCE = 1.5;
    public static final int PARTICLE_TICK_INTERVAL = 8;
    public int particleTickCounter = 0;

    public NunchakuItem() {
        super(new Tier(){

            public int m_6609_() {
                return 220;
            }

            public float m_6624_() {
                return 2.0f;
            }

            public float m_6631_() {
                return 0.0f;
            }

            public int m_6604_() {
                return 0;
            }

            public int m_6601_() {
                return 15;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("minecraft:planks")));
            }
        }, 3, -2.0f, new Item.Properties());
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private static final HumanoidModel.ArmPose BOTH_HANDS_POSE = HumanoidModel.ArmPose.create((String)"BOTH_HANDS_POSE", (boolean)false, (model, entity, arm) -> {
                float tickCount = entity.f_19797_;
                float swingSpeed = 0.8f;
                float swingAmount = 0.5f;
                ModelPart rightArmModel = model.f_102811_;
                ModelPart leftArmModel = model.f_102812_;
                rightArmModel.f_104203_ = -1.0f + swingAmount * (float)Math.sin(tickCount * swingSpeed);
                rightArmModel.f_104204_ = 0.1f;
                rightArmModel.f_104205_ = 0.0f;
                leftArmModel.f_104203_ = -1.0f + swingAmount * (float)Math.cos(tickCount * swingSpeed);
                leftArmModel.f_104204_ = -0.1f;
                leftArmModel.f_104205_ = 0.0f;
            });
            private static final HumanoidModel.ArmPose ONE_HAND_POSE = HumanoidModel.ArmPose.create((String)"ONE_HAND_POSE", (boolean)false, (model, entity, arm) -> {
                float tickCount = entity.f_19797_;
                float swingSpeed = 0.8f;
                float swingAmount = 0.5f;
                ModelPart armModel = arm == HumanoidArm.RIGHT ? model.f_102811_ : model.f_102812_;
                armModel.f_104203_ = -1.0f + swingAmount * (float)Math.sin(tickCount * swingSpeed);
                armModel.f_104204_ = arm == HumanoidArm.RIGHT ? 0.1f : -0.1f;
                armModel.f_104205_ = 0.0f;
            });

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                if (!itemStack.m_41619_() && entityLiving.m_7655_() == hand && entityLiving.m_21212_() > 0) {
                    Player player = (Player)entityLiving;
                    if (player.m_36335_().m_41519_(itemStack.m_41720_())) {
                        return HumanoidModel.ArmPose.ITEM;
                    }
                    ItemStack offHandItem = entityLiving.m_21206_();
                    ItemStack mainHandItem = entityLiving.m_21205_();
                    boolean isBothHands = offHandItem.m_41720_() instanceof NunchakuItem && mainHandItem.m_41720_() instanceof NunchakuItem;
                    return isBothHands ? BOTH_HANDS_POSE : ONE_HAND_POSE;
                }
                return HumanoidModel.ArmPose.ITEM;
            }

            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                if (player.m_36335_().m_41519_(itemInHand.m_41720_())) {
                    return false;
                }
                ItemStack offHandItem = player.m_21206_();
                ItemStack mainHandItem = player.m_21205_();
                boolean isNunchakuInHand = itemInHand.m_41720_() instanceof NunchakuItem;
                boolean isBothHands = offHandItem.m_41720_() instanceof NunchakuItem && mainHandItem.m_41720_() instanceof NunchakuItem && player.m_6117_();
                int i = arm == HumanoidArm.RIGHT ? 1 : -1;
                float speedFactor = 0.7f;
                float swingProgress = ((float)player.f_19797_ + partialTick) * speedFactor;
                float arcMotion = (float)Math.sin(swingProgress) * 0.2f;
                float impactMotion = (float)Math.abs(Math.cos(swingProgress)) * 0.08f;
                if (isNunchakuInHand) {
                    if (isBothHands) {
                        if (arm == HumanoidArm.RIGHT) {
                            poseStack.m_252880_(0.4f, -0.6f + impactMotion, -0.7f + arcMotion);
                            poseStack.m_85841_(1.2f, 1.2f, 1.2f);
                            poseStack.m_252781_(Axis.f_252529_.m_252977_(-30.0f + arcMotion * 40.0f));
                            poseStack.m_252781_(Axis.f_252436_.m_252977_(2.0f));
                            poseStack.m_252781_(Axis.f_252403_.m_252977_(arcMotion * 1.2f));
                        } else if (arm == HumanoidArm.LEFT) {
                            poseStack.m_252880_(-0.4f, -0.6f + impactMotion, -0.7f + arcMotion);
                            poseStack.m_85841_(1.2f, 1.2f, 1.2f);
                            poseStack.m_252781_(Axis.f_252529_.m_252977_(-30.0f + arcMotion * 40.0f));
                            poseStack.m_252781_(Axis.f_252436_.m_252977_(-2.0f));
                            poseStack.m_252781_(Axis.f_252403_.m_252977_(-arcMotion * 1.2f));
                        }
                    } else {
                        if (player.m_21211_() == itemInHand && player.m_6117_()) {
                            poseStack.m_252880_((float)i * 0.6f, -0.8f + impactMotion, -0.9f + arcMotion);
                            poseStack.m_85841_(1.4f, 1.4f, 1.4f);
                            poseStack.m_252781_(Axis.f_252529_.m_252977_(-40.0f + arcMotion * 50.0f));
                            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * 4.0f));
                            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)i * arcMotion * 2.0f));
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.CUSTOM;
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        boolean hasNunchaku;
        Player player;
        block5: {
            block4: {
                super.m_6883_(itemstack, world, entity, slot, selected);
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (!world.m_5776_() && !player.m_21224_() && !player.m_5833_()) break block5;
            }
            return;
        }
        boolean isActive = !player.m_36335_().m_41519_((Item)this) && !ModUtils.hasRestrictedEffect((LivingEntity)player) && !player.m_6069_() && !player.m_6117_();
        boolean bl = hasNunchaku = player.m_21205_().m_41720_() instanceof NunchakuItem || player.m_21206_().m_41720_() instanceof NunchakuItem;
        if (isActive && player.m_20142_() && hasNunchaku && player.f_19797_ % 10 == 0) {
            float volume = player.m_21205_().m_41720_() instanceof NunchakuItem && player.m_21206_().m_41720_() instanceof NunchakuItem ? 0.35f : 0.25f;
            ModUtils.playSound((Entity)player, "jaams_weaponry:nunchaku_chain", SoundSource.AMBIENT, volume, 1.0f);
        }
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity) {
        BlockHitResult hitResult;
        boolean isActive;
        Player player;
        boolean retval = super.onEntitySwing(itemstack, entity);
        if (!(entity instanceof Player) || (player = (Player)entity).m_9236_().m_5776_() || player.m_21224_() || player.m_5833_()) {
            return retval;
        }
        boolean bl = isActive = !player.m_36335_().m_41519_((Item)this) && !ModUtils.hasRestrictedEffect((LivingEntity)player) && !player.m_6069_() && !player.m_6117_();
        if (isActive && player.m_36403_(0.0f) >= 0.5f && (hitResult = player.m_9236_().m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20154_().m_82490_(6.5)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player))).m_6662_() != HitResult.Type.BLOCK) {
            float volume = 0.25f;
            ModUtils.playSound((Entity)player, "jaams_weaponry:nunchaku_chain", SoundSource.AMBIENT, volume, 1.0f);
        }
        return retval;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        ModUtils.playSound((Entity)sourceentity, "jaams_weaponry:nunchaku_chain", SoundSource.PLAYERS, 0.35f, 1.0f);
        ModUtils.playSound((Entity)sourceentity, "jaams_weaponry:nunchaku_hit", SoundSource.PLAYERS, 0.35f, 1.0f);
        return retval;
    }

    public void m_5929_(Level world, LivingEntity entityLiving, ItemStack stack, int count) {
        Player player;
        if (!(entityLiving instanceof Player) || (player = (Player)entityLiving).m_21224_() || player.m_5833_()) {
            return;
        }
        if (player.m_36335_().m_41519_(stack.m_41720_())) {
            player.m_5810_();
            return;
        }
        HitResult hitResult = this.calculateHitResult(entityLiving);
        ItemStack mainHandStack = player.m_21205_();
        ItemStack offHandStack = player.m_21206_();
        boolean isMainHandNunchaku = mainHandStack.m_41720_() instanceof NunchakuItem;
        boolean isOffHandNunchaku = offHandStack.m_41720_() instanceof NunchakuItem;
        if (!isMainHandNunchaku && !isOffHandNunchaku) {
            return;
        }
        if (!world.f_46443_ && count % 10 == 0) {
            float volume = isMainHandNunchaku && isOffHandNunchaku ? 0.45f : 0.35f;
            ModUtils.playSound((Entity)player, "jaams_weaponry:nunchaku_chain", SoundSource.AMBIENT, volume, 1.0f);
        }
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            if (!world.f_46443_ && this.particleTickCounter++ % 8 == 0) {
                BlockPos blockPos = blockHitResult.m_82425_();
                Vec3 hitVec = blockHitResult.m_82450_();
                Direction direction = blockHitResult.m_82434_();
                this.spawnNunchakuParticles((ServerLevel)world, blockPos, hitVec, direction);
            }
        }
        if (count % 20 == 0 && player instanceof ServerPlayer) {
            if (isMainHandNunchaku) {
                mainHandStack.m_41622_(2, (LivingEntity)player, e -> player.m_21190_(InteractionHand.MAIN_HAND));
            }
            if (isOffHandNunchaku) {
                offHandStack.m_41622_(2, (LivingEntity)player, e -> player.m_21190_(InteractionHand.OFF_HAND));
            }
        }
        if (count % 5 == 0) {
            double range = 2.5 * (isMainHandNunchaku && isOffHandNunchaku ? 1.5 : 1.0);
            Vec3 lookDirection = player.m_20154_();
            Vec3 start = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
            Vec3 end = start.m_82549_(lookDirection.m_82490_(range));
            AABB areaOfEffect = new AABB(start, end).m_82377_(0.5, 1.5, 0.5);
            List targets = world.m_6443_(LivingEntity.class, areaOfEffect, e -> e != player && e.m_6084_() && player.m_142582_((Entity)e) && this.isEntityInFront((LivingEntity)player, (LivingEntity)e, 90.0f));
            for (LivingEntity target : targets) {
                this.applyEffectsAndDamage((LivingEntity)player, target, mainHandStack, offHandStack, isMainHandNunchaku, isOffHandNunchaku);
            }
        }
    }

    public void spawnNunchakuParticles(ServerLevel serverLevel, BlockPos blockPos, Vec3 hitVec, Direction direction) {
        BlockState state = serverLevel.m_8055_(blockPos);
        boolean isInWater = serverLevel.m_8055_(blockPos).m_60713_(Blocks.f_49990_) || serverLevel.m_6425_(blockPos).m_192917_((Fluid)Fluids.f_76193_);
        SimpleParticleType particle = isInWater ? ParticleTypes.f_123795_ : new BlockParticleOption(ParticleTypes.f_123794_, state);
        int particleCount = isInWater ? 2 : 4;
        double offsetX = (double)direction.m_122429_() * 0.1;
        double offsetY = (double)direction.m_122430_() * 0.1;
        double offsetZ = (double)direction.m_122431_() * 0.1;
        double particleX = hitVec.f_82479_ + offsetX;
        double particleY = hitVec.f_82480_ + offsetY;
        double particleZ = hitVec.f_82481_ + offsetZ;
        serverLevel.m_8767_((ParticleOptions)particle, particleX, particleY, particleZ, particleCount, 0.01, 0.01, 0.01, 0.002);
    }

    public boolean isEntityInFront(LivingEntity attacker, LivingEntity target, float fovDegrees) {
        Vec3 attackerEyePos = attacker.m_146892_();
        Vec3 targetEyePos = target.m_146892_();
        Vec3 targetDirection = targetEyePos.m_82546_(attackerEyePos).m_82541_();
        Vec3 lookDirection = attacker.m_20154_();
        double dotProduct = lookDirection.m_82526_(targetDirection);
        double fovRad = Math.toRadians((double)fovDegrees / 2.0);
        double cosFov = Math.cos(fovRad);
        Vec3 targetDirectionXZ = new Vec3(targetDirection.f_82479_, 0.0, targetDirection.f_82481_).m_82541_();
        Vec3 lookDirectionXZ = new Vec3(lookDirection.f_82479_, 0.0, lookDirection.f_82481_).m_82541_();
        double dotProductXZ = lookDirectionXZ.m_82526_(targetDirectionXZ);
        return dotProduct >= cosFov && dotProductXZ > 0.0;
    }

    public void applyEffectsAndDamage(LivingEntity attacker, LivingEntity target, ItemStack mainHandStack, ItemStack offHandStack, boolean isMainHandNunchaku, boolean isOffHandNunchaku) {
        Player player;
        int knockbackLevel;
        int fireAspectLevel = Math.max(EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)mainHandStack), EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)offHandStack));
        if (fireAspectLevel > 0) {
            target.m_20254_(4 * fireAspectLevel);
        }
        if ((knockbackLevel = Math.max(EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)mainHandStack), EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)offHandStack))) > 0) {
            double knockbackStrength = (double)knockbackLevel * 0.5;
            double yRotRad = Math.toRadians(attacker.m_146908_());
            target.m_5997_(-Math.sin(yRotRad) * knockbackStrength, 0.1, Math.cos(yRotRad) * knockbackStrength);
        }
        if (attacker instanceof Player && ModUtils.isAlliedEntity(player = (Player)attacker, (Entity)target)) {
            return;
        }
        float enchantmentBonusMain = isMainHandNunchaku ? EnchantmentHelper.m_44833_((ItemStack)mainHandStack, (MobType)target.m_6336_()) : 0.0f;
        float enchantmentBonusOff = isOffHandNunchaku ? EnchantmentHelper.m_44833_((ItemStack)offHandStack, (MobType)target.m_6336_()) : 0.0f;
        float totalDamage = 2.0f + enchantmentBonusMain + enchantmentBonusOff;
        if (isMainHandNunchaku && isOffHandNunchaku) {
            totalDamage *= 2.0f;
        }
        totalDamage = Math.min(totalDamage, 8.0f);
        SoundEvent attackSound = isMainHandNunchaku && isOffHandNunchaku ? SoundEvents.f_12316_ : SoundEvents.f_12318_;
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), attackSound, SoundSource.HOSTILE, 0.5f, 1.0f);
        if (target.m_6469_(new DamageSource((Holder)attacker.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(attacker instanceof Player ? DamageTypes.f_268464_ : DamageTypes.f_268566_), (Entity)attacker), totalDamage)) {
            float volume = isMainHandNunchaku && isOffHandNunchaku ? 0.45f : 0.35f;
            ModUtils.playSound((Entity)attacker, "jaams_weaponry:nunchaku_hit", SoundSource.HOSTILE, volume, 1.0f);
            ModUtils.playSound((Entity)target, "minecraft:entity.player.attack.weak", SoundSource.HOSTILE, 0.35f, 1.0f);
        }
        if (target.m_21254_() && target.m_21211_().m_41763_()) {
            int blockDamage = isMainHandNunchaku && isOffHandNunchaku ? 4 : 2;
            target.m_21211_().m_41622_(blockDamage, target, e -> e.m_21190_(target.m_7655_()));
        }
    }

    public HitResult calculateHitResult(LivingEntity entity) {
        return ProjectileUtil.m_278180_((Entity)entity, p_281111_ -> !p_281111_.m_5833_() && p_281111_.m_6087_(), (double)1.5);
    }
}

