/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import java.util.List;
import net.jaams.jaams_weaponry.entity.ProngedKunaiProjectileEntity;
import net.jaams.jaams_weaponry.handler.mechanics.BackstabHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ProngedKunaiItem
extends SwordItem {
    public static float BACKSTAB_MULTIPLIER_NORMAL = 2.0f;
    public static float BACKSTAB_MULTIPLIER_SNEAKING = 2.5f;
    public static float BACKSTAB_MULTIPLIER_INVISIBLE = 3.0f;
    public static float BACKSTAB_MULTIPLIER_SNEAKING_INVISIBLE = 3.5f;
    public static double BACKSTAB_MAX_DISTANCE = 2.5;
    public static double BACKSTAB_MAX_ANGLE = 0.785;
    public static final float BACKSTAB_DURABILITY_PENALTY = 5.0f;
    public static final float RIGHT_CLICK_DURABILITY_MULTIPLIER = 2.0f;
    public static final float RIGHT_CLICK_FORWARD_IMPULSE = 0.8f;
    public static final float WEAKNESS_CHANCE = 0.0f;
    public static final int WEAKNESS_DURATION = 60;
    public static final int WEAKNESS_LEVEL = 1;
    public static final int RIGHT_CLICK_COOLDOWN = 40;
    public static final float DARKNESS_BONUS = 1.5f;
    public static final float MOVING_TARGET_PENALTY = 0.5f;
    public static final double GRACE_PERIOD_SECONDS = 0.2;
    public static final float RIGHT_CLICK_DAMAGE_BONUS = 1.0f;
    public static final float MAX_RECOIL_DISTANCE = 0.3f;
    public static final float CROUCH_RECOIL_REDUCTION = 0.3f;
    public static final float VERTICAL_RECOIL_MULTIPLIER = 0.4f;
    public static final float MAX_XROT_RECOIL_INTENSITY = 1.8f;
    public static final int MAX_DRAW_DURATION = 20;
    public static final float MIN_PROJECTILE_SPEED = 0.3f;
    public static final float MAX_PROJECTILE_SPEED = 2.5f;

    public ProngedKunaiItem() {
        super(new Tier(){

            public int m_6609_() {
                return 122;
            }

            public float m_6624_() {
                return 4.0f;
            }

            public float m_6631_() {
                return 0.0f;
            }

            public int m_6604_() {
                return 1;
            }

            public int m_6601_() {
                return 5;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42484_)});
            }
        }, 3, -2.2f, new Item.Properties());
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.SPEAR;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SWORD_DIG);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44983_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        LivingEntity target;
        Vec3 lookVec;
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        Vec3 eyePos = player.m_146892_();
        Vec3 endPos = eyePos.m_82549_((lookVec = player.m_20154_()).m_82490_(BACKSTAB_MAX_DISTANCE));
        AABB box = new AABB(endPos, endPos).m_82400_(0.5);
        List targets = level.m_6443_(LivingEntity.class, box, entity -> entity != player && (double)player.m_20270_((Entity)entity) <= BACKSTAB_MAX_DISTANCE);
        if (!targets.isEmpty() && BackstabHandler.isBackstab((LivingEntity)player, target = (LivingEntity)targets.get(0), BACKSTAB_MAX_DISTANCE, BACKSTAB_MAX_ANGLE)) {
            Player targetPlayer;
            if (target instanceof Player && (targetPlayer = (Player)target).m_7500_()) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            if (!player.m_36335_().m_41519_((Item)this)) {
                if (!level.m_5776_()) {
                    float baseDamage = this.calculateDamage(itemStack) + (float)(player.m_21133_(Attributes.f_22281_) / 2.0);
                    BackstabHandler.performRightClickBackstab((LivingEntity)player, target, itemStack, level, baseDamage, 5.0f, 2.0f, 0.8f, 0.0f, 60, 1, BACKSTAB_MULTIPLIER_NORMAL, BACKSTAB_MULTIPLIER_SNEAKING, BACKSTAB_MULTIPLIER_INVISIBLE, BACKSTAB_MULTIPLIER_SNEAKING_INVISIBLE, 1.5f, 0.5f, 1.0f);
                    player.m_36335_().m_41524_((Item)this, 40);
                    player.m_6674_(hand);
                }
                return InteractionResultHolder.m_19096_((Object)itemStack);
            }
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public InteractionResult m_6880_(ItemStack itemstack, Player player, LivingEntity target, InteractionHand hand) {
        Level level = player.m_9236_();
        if (BackstabHandler.isBackstab((LivingEntity)player, target, BACKSTAB_MAX_DISTANCE, BACKSTAB_MAX_ANGLE)) {
            Player targetPlayer;
            if (target instanceof Player && (targetPlayer = (Player)target).m_7500_()) {
                return InteractionResult.PASS;
            }
            if (!player.m_36335_().m_41519_((Item)this)) {
                if (!level.m_5776_()) {
                    float baseDamage = this.calculateDamage(itemstack) + (float)(player.m_21133_(Attributes.f_22281_) / 2.0);
                    BackstabHandler.performRightClickBackstab((LivingEntity)player, target, itemstack, level, baseDamage, 5.0f, 2.0f, 0.8f, 0.0f, 60, 1, BACKSTAB_MULTIPLIER_NORMAL, BACKSTAB_MULTIPLIER_SNEAKING, BACKSTAB_MULTIPLIER_INVISIBLE, BACKSTAB_MULTIPLIER_SNEAKING_INVISIBLE, 1.5f, 0.5f, 1.0f);
                    player.m_36335_().m_41524_((Item)this, 40);
                    player.m_6674_(hand);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        if (entity == null || sourceentity == null || !(sourceentity instanceof Player)) {
            return false;
        }
        Player player = (Player)sourceentity;
        boolean isFullyCharged = player.m_36403_(0.5f) >= 1.0f;
        Level level = entity.m_9236_();
        if (isFullyCharged && BackstabHandler.isBackstab((LivingEntity)player, entity, BACKSTAB_MAX_DISTANCE, BACKSTAB_MAX_ANGLE)) {
            BackstabHandler.performBackstab((LivingEntity)player, entity, itemstack, level, 5.0f, 0.0f, 60, 1, BACKSTAB_MULTIPLIER_NORMAL, BACKSTAB_MULTIPLIER_SNEAKING, BACKSTAB_MULTIPLIER_INVISIBLE, BACKSTAB_MULTIPLIER_SNEAKING_INVISIBLE, 1.5f, 0.5f);
        }
        return super.m_7579_(itemstack, entity, sourceentity);
    }

    public void m_5551_(ItemStack itemstack, Level level, LivingEntity entity, int durationUsed) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int remainingDuration = this.m_8105_(itemstack) - durationUsed;
            if (remainingDuration >= 5) {
                float power = ProngedKunaiItem.getPowerForTime(remainingDuration);
                float speed = this.calculateProjectileSpeed(power);
                if (!level.f_46443_) {
                    boolean isCreative = player.m_150110_().f_35937_;
                    boolean hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)itemstack) > 0;
                    int projectileCount = hasMultishot ? 3 : 1;
                    float[] shotPitches = ProngedKunaiItem.generateShotPitches(level.m_213780_(), projectileCount);
                    int pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)itemstack);
                    for (int i = 0; i < projectileCount; ++i) {
                        ProngedKunaiProjectileEntity projectile = new ProngedKunaiProjectileEntity(level, (LivingEntity)player, itemstack.m_41777_());
                        int slotIndex = entity.m_7655_() == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40;
                        projectile.setOriginalSlotIndex(slotIndex);
                        if (ModUtils.isProjectileCritical(player, power)) {
                            projectile.setCritical(true);
                        }
                        projectile.setPiercingLevel(projectile.getPiercingLevel() + pierceLevel);
                        if (hasMultishot) {
                            AbstractArrow.Pickup pickup = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : (projectile.f_36705_ = i == 0 ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED);
                            if (i != 0) {
                                projectile.getPersistentData().m_128379_("IsMultishotClone", true);
                            }
                            float spreadAngle = 10.0f;
                            float rotation = i == 0 ? 0.0f : (i == 1 ? -spreadAngle : spreadAngle);
                            Vec3 upVector = player.m_20289_(1.0f);
                            Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis(rotation * (float)Math.PI / 180.0f, (float)upVector.f_82479_, (float)upVector.f_82480_, (float)upVector.f_82481_);
                            Vec3 viewVector = player.m_20252_(1.0f);
                            Vector3f rotatedVector = new Vector3f((float)viewVector.f_82479_, (float)viewVector.f_82480_, (float)viewVector.f_82481_).rotate((Quaternionfc)rotationQuaternion);
                            if (i == 0) {
                                float forwardOffset = 1.0f;
                                Vec3 offset = viewVector.m_82490_((double)forwardOffset);
                                projectile.m_6034_(player.m_20185_() + offset.f_82479_, player.m_20188_() + offset.f_82480_, player.m_20189_() + offset.f_82481_);
                            }
                            projectile.m_6686_(rotatedVector.x(), rotatedVector.y(), rotatedVector.z(), speed, 1.0f);
                        } else {
                            projectile.f_36705_ = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                            projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, speed, 1.0f);
                        }
                        projectile.setWeaponItem(itemstack.m_41777_());
                        level.m_7967_((Entity)projectile);
                        SoundEvent shootSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:pronged_kunai_throw"));
                        level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), shootSound != null ? shootSound : SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, shotPitches[i]);
                    }
                    if (!isCreative) {
                        itemstack.m_41622_(1, (LivingEntity)player, brokenItemStack -> brokenItemStack.m_21190_(entity.m_7655_()));
                        itemstack.m_41774_(1);
                    }
                    float recoilDistance = 0.3f * power;
                    ModUtils.applyRecoil((LivingEntity)player, recoilDistance, 0.3f, 0.4f);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                } else {
                    float xrotRecoil = 1.8f * power;
                    player.m_146926_(player.m_146909_() - xrotRecoil);
                }
            }
        }
    }

    public static float getPowerForTime(int duration) {
        float f = (float)duration / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    private float calculateProjectileSpeed(float power) {
        float speedRange = 2.2f;
        float scaledPower = power * power;
        return 0.3f + speedRange * scaledPower;
    }

    public static float[] generateShotPitches(RandomSource random, int projectileCount) {
        float[] pitches = new float[projectileCount];
        for (int i = 0; i < projectileCount; ++i) {
            boolean flag = random.m_188499_();
            pitches[i] = 1.0f / (random.m_188501_() * 0.5f + 1.8f) + (flag ? 0.63f : 0.43f);
        }
        return pitches;
    }

    private float calculateDamage(ItemStack itemStack) {
        AttributeModifier modifier = itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().findFirst().orElse(null);
        return modifier != null ? (float)modifier.m_22218_() : 1.0f;
    }
}

