/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import java.util.List;
import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.entity.RoyalAxeProjectileEntity;
import net.jaams.jaams_weaponry.handler.mechanics.DisablerHandler;
import net.jaams.jaams_weaponry.handler.mechanics.SweepAttackHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RoyalAxeItem
extends AxeItem {
    public static final double SWEEP_RANGE = 3.0;
    public static final float BASE_DAMAGE_PERCENT = 0.7f;
    public static final int WEAPON_DAMAGE_PENALTY = 2;
    public static final boolean DAMAGE_BY_ENEMY_COUNT = true;
    public static final int NON_SHIELD_DISABLE_TICKS = 100;
    public static final float BASE_FULLY_CHARGED_CHANCE = 0.05f;
    public static final float CHANCE_INCREMENT = 0.05f;
    public static final float MAX_RECOIL_DISTANCE = 0.6f;
    public static final float CROUCH_RECOIL_REDUCTION = 0.3f;
    public static final float VERTICAL_RECOIL_MULTIPLIER = 0.4f;
    public static final float MAX_XROT_RECOIL_INTENSITY = 3.5f;
    public static final float MAX_DRAW_DURATION = 20.0f;
    public static final float MIN_PROJECTILE_SPEED = 0.2f;
    public static final float MAX_PROJECTILE_SPEED = 1.5f;

    public RoyalAxeItem() {
        super(new Tier(){

            public int m_6609_() {
                return 1600;
            }

            public float m_6624_() {
                return 8.0f;
            }

            public float m_6631_() {
                return 10.0f;
            }

            public int m_6604_() {
                return 2;
            }

            public int m_6601_() {
                return 16;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_151265_();
            }
        }, 1.0f, -3.2f, new Item.Properties());
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.AXE_DIG);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44981_ || enchantment == Enchantments.f_44979_ || enchantment == Enchantments.f_44978_ || enchantment == Enchantments.f_44982_ || enchantment == Enchantments.f_44961_ || enchantment == Enchantments.f_44959_ || enchantment == Enchantments.f_44958_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.SPEAR;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null || !(sourceentity instanceof Player)) {
            return false;
        }
        Player player = (Player)sourceentity;
        boolean isFullyCharged = player.m_36403_(0.5f) >= 1.0f;
        player.getCapability(AmountProvider.AMOUNT).ifPresent(amount -> {
            float baseDamage = amount.getDamage();
            this.applyAttackEffects(itemstack, entity, player, baseDamage, isFullyCharged);
        });
        return retval;
    }

    public void applyAttackEffects(ItemStack itemstack, LivingEntity entity, Player player, float baseDamage, boolean isFullyCharged) {
        float entityHealth = entity.m_21223_();
        boolean isEnemyUsingItem = !entity.m_21205_().m_41619_() || !entity.m_21206_().m_41619_();
        float fullyChargedChance = 0.05f + (isEnemyUsingItem ? 0.05f : 0.0f);
        if (isFullyCharged) {
            this.applyItemDisable(entity);
            if (player != null && (player.m_21205_() == itemstack || player.m_21206_() == itemstack)) {
                this.performSweepAttackWithDisable(itemstack, entity, player);
            }
        }
    }

    public void performSweepAttackWithDisable(ItemStack itemstack, LivingEntity entity, Player player) {
        SweepAttackHandler.performSweepAttack(itemstack, entity, (LivingEntity)player, 3.0f, 0.7f, 2, true, SoundEvents.f_12317_, (ParticleOptions)ParticleTypes.f_123766_, nearby -> SweepAttackHandler.isValidSweepTarget(nearby, entity, (LivingEntity)player, player.m_20154_()));
        Level level = entity.m_9236_();
        AABB sweepArea = new AABB(entity.m_20182_().m_82520_(-3.0, -3.0, -3.0), entity.m_20182_().m_82520_(3.0, 3.0, 3.0));
        List nearbyEnemies = level.m_6443_(LivingEntity.class, sweepArea, nearby -> SweepAttackHandler.isValidSweepTarget(nearby, entity, (LivingEntity)player, player.m_20154_()));
        for (LivingEntity nearby2 : nearbyEnemies) {
            this.applyItemDisable(nearby2);
        }
    }

    public void applyItemDisable(LivingEntity entity) {
        if (entity.m_6117_()) {
            ItemStack activeItem = entity.m_21211_();
            if (!activeItem.m_41619_() && !(activeItem.m_41720_() instanceof ShieldItem)) {
                DisablerHandler.disableActiveItem(entity, 100);
            }
        } else {
            ItemStack mainHandItem = entity.m_21205_();
            ItemStack offHandItem = entity.m_21206_();
            if (!mainHandItem.m_41619_() && !(mainHandItem.m_41720_() instanceof ShieldItem)) {
                DisablerHandler.disableActiveItem(entity, 100);
            } else if (!offHandItem.m_41619_() && !(offHandItem.m_41720_() instanceof ShieldItem)) {
                DisablerHandler.disableActiveItem(entity, 100);
            }
        }
    }

    public void m_5551_(ItemStack itemstack, Level level, LivingEntity entity, int durationUsed) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int remainingDuration = this.m_8105_(itemstack) - durationUsed;
            if (remainingDuration >= 5) {
                if (!level.f_46443_) {
                    float power = RoyalAxeItem.getPowerForTime(remainingDuration);
                    float speed = this.calculateProjectileSpeed(power);
                    boolean isCreative = player.m_150110_().f_35937_;
                    boolean hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)itemstack) > 0;
                    int projectileCount = hasMultishot ? 3 : 1;
                    float[] shotPitches = RoyalAxeItem.generateShotPitches(level.m_213780_(), projectileCount);
                    int pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)itemstack);
                    for (int i = 0; i < projectileCount; ++i) {
                        RoyalAxeProjectileEntity projectile = new RoyalAxeProjectileEntity(level, (LivingEntity)player, itemstack.m_41777_());
                        int slotIndex = entity.m_7655_() == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40;
                        projectile.setOriginalSlotIndex(slotIndex);
                        if (ModUtils.isProjectileCritical(player, power)) {
                            projectile.setCritical(true);
                        }
                        projectile.setPiercingLevel(projectile.getPiercingLevel() + pierceLevel);
                        if (hasMultishot) {
                            AbstractArrow.Pickup pickup = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : (projectile.f_36705_ = i == 0 ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED);
                            if (i != 0) {
                                projectile.getPersistentData().m_128379_("IsMultishotClone", true);
                            }
                            float spreadAngle = 10.0f;
                            float rotation = i == 0 ? 0.0f : (i == 1 ? -spreadAngle : spreadAngle);
                            Vec3 upVector = player.m_20289_(1.0f);
                            Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis(rotation * (float)Math.PI / 180.0f, (float)upVector.f_82479_, (float)upVector.f_82480_, (float)upVector.f_82481_);
                            Vec3 viewVector = player.m_20252_(1.0f);
                            Vector3f rotatedVector = new Vector3f((float)viewVector.f_82479_, (float)viewVector.f_82480_, (float)viewVector.f_82481_).rotate((Quaternionfc)rotationQuaternion);
                            if (i == 0) {
                                float forwardOffset = 1.0f;
                                Vec3 offset = viewVector.m_82490_((double)forwardOffset);
                                projectile.m_6034_(player.m_20185_() + offset.f_82479_, player.m_20188_() + offset.f_82480_, player.m_20189_() + offset.f_82481_);
                            }
                            projectile.m_6686_(rotatedVector.x(), rotatedVector.y(), rotatedVector.z(), speed, 1.0f);
                        } else {
                            projectile.f_36705_ = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                            projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, speed, 1.0f);
                        }
                        projectile.setWeaponItem(itemstack.m_41777_());
                        level.m_7967_((Entity)projectile);
                        SoundEvent shootSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:royal_axe_throw"));
                        level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), shootSound != null ? shootSound : SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, shotPitches[i]);
                    }
                    if (!isCreative) {
                        itemstack.m_41622_(1, (LivingEntity)player, brokenItemStack -> brokenItemStack.m_21190_(entity.m_7655_()));
                        itemstack.m_41774_(1);
                    }
                    float recoilDistance = 0.6f * power;
                    ModUtils.applyRecoil((LivingEntity)player, recoilDistance, 0.3f, 0.4f);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                } else {
                    float power = RoyalAxeItem.getPowerForTime(remainingDuration);
                    float xrotRecoil = 3.5f * power;
                    player.m_146926_(player.m_146909_() - xrotRecoil);
                }
            }
        }
    }

    public static float getPowerForTime(int duration) {
        float f = (float)duration / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    private float calculateProjectileSpeed(float power) {
        float speedRange = 1.3f;
        float scaledPower = power * power;
        return 0.2f + speedRange * scaledPower;
    }

    public static float[] generateShotPitches(RandomSource random, int projectileCount) {
        float[] pitches = new float[projectileCount];
        for (int i = 0; i < projectileCount; ++i) {
            boolean flag = random.m_188499_();
            pitches[i] = 1.0f / (random.m_188501_() * 0.5f + 1.8f) + (flag ? 0.63f : 0.43f);
        }
        return pitches;
    }
}

