/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RoyalCrossbowItem
extends CrossbowItem {
    private static final Random RANDOM = new Random();
    public static final float MAX_VELOCITY = 4.5f;
    public static final int LOAD_TIME = 15;
    public boolean startSoundPlayed = false;
    public boolean midLoadSoundPlayed = false;

    public RoyalCrossbowItem() {
        super(new Item.Properties().m_41503_(426).m_41497_(Rarity.COMMON));
    }

    public int m_6473_() {
        return 16;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (RoyalCrossbowItem.m_40932_((ItemStack)stack)) {
            RoyalCrossbowItem.executeShooting(level, (LivingEntity)player, hand, stack, RoyalCrossbowItem.m_40945_(stack), 1.0f);
            RoyalCrossbowItem.m_40884_((ItemStack)stack, (boolean)false);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (!player.m_6298_(stack).m_41619_()) {
            if (!RoyalCrossbowItem.m_40932_((ItemStack)stack)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                player.m_6672_(hand);
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public static float m_40945_(ItemStack stack) {
        return RoyalCrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 0.7f : 4.5f;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        int i = this.m_8105_(stack) - timeLeft;
        float f = RoyalCrossbowItem.m_40853_(i, stack);
        if (f >= 1.0f && !RoyalCrossbowItem.m_40932_((ItemStack)stack) && RoyalCrossbowItem.m_40859_(entityLiving, stack)) {
            RoyalCrossbowItem.m_40884_((ItemStack)stack, (boolean)true);
            SoundSource source = entityLiving instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            level.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_11841_, source, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public static float m_40853_(int useTime, ItemStack stack) {
        float f = (float)useTime / (float)RoyalCrossbowItem.m_40939_(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static boolean m_40859_(LivingEntity shooter, ItemStack stack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack);
        int j = i == 0 ? 1 : 3;
        boolean flag = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
        ItemStack projectile = shooter.m_6298_(stack);
        ItemStack copy = projectile.m_41777_();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                projectile = copy.m_41777_();
            }
            if (projectile.m_41619_() && flag) {
                projectile = new ItemStack((ItemLike)Items.f_42412_);
                copy = projectile.m_41777_();
            }
            if (RoyalCrossbowItem.m_40862_(shooter, stack, projectile, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    public static boolean m_40862_(LivingEntity shooter, ItemStack stack, ItemStack ammo, boolean hasAmmo, boolean isCreative) {
        ItemStack itemstack;
        boolean flag;
        if (ammo.m_41619_()) {
            return false;
        }
        boolean bl = flag = isCreative && ammo.m_41720_() instanceof ArrowItem;
        if (!(flag || isCreative || hasAmmo)) {
            itemstack = ammo.m_41620_(1);
            if (ammo.m_41619_() && shooter instanceof Player) {
                ((Player)shooter).m_150109_().m_36057_(ammo);
            }
        } else {
            itemstack = ammo.m_41777_();
        }
        RoyalCrossbowItem.m_40928_(stack, itemstack);
        return true;
    }

    public static void m_40928_(ItemStack stack, ItemStack ammo) {
        CompoundTag tag = stack.m_41784_();
        ListTag list = tag.m_128425_("ChargedProjectiles", 9) ? tag.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag ammoTag = new CompoundTag();
        ammo.m_41739_(ammoTag);
        list.add((Object)ammoTag);
        tag.m_128365_("ChargedProjectiles", (Tag)list);
    }

    public static int m_40939_(ItemStack stack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        return i == 0 ? 15 : 15 - RoyalCrossbowItem.getChargeTimeReductionPerQuickChargeLevel() * i;
    }

    public static int getChargeTimeReductionPerQuickChargeLevel() {
        return 2;
    }

    public int m_8105_(ItemStack stack) {
        return RoyalCrossbowItem.m_40939_(stack) + 3;
    }

    private static void fireProjectile(Level level, LivingEntity entity, InteractionHand hand, ItemStack crossbow, ItemStack projectile, float pitch, boolean isCreative, float velocity, float inaccuracy, float rotation) {
        if (!level.f_46443_) {
            AbstractArrow proj;
            boolean isFirework = projectile.m_150930_(Items.f_42688_);
            if (isFirework) {
                proj = new FireworkRocketEntity(level, projectile, (Entity)entity, entity.m_20185_(), entity.m_20188_() - 0.15, entity.m_20189_(), true);
            } else {
                proj = RoyalCrossbowItem.createArrowProjectile(level, entity, crossbow, projectile);
                if (isCreative || rotation != 0.0f) {
                    proj.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            if (entity instanceof CrossbowAttackMob) {
                CrossbowAttackMob mob = (CrossbowAttackMob)entity;
                mob.m_5811_(mob.m_5448_(), crossbow, (Projectile)proj, rotation);
            } else {
                Vec3 up = entity.m_20289_(1.0f);
                Quaternionf quat = new Quaternionf().setAngleAxis((double)(rotation * (float)Math.PI / 180.0f), up.f_82479_, up.f_82480_, up.f_82481_);
                Vec3 view = entity.m_20252_(1.0f);
                Vector3f rotated = view.m_252839_().rotate((Quaternionfc)quat);
                proj.m_6686_((double)rotated.x(), (double)rotated.y(), (double)rotated.z(), velocity, inaccuracy);
            }
            crossbow.m_41622_(isFirework ? 3 : 1, entity, e -> e.m_21190_(hand));
            level.m_7967_((Entity)proj);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, pitch);
        }
    }

    private static AbstractArrow createArrowProjectile(Level level, LivingEntity shooter, ItemStack crossbow, ItemStack arrow) {
        int punch;
        int power;
        int pierce;
        ArrowItem arrowItem = (ArrowItem)(arrow.m_41720_() instanceof ArrowItem ? arrow.m_41720_() : Items.f_42412_);
        AbstractArrow proj = arrowItem.m_6394_(level, arrow, shooter);
        if (shooter instanceof Player) {
            proj.m_36762_(true);
        }
        proj.m_36740_(SoundEvents.f_11840_);
        proj.m_36793_(true);
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)crossbow) > 0) {
            proj.m_20254_(100);
        }
        if ((pierce = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crossbow)) > 0) {
            proj.m_36767_((byte)(pierce + 1));
        }
        if ((power = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)crossbow)) > 0) {
            proj.m_36781_(proj.m_36789_() + (double)power * 0.5 + 0.5);
        }
        if ((punch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)crossbow)) > 0) {
            proj.m_36735_(punch + 1);
        }
        return proj;
    }

    public static void executeShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack stack, float velocity, float inaccuracy) {
        Player player;
        if (shooter instanceof Player && MinecraftForge.EVENT_BUS.post((Event)new ArrowLooseEvent(player = (Player)shooter, stack, level, 1, true))) {
            return;
        }
        List<ItemStack> projectiles = RoyalCrossbowItem.m_40941_(stack);
        float[] pitches = RoyalCrossbowItem.generateShotPitches(shooter.m_217043_());
        for (int i = 0; i < projectiles.size(); ++i) {
            boolean isCreative;
            ItemStack proj = projectiles.get(i);
            boolean bl = isCreative = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
            if (proj.m_41619_()) continue;
            if (i == 0) {
                RoyalCrossbowItem.fireProjectile(level, shooter, hand, stack, proj, pitches[i], isCreative, velocity, inaccuracy, 0.0f);
                continue;
            }
            if (i == 1) {
                RoyalCrossbowItem.fireProjectile(level, shooter, hand, stack, proj, pitches[i], isCreative, velocity, inaccuracy, -10.0f);
                continue;
            }
            if (i != 2) continue;
            RoyalCrossbowItem.fireProjectile(level, shooter, hand, stack, proj, pitches[i], isCreative, velocity, inaccuracy, 10.0f);
        }
        RoyalCrossbowItem.handleCrossbowShot(level, shooter, stack);
    }

    private static void handleCrossbowShot(Level level, LivingEntity shooter, ItemStack stack) {
        if (shooter instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)shooter;
            if (!level.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(player, stack);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
        }
        RoyalCrossbowItem.m_40943_(stack);
    }

    private static float[] generateShotPitches(RandomSource random) {
        boolean flag = random.m_188499_();
        return new float[]{1.0f, RoyalCrossbowItem.m_220025_(flag, random), RoyalCrossbowItem.m_220025_(!flag, random)};
    }

    private static List<ItemStack> m_40941_(ItemStack stack) {
        ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("ChargedProjectiles", 9)) {
            ListTag list = tag.m_128437_("ChargedProjectiles", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag projTag = list.m_128728_(i);
                projectiles.add(ItemStack.m_41712_((CompoundTag)projTag));
            }
        }
        return projectiles;
    }

    private static void m_40943_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            ListTag list = tag.m_128437_("ChargedProjectiles", 9);
            list.clear();
            tag.m_128365_("ChargedProjectiles", (Tag)list);
        }
    }

    private static float m_220025_(boolean flag, RandomSource random) {
        float f = flag ? 0.63f : 0.43f;
        return 1.0f / (random.m_188501_() * 0.5f + 1.8f) + f;
    }
}

