/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.handler.mechanics.BackstabHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModMobEffects;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;

public class RoyalRapierItem
extends SwordItem {
    private static final float DASH_DISTANCE = 1.0f;
    private static final float MAX_DASH_DISTANCE = 2.5f;
    private static final float COOLDOWN_DURATION = 40.0f;
    private static final float HIT_BOX_INFLATE = 0.5f;
    private static final double DOT_PRODUCT_THRESHOLD = 0.65;
    public static final float BACKSTAB_MULTIPLIER_NORMAL = 2.0f;
    public static final float BACKSTAB_MULTIPLIER_SNEAKING = 2.5f;
    public static final float BACKSTAB_MULTIPLIER_INVISIBLE = 3.0f;
    public static final float BACKSTAB_MULTIPLIER_SNEAKING_INVISIBLE = 3.5f;
    public static final float BACKSTAB_DURABILITY_PENALTY = 3.0f;
    public static final float RIGHT_CLICK_DURABILITY_MULTIPLIER = 2.0f;
    public static final float RIGHT_CLICK_FORWARD_IMPULSE = 0.8f;
    public static final double BACKSTAB_MAX_DISTANCE = 3.5;
    public static final double BACKSTAB_MAX_ANGLE = Math.toRadians(60.0);
    public static final float WEAKNESS_CHANCE = 0.1f;
    public static final int WEAKNESS_DURATION = 60;
    public static final int WEAKNESS_LEVEL = 1;
    public static final int RIGHT_CLICK_COOLDOWN = 40;
    public static final float DARKNESS_BONUS = 0.5f;
    public static final float MOVING_TARGET_PENALTY = 0.2f;
    public static final double GRACE_PERIOD_SECONDS = 0.2;
    public static final float RIGHT_CLICK_DAMAGE_BONUS = 3.0f;
    private static final float DASH_BACKSTAB_BONUS_MULTIPLIER = 2.5f;

    public RoyalRapierItem() {
        super(new Tier(){

            public int m_6609_() {
                return 1100;
            }

            public float m_6624_() {
                return 8.0f;
            }

            public float m_6631_() {
                return 2.0f;
            }

            public int m_6604_() {
                return 2;
            }

            public int m_6601_() {
                return 16;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_151265_();
            }
        }, 3, -2.2f, new Item.Properties());
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private static final HumanoidModel.ArmPose RAPIER_MAIN_HAND_POSE = HumanoidModel.ArmPose.create((String)"RAPIER_MAIN_HAND", (boolean)false, (model, entity, arm) -> {
                if (arm == HumanoidArm.RIGHT) {
                    model.f_102811_.f_104203_ = -1.4279966f + model.f_102808_.f_104203_;
                    model.f_102811_.f_104204_ = -0.1f + model.f_102808_.f_104204_;
                }
            });
            private static final HumanoidModel.ArmPose RAPIER_OFF_HAND_POSE = HumanoidModel.ArmPose.create((String)"RAPIER_OFF_HAND", (boolean)false, (model, entity, arm) -> {
                if (arm == HumanoidArm.LEFT) {
                    model.f_102812_.f_104203_ = -1.4279966f + model.f_102808_.f_104203_;
                    model.f_102812_.f_104204_ = 0.1f + model.f_102808_.f_104204_;
                }
            });

            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                if (!(itemInHand.m_41720_() instanceof RoyalRapierItem)) {
                    return false;
                }
                String animation = ModUtils.getPlayerAnimation((Player)player);
                if ("rapier".equals(animation)) {
                    int direction = arm == HumanoidArm.RIGHT ? 1 : -1;
                    poseStack.m_252880_(0.6f * (float)direction, -0.4f, -0.8f);
                    poseStack.m_85841_(1.2f, 1.2f, 1.2f);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-45.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(10.0f * (float)direction));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(5.0f * (float)direction));
                    return true;
                }
                return false;
            }

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                Player player;
                block7: {
                    block6: {
                        if (!(entityLiving instanceof Player)) break block6;
                        player = (Player)entityLiving;
                        if (itemStack.m_41720_() instanceof RoyalRapierItem) break block7;
                    }
                    return HumanoidModel.ArmPose.ITEM;
                }
                String animation = ModUtils.getPlayerAnimation(player);
                if ("rapier".equals(animation)) {
                    if (hand == InteractionHand.MAIN_HAND && player.m_21205_() == itemStack) {
                        return RAPIER_MAIN_HAND_POSE;
                    }
                    if (hand == InteractionHand.OFF_HAND && player.m_21206_() == itemStack) {
                        return RAPIER_OFF_HAND_POSE;
                    }
                }
                return HumanoidModel.ArmPose.ITEM;
            }
        });
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SWORD_DIG);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != Enchantments.f_44983_ && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36335_().m_41519_((Item)this) || !player.m_20142_() || !player.m_20096_()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!level.m_5776_()) {
            this.activateRapierDash(level, player, stack, hand, null);
            this.applyCooldowns(player, hand);
            this.applyItemDamage(level, player, stack);
        }
        if (ModUtils.isEntityInBattleMode((Entity)player)) {
            player.m_21011_(hand, true);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public InteractionResult m_6880_(ItemStack itemstack, Player player, LivingEntity target, InteractionHand hand) {
        if (target == null || !target.m_6084_()) {
            return InteractionResult.FAIL;
        }
        Level level = player.m_9236_();
        if (!level.f_46443_ && BackstabHandler.isBackstab((LivingEntity)player, target, 3.5, BACKSTAB_MAX_ANGLE)) {
            Player targetPlayer;
            if (target instanceof Player && (targetPlayer = (Player)target).m_7500_()) {
                return InteractionResult.PASS;
            }
            if (!player.m_36335_().m_41519_((Item)this)) {
                float baseDamage = this.calculateDamage(itemstack) + (float)(player.m_21133_(Attributes.f_22281_) / 2.0);
                BackstabHandler.performRightClickBackstab((LivingEntity)player, target, itemstack, level, baseDamage, 3.0f, 2.0f, 0.8f, 0.1f, 60, 1, 2.0f, 2.5f, 3.0f, 3.5f, 0.5f, 0.2f, 3.0f);
                player.m_36335_().m_41524_((Item)this, 40);
                player.m_6674_(hand);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (player.m_36335_().m_41519_((Item)this) || !player.m_20096_() || !player.m_20142_()) {
            return InteractionResult.FAIL;
        }
        if (!level.m_5776_()) {
            Vec3 lookVec = this.getDashDirection(player, target);
            this.applyEntityDamage(level, player, itemstack, target, lookVec);
            this.applyDashMovement(player, lookVec);
            this.playDashSound(level, player);
            this.applyDepletionEffect(level, player);
            this.applyCooldowns(player, hand);
            this.applyItemDamage(level, player, itemstack);
            this.startDashAnimation(player, itemstack);
        }
        if (ModUtils.isEntityInBattleMode((Entity)player)) {
            player.m_21011_(hand, true);
        }
        return InteractionResult.CONSUME;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean isBackstab;
        if (entity == null || sourceentity == null || !(sourceentity instanceof Player)) {
            return false;
        }
        Player player = (Player)sourceentity;
        boolean isFullyCharged = player.m_36403_(0.5f) >= 1.0f;
        Level level = entity.m_9236_();
        if (isFullyCharged && (isBackstab = BackstabHandler.isBackstab((LivingEntity)player, entity, 3.5, BACKSTAB_MAX_ANGLE))) {
            BackstabHandler.performBackstab((LivingEntity)player, entity, itemstack, level, 3.0f, 0.1f, 60, 1, 2.0f, 2.5f, 3.0f, 3.5f, 0.5f, 0.2f);
        }
        return super.m_7579_(itemstack, entity, sourceentity);
    }

    private void activateRapierDash(Level level, Player player, ItemStack stack, InteractionHand hand, @Nullable LivingEntity targetEntity) {
        if (!player.m_7500_()) {
            float exhaustion = 1.0f + player.m_217043_().m_188501_() * 1.0f;
            player.m_36324_().m_38703_(exhaustion);
        }
        this.setDashHandTag(stack, hand);
        Vec3 lookVec = this.getDashDirection(player, targetEntity);
        this.applyDashMovement(player, lookVec);
        this.applyDashHit(level, player, stack, lookVec);
        this.playDashSound(level, player);
        this.applyDepletionEffect(level, player);
        this.handleItemBreakEffects(level, player, stack);
        this.startDashAnimation(player, stack);
    }

    private void setDashHandTag(ItemStack stack, InteractionHand hand) {
        stack.m_41784_().m_128359_("rapier_dash_hand", hand == InteractionHand.MAIN_HAND ? "main" : "off");
    }

    private Vec3 getDashDirection(Player player, @Nullable LivingEntity targetEntity) {
        if (targetEntity != null) {
            return targetEntity.m_146892_().m_82546_(player.m_20182_().m_82520_(0.0, (double)player.m_20192_() * 0.5, 0.0)).m_82541_();
        }
        return player.m_20154_().m_82541_();
    }

    private void applyDashMovement(Player player, Vec3 direction) {
        double movementSpeed = player.m_21133_(Attributes.f_22279_);
        double knockbackResistance = Math.max(0.0, Math.min(1.0, player.m_21133_(Attributes.f_22278_)));
        double baseMovementSpeed = 0.1;
        float speedMultiplier = (float)Math.max(0.1, movementSpeed / baseMovementSpeed);
        float knockbackModifier = (float)(1.0 - knockbackResistance * 1.4);
        float adjustedDashDistance = Math.min(1.0f * speedMultiplier * knockbackModifier, 2.5f);
        adjustedDashDistance = Math.max(0.2f, adjustedDashDistance);
        Vec3 dashMotion = direction.m_82541_().m_82490_((double)adjustedDashDistance);
        player.m_20256_(player.m_20184_().m_82520_(dashMotion.f_82479_, 0.0, dashMotion.f_82481_));
        player.f_19864_ = true;
    }

    private void applyDashHit(Level level, Player player, ItemStack stack, Vec3 lookVec) {
        Vec3 startPos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_() * 0.5, 0.0);
        AABB hitBox = player.m_20191_().m_82377_(1.0, 1.0, 1.0);
        List entities = level.m_6443_(LivingEntity.class, hitBox, e -> e != player && e.m_6084_() && !ModUtils.isAlliedEntity(player, (Entity)e));
        LivingEntity closestEntity = null;
        double closestDotProduct = -1.0;
        for (LivingEntity entity : entities) {
            double dotProduct;
            if (!this.isEntityInDashPath(entity, startPos, lookVec) || !((dotProduct = entity.m_146892_().m_82546_(startPos).m_82541_().m_82526_(lookVec)) > closestDotProduct) || !(dotProduct > 0.65)) continue;
            closestEntity = entity;
            closestDotProduct = dotProduct;
        }
        if (closestEntity != null) {
            this.applyEntityDamage(level, player, stack, closestEntity, lookVec);
        }
    }

    private boolean isEntityInDashPath(LivingEntity entity, Vec3 startPos, Vec3 lookVec) {
        Vec3 toEntity = entity.m_146892_().m_82546_(startPos);
        double distance = toEntity.m_82553_();
        if (distance > 1.5) {
            return false;
        }
        Vec3 toEntityNormalized = toEntity.m_82541_();
        double dotProduct = toEntityNormalized.m_82526_(lookVec);
        return dotProduct > 0.65;
    }

    private void applyEntityDamage(Level level, Player player, ItemStack stack, LivingEntity target, Vec3 lookVec) {
        boolean hasRapierInBothHands;
        if (ModUtils.isAlliedEntity(player, (Entity)target)) {
            return;
        }
        float baseDamage = this.calculateDamage(stack);
        float enchantmentDamage = this.calculateEnchantmentDamage(stack, target);
        float playerAttackDamage = (float)player.m_21133_(Attributes.f_22281_);
        float totalDamage = (baseDamage + playerAttackDamage + enchantmentDamage) * 0.6f - 1.0f;
        boolean bl = hasRapierInBothHands = player.m_21205_().m_41720_() instanceof RoyalRapierItem && player.m_21206_().m_41720_() instanceof RoyalRapierItem;
        if (hasRapierInBothHands) {
            totalDamage *= 1.5f;
        }
        if ((totalDamage = this.applyEnchantmentEffects(stack, target, totalDamage, lookVec)) > 0.0f) {
            target.m_6469_(this.createDamageSource(level, player), totalDamage);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.playHitSound(serverLevel, target);
                this.emitCriticalParticles(serverLevel, target);
            }
            if (target instanceof Mob) {
                Mob mob = (Mob)target;
                if (!player.m_7500_()) {
                    mob.m_6710_((LivingEntity)player);
                }
            }
        }
    }

    private float calculateEnchantmentDamage(ItemStack stack, LivingEntity target) {
        int baneLevel;
        int smiteLevel;
        float damage = 0.0f;
        int sharpnessLevel = stack.getEnchantmentLevel(Enchantments.f_44977_);
        if (sharpnessLevel > 0) {
            damage += 1.0f + (float)sharpnessLevel * 0.5f;
        }
        if ((smiteLevel = stack.getEnchantmentLevel(Enchantments.f_44978_)) > 0 && target.m_6336_() == MobType.f_21641_) {
            damage += (float)smiteLevel * 1.5f;
        }
        if ((baneLevel = stack.getEnchantmentLevel(Enchantments.f_44979_)) > 0 && target.m_6336_() == MobType.f_21642_) {
            damage += (float)baneLevel * 1.5f;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
        }
        return damage;
    }

    private float applyEnchantmentEffects(ItemStack stack, LivingEntity entity, float baseDamage, Vec3 lookVec) {
        float damage = baseDamage;
        int fireAspectLevel = stack.getEnchantmentLevel(Enchantments.f_44981_);
        int knockbackLevel = stack.getEnchantmentLevel(Enchantments.f_44980_);
        int smiteLevel = stack.getEnchantmentLevel(Enchantments.f_44978_);
        int baneOfArthropodsLevel = stack.getEnchantmentLevel(Enchantments.f_44979_);
        if (fireAspectLevel > 0) {
            entity.m_20254_(fireAspectLevel * 4);
        }
        if (knockbackLevel > 0) {
            double knockbackStrength = (double)knockbackLevel * 0.5;
            Vec3 knockbackVec = lookVec.m_82490_(knockbackStrength);
            entity.m_5997_(knockbackVec.f_82479_, knockbackVec.f_82480_ + 0.1, knockbackVec.f_82481_);
        }
        if (smiteLevel > 0 && entity.m_6336_() == MobType.f_21641_) {
            damage += (float)smiteLevel * 2.5f;
        }
        if (baneOfArthropodsLevel > 0 && entity.m_6336_() == MobType.f_21642_) {
            damage += (float)baneOfArthropodsLevel * 2.5f;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20 * baneOfArthropodsLevel, 3));
        }
        return damage;
    }

    private void playDashSound(Level level, Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ResourceLocation dashSound = new ResourceLocation("jaams_weaponry:dash");
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(dashSound);
            serverLevel.m_5594_(null, player.m_20183_(), sound != null ? sound : SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private void playHitSound(ServerLevel serverLevel, LivingEntity entity) {
        ResourceLocation soundLocation = new ResourceLocation("jaams_weaponry:rapier_hit");
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation);
        serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), sound != null ? sound : SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void applyDepletionEffect(Level level, Player player) {
        if (((Boolean)JaamsWeaponryCommonConfiguration.DEPLETION.get()).booleanValue() && !level.m_5776_()) {
            player.m_7292_(new MobEffectInstance((MobEffect)JaamsWeaponryModMobEffects.DEPLETION.get(), 20, 1, false, false, true));
        }
    }

    private void handleItemBreakEffects(Level level, Player player, ItemStack stack) {
        if (this.shouldEmitBreakParticles(stack)) {
            this.emitBreakParticles(level, player, stack);
        }
    }

    private boolean shouldEmitBreakParticles(ItemStack stack) {
        return stack.m_41773_() >= stack.m_41776_() - 2;
    }

    private void emitBreakParticles(Level level, Player player, ItemStack stack) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 look = player.m_20154_();
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), player.m_20185_() + look.f_82479_ * 0.5, player.m_20186_() + (double)player.m_20192_(), player.m_20189_() + look.f_82481_ * 0.5, 5, 0.1, 0.1, 0.1, 0.05);
        }
    }

    private void emitCriticalParticles(ServerLevel serverLevel, LivingEntity entity) {
        int particleCount = 6;
        double spread = 0.35;
        double speed = 0.15;
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = (serverLevel.f_46441_.m_188500_() - 0.5) * spread;
            double offsetY = (serverLevel.f_46441_.m_188500_() - 0.5) * spread;
            double offsetZ = (serverLevel.f_46441_.m_188500_() - 0.5) * spread;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, entity.m_20185_() + offsetX, entity.m_20186_() + 1.0 + offsetY, entity.m_20189_() + offsetZ, 1, spread, spread, spread, speed);
        }
    }

    private void startDashAnimation(Player player, ItemStack stack) {
        ModUtils.applyAnimation((Entity)player, "rapier", 10);
        stack.m_41784_().m_128359_("rapier_dash_hand", player.m_7655_() == InteractionHand.MAIN_HAND ? "main" : "off");
    }

    private void applyCooldowns(Player player, InteractionHand hand) {
        ItemCooldowns cooldowns = player.m_36335_();
        cooldowns.m_41524_((Item)this, 40);
    }

    private void applyItemDamage(Level level, Player player, ItemStack stack) {
        if (!player.m_7500_() && stack.m_220157_(2, player.m_217043_(), null)) {
            stack.m_41774_(1);
            stack.m_41721_(0);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_5594_(null, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    private DamageSource createDamageSource(Level level, Player player) {
        Holder.Reference damageTypeHolder = level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268464_);
        return new DamageSource((Holder)damageTypeHolder, (Entity)player);
    }

    private float calculateDamage(ItemStack itemStack) {
        AttributeModifier modifier = itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().findFirst().orElse(null);
        return modifier != null ? (float)modifier.m_22218_() : 1.0f;
    }
}

