/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class RoyalSwordItem
extends SwordItem {
    public static final float HELD_ITEM_DAMAGE_CHANCE = 0.6f;
    public static final int HELD_ITEM_DAMAGE_AMOUNT = 6;
    public static float ARMED_BONUS_MULTIPLIER = 0.6f;
    public static float AGGRESSIVE_BONUS_MULTIPLIER = 0.6f;
    public static int DURABILITY_PENALTY = 3;
    public static final boolean ENABLE_PARTICLES = true;

    public RoyalSwordItem() {
        super(new Tier(){

            public int m_6609_() {
                return 1200;
            }

            public float m_6624_() {
                return 8.0f;
            }

            public float m_6631_() {
                return 4.0f;
            }

            public int m_6604_() {
                return 2;
            }

            public int m_6601_() {
                return 16;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_151265_();
            }
        }, 3, -2.6f, new Item.Properties());
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.BLOCK;
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player entity, InteractionHand hand) {
        ItemStack itemStack = entity.m_21120_(hand);
        if (!ModUtils.isEntityInBattleMode((Entity)entity)) {
            entity.m_6672_(hand);
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)entity.m_21120_(hand));
        }
        return new InteractionResultHolder(InteractionResult.CONSUME, (Object)entity.m_21120_(hand));
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null || !(sourceentity instanceof Player)) {
            return false;
        }
        boolean isFullyCharged = ((Player)sourceentity).m_36403_(0.5f) >= 1.0f;
        Level level = entity.m_9236_();
        if (isFullyCharged) {
            this.applyBonusDamage(sourceentity, entity, itemstack, level);
        }
        return retval;
    }

    private void applyBonusDamage(LivingEntity sourceentity, LivingEntity entity, ItemStack itemstack, Level level) {
        sourceentity.getCapability(AmountProvider.AMOUNT).ifPresent(amount -> {
            float baseDamage = amount.getDamage();
            float totalMultiplier = 1.0f;
            boolean isArmed = ModUtils.isEntityArmed(entity);
            boolean isAggressive = ModUtils.isMobAggressive(entity, (Player)sourceentity);
            if (isArmed) {
                totalMultiplier *= 1.0f + ARMED_BONUS_MULTIPLIER;
            }
            if (isAggressive) {
                totalMultiplier *= 1.0f + AGGRESSIVE_BONUS_MULTIPLIER;
            }
            float bonusDamage = baseDamage * (totalMultiplier - 1.0f);
            ModUtils.applyBonusDamage((LivingEntity)((Player)sourceentity), entity, itemstack, bonusDamage);
            if (sourceentity instanceof Player) {
                itemstack.m_41622_(DURABILITY_PENALTY, (LivingEntity)((Player)sourceentity), e -> e.m_21166_(EquipmentSlot.MAINHAND));
            }
            if (isArmed) {
                this.damageEnemyHeldItems(entity, level);
            }
            this.spawnParticlesAndSound(entity, level, isArmed, isAggressive);
        });
    }

    private void damageEnemyHeldItems(LivingEntity entity, Level level) {
        if (level.f_46441_.m_188501_() < 0.6f) {
            ItemStack mainHandItem = entity.m_21205_();
            ItemStack offHandItem = entity.m_21206_();
            if (ModUtils.isItemWeapon(mainHandItem)) {
                mainHandItem.m_41622_(6, entity, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            }
            if (ModUtils.isItemWeapon(offHandItem)) {
                offHandItem.m_41622_(6, entity, e -> e.m_21166_(EquipmentSlot.OFFHAND));
            }
        }
    }

    private void spawnParticlesAndSound(LivingEntity entity, Level level, boolean isArmed, boolean isAggressive) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (isArmed && isAggressive) {
                serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 0.9f);
            } else if (isArmed) {
                serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12316_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else if (isAggressive) {
                serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

