/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import net.jaams.jaams_weaponry.handler.mechanics.DisarmHandler;
import net.jaams.jaams_weaponry.handler.mechanics.PullTowardsHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RusticWhipItem
extends SwordItem {
    public static final float DISARM_CHANCE_NORMAL = 0.15f;
    public static final float DISARM_CHANCE_SNEAKING = 0.25f;
    public static final float CRITICAL_DISARM_MULTIPLIER = 1.5f;
    public static final int DURABILITY_COST_DISARM = 3;
    public static final float DISMOUNT_CHANCE_SNEAKING = 0.3f;
    public static final float DISMOUNT_CHANCE_NORMAL = 0.15f;
    public static final float CRITICAL_DISMOUNT_MULTIPLIER = 2.0f;
    public static final int DURABILITY_COST_DISMOUNT = 2;
    public static final float BASE_PULL_STRENGTH = 2.5f;
    public static final float MAX_PULL_DISTANCE = 6.0f;
    public static final double MAX_PULL_SPEED = 0.8;
    public static final float ATTACK_STRENGTH_PULL_MODIFIER = 0.6f;
    public static final double BASE_MOVEMENT_SPEED = 0.1;
    public static final float MAX_VERTICAL_PULL = 0.5f;
    public static final float VERTICAL_PULL_DAMPENING = 0.3f;
    public static final float PULL_DISTANCE_SCALING = 0.75f;
    public static final int DURABILITY_COST_PULL = 0;

    public RusticWhipItem() {
        super(new Tier(){

            public int m_6609_() {
                return 132;
            }

            public float m_6624_() {
                return 4.0f;
            }

            public float m_6631_() {
                return -0.0f;
            }

            public int m_6604_() {
                return 1;
            }

            public int m_6601_() {
                return 2;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42454_});
            }
        }, 0, -2.2f, new Item.Properties());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44977_ || enchantment == Enchantments.f_44983_ || enchantment == Enchantments.f_44980_ || enchantment == Enchantments.f_44982_ || enchantment == Enchantments.f_44978_ || enchantment == Enchantments.f_44979_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        Level level;
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        boolean isPlayer = sourceentity instanceof Player;
        float attackStrength = isPlayer ? ((Player)sourceentity).m_36403_(0.5f) : 1.0f;
        boolean isCritical = isPlayer && ModUtils.isCritical((Player)sourceentity, (Entity)entity, attackStrength);
        boolean isFullyCharged = attackStrength >= 1.0f;
        boolean isSneaking = sourceentity.m_6144_();
        ModUtils.playSound((Entity)entity, "jaams_weaponry:whip_hit");
        ModUtils.cancelDamage(entity, sourceentity);
        PullTowardsHandler.pullEnemyTowardsPlayer(entity, sourceentity, attackStrength, itemstack, 2.5f, 6.0f, 0.8, 0.6f, 0.1, 0.5f, 0.3f, 0.75f, 0);
        if (isFullyCharged) {
            float baseDisarmChance = isSneaking ? 0.25f : 0.15f;
            float disarmChance = isCritical ? baseDisarmChance * 1.5f : baseDisarmChance;
            this.handleDisarm(entity, sourceentity, itemstack, disarmChance);
            float baseDismountChance = isSneaking ? 0.3f : 0.15f;
            float dismountChance = isCritical ? baseDismountChance * 2.0f : baseDismountChance;
            this.handleDismount(entity, sourceentity, itemstack, dismountChance);
        }
        if ((level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity.m_5842_()) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_(), 4, 0.1, 0.1, 0.1, 0.0);
            }
        }
        return retval;
    }

    public void handleDisarm(LivingEntity entity, LivingEntity sourceentity, ItemStack itemstack, float disarmChance) {
        if (entity.m_9236_().f_46441_.m_188501_() < disarmChance) {
            boolean disarmed;
            boolean bl = disarmed = DisarmHandler.disarmSlot(entity, sourceentity, EquipmentSlot.MAINHAND) || DisarmHandler.disarmSlot(entity, sourceentity, EquipmentSlot.OFFHAND);
            if (disarmed) {
                itemstack.m_41622_(3, sourceentity, p -> p.m_21190_(sourceentity.m_7655_()));
            }
        }
    }

    public void handleDismount(LivingEntity entity, LivingEntity sourceentity, ItemStack itemstack, float dismountChance) {
        if (entity.m_9236_().f_46441_.m_188501_() < dismountChance && entity.m_20159_()) {
            entity.m_8127_();
            itemstack.m_41622_(2, sourceentity, p -> p.m_21190_(sourceentity.m_7655_()));
            Level level = entity.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

