/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import net.jaams.jaams_weaponry.handler.mechanics.BackstabHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.particles.MiniSweepParticleData;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class SharpStoneBladeItem
extends SwordItem {
    public static final float BREAK_CHANCE = 0.3f;
    public static final int ITEM_BREAK_PARTICLE_COUNT = 5;
    public static final float BACKSTAB_MULTIPLIER_NORMAL = 2.0f;
    public static final float BACKSTAB_MULTIPLIER_SNEAKING = 2.5f;
    public static final float BACKSTAB_MULTIPLIER_INVISIBLE = 3.0f;
    public static final float BACKSTAB_MULTIPLIER_SNEAKING_INVISIBLE = 3.5f;
    public static final float BACKSTAB_DURABILITY_PENALTY = 3.0f;
    public static final float RIGHT_CLICK_DURABILITY_MULTIPLIER = 2.0f;
    public static final float RIGHT_CLICK_FORWARD_IMPULSE = 0.8f;
    public static final double BACKSTAB_MAX_DISTANCE = 2.0;
    public static final double BACKSTAB_MAX_ANGLE = Math.toRadians(45.0);
    public static final float WEAKNESS_CHANCE = 0.1f;
    public static final int WEAKNESS_DURATION = 60;
    public static final int WEAKNESS_LEVEL = 1;
    public static final int RIGHT_CLICK_COOLDOWN = 40;
    public static final float DARKNESS_BONUS = 0.5f;
    public static final float MOVING_TARGET_PENALTY = 0.2f;
    public static final double GRACE_PERIOD_SECONDS = 0.2;
    public static final float RIGHT_CLICK_DAMAGE_BONUS = 5.0f;

    public SharpStoneBladeItem() {
        super(new Tier(){

            public int m_6609_() {
                return 80;
            }

            public float m_6624_() {
                return 4.0f;
            }

            public float m_6631_() {
                return -2.0f;
            }

            public int m_6604_() {
                return 1;
            }

            public int m_6601_() {
                return 5;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)JaamsWeaponryModItems.SHARP_STONE.get())});
            }
        }, 3, -1.6f, new Item.Properties());
    }

    public int m_8105_(ItemStack itemstack) {
        return 20;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SWORD_DIG);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != Enchantments.f_44983_ && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemstack) {
        ItemStack retval = itemstack.m_41777_();
        retval.m_41721_(itemstack.m_41773_() + 1);
        if (retval.m_41773_() >= retval.m_41776_()) {
            return ItemStack.f_41583_;
        }
        return retval;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player entity, InteractionHand hand) {
        ItemStack mainhandStack = entity.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offhandStack = entity.m_21120_(InteractionHand.OFF_HAND);
        if (mainhandStack.m_41720_() == JaamsWeaponryModItems.SHORT_STICK.get() || offhandStack.m_41720_() == JaamsWeaponryModItems.SHORT_STICK.get()) {
            InteractionResultHolder ar = super.m_7203_(world, entity, hand);
            entity.m_6672_(hand);
            return ar;
        }
        return InteractionResultHolder.m_19100_((Object)entity.m_21120_(hand));
    }

    public InteractionResult m_6880_(ItemStack itemstack, Player player, LivingEntity target, InteractionHand hand) {
        Level level = player.m_9236_();
        if (!level.f_46443_ && BackstabHandler.isBackstab((LivingEntity)player, target, 2.0, BACKSTAB_MAX_ANGLE)) {
            Player targetPlayer;
            if (target instanceof Player && (targetPlayer = (Player)target).m_7500_()) {
                return InteractionResult.PASS;
            }
            if (!player.m_36335_().m_41519_((Item)this)) {
                float baseDamage = this.calculateDamage(itemstack) + (float)(player.m_21133_(Attributes.f_22281_) / 2.0);
                BackstabHandler.performRightClickBackstab((LivingEntity)player, target, itemstack, level, baseDamage, 3.0f, 2.0f, 0.8f, 0.1f, 60, 1, 2.0f, 2.5f, 3.0f, 3.5f, 0.5f, 0.2f, 5.0f);
                player.m_36335_().m_41524_((Item)this, 40);
                player.m_6674_(hand);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean isFullyCharged;
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean bl = sourceentity instanceof Player ? ((Player)sourceentity).m_36403_(0.5f) >= 1.0f : (isFullyCharged = true);
        boolean isCritical = sourceentity instanceof Player ? ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f)) : sourceentity.m_9236_().f_46441_.m_188501_() < 0.05f;
        Level level = entity.m_9236_();
        if (isFullyCharged && BackstabHandler.isBackstab(sourceentity, entity, 2.0, BACKSTAB_MAX_ANGLE)) {
            float baseDamage = sourceentity instanceof Player ? this.calculateDamage(itemstack) + (float)(sourceentity.m_21133_(Attributes.f_22281_) / 2.0) : (float)sourceentity.m_21133_(Attributes.f_22281_);
            this.applyBackstabEffects(itemstack, entity, sourceentity, level, baseDamage);
        }
        if (sourceentity instanceof Player) {
            Player player = (Player)sourceentity;
            if (!player.m_150110_().f_35937_) {
                ModUtils.handleItemBreak(itemstack, (LivingEntity)player, 0.3f, 5, "jaams_weaponry:sharp_stone_hit");
            }
        }
        return retval;
    }

    public ItemStack m_5922_(ItemStack itemstack, Level level, LivingEntity entity) {
        if (!level.f_46443_) {
            this.processItemUsage(itemstack, level, entity, entity.m_7655_());
        }
        return itemstack;
    }

    public void m_5551_(ItemStack itemstack, Level level, LivingEntity entity, int durationUsed) {
        int remainingDuration;
        if (!level.f_46443_ && (remainingDuration = this.m_8105_(itemstack) - durationUsed) >= 10) {
            this.processItemUsage(itemstack, level, entity, entity.m_7655_());
        }
    }

    public void applyBackstabEffects(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity, Level level, float baseDamage) {
        BackstabHandler.performBackstab(sourceentity, entity, itemstack, level, 3.0f, 0.1f, 60, 1, 2.0f, 2.5f, 3.0f, 3.5f, 0.5f, 0.2f);
    }

    private void processItemUsage(ItemStack itemstack, Level level, LivingEntity entity, InteractionHand usedHand) {
        ItemStack otherHandStack = entity.m_21120_(usedHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        itemstack.m_41622_(3, entity, brokenItemStack -> brokenItemStack.m_21190_(usedHand));
        if (itemstack.m_41720_() == JaamsWeaponryModItems.SHARP_STONE_BLADE.get() && otherHandStack.m_41720_() == JaamsWeaponryModItems.SHORT_STICK.get()) {
            Player player;
            if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
                otherHandStack.m_41774_(1);
            }
            ItemStack stakeStack = new ItemStack((ItemLike)JaamsWeaponryModItems.STAKE.get());
            if (entity instanceof Player) {
                Player player2 = (Player)entity;
                ItemHandlerHelper.giveItemToPlayer((Player)player2, (ItemStack)stakeStack);
                player2.m_36335_().m_41524_(itemstack.m_41720_(), 25);
            }
            entity.m_21011_(usedHand, true);
            ServerLevel serverWorld = (ServerLevel)level;
            this.spawnParticlesAndSounds(itemstack, entity, serverWorld);
        }
    }

    private void spawnParticlesAndSounds(ItemStack itemstack, LivingEntity entity, ServerLevel serverWorld) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack particleStack = new ItemStack((ItemLike)JaamsWeaponryModItems.SHORT_STICK.get());
        ModUtils.spawnItemParticlesInFront((LivingEntity)player, particleStack, 6, 1.0f, false);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        ModUtils.spawnCustomParticlesInFront((LivingEntity)player, itemstack, new MiniSweepParticleData(r, g, b, 0.35f), r, g, b, 0.35f, 1.0f, 1, false);
        Vec3 lookDirection = player.m_20154_().m_82541_();
        double sweepX = player.m_20185_() + lookDirection.f_82479_ * 1.5;
        double sweepY = player.m_20186_() + (double)player.m_20192_() + lookDirection.f_82480_ * 0.5;
        double sweepZ = player.m_20189_() + lookDirection.f_82481_ * 1.5;
        if (player.m_5842_()) {
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123795_, sweepX, sweepY, sweepZ, 1, 0.2, 0.2, 0.2, 0.0);
        }
        serverWorld.m_6263_(null, sweepX, sweepY, sweepZ, SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, player.m_5842_() ? 0.8f : 1.0f);
        BlockPos pos = player.m_20183_();
        SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:dagger"));
        if (soundEvent != null) {
            serverWorld.m_5594_(null, pos, soundEvent, SoundSource.PLAYERS, 1.0f, player.m_5842_() ? 0.8f : 1.0f);
        }
    }

    public float calculateDamage(ItemStack itemStack) {
        AttributeModifier modifier = itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().findFirst().orElse(null);
        return modifier != null ? (float)modifier.m_22218_() : 1.0f;
    }
}

