/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import java.util.Comparator;
import java.util.List;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SmokeBombItem
extends Item {
    public static final float SMOKE_BOMB_PUSH_FORCE = 1.5f;
    public static final float SMOKE_BOMB_UPWARD_PUSH_FORCE = 0.8f;
    public static final int SMOKE_BOMB_PARTICLE_COUNT = 120;
    public static final float SMOKE_BOMB_PARTICLE_RANGE = 3.0f;
    public static final float SMOKE_BOMB_HIT_PROBABILITY = 0.2f;
    public static final float SMOKE_BOMB_SELF_BLIND_PROBABILITY = 0.1f;
    public static final float SMOKE_BOMB_ENEMY_BLIND_PROBABILITY = 0.5f;

    public SmokeBombItem() {
        super(new Item.Properties().m_41487_(64).m_41497_(Rarity.COMMON));
    }

    public int m_6473_() {
        return 0;
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.SPEAR;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = InteractionResultHolder.m_19096_((Object)entity.m_21120_(hand));
        entity.m_6672_(hand);
        return ar;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceEntity) {
        if (!sourceEntity.m_9236_().m_5776_() && sourceEntity.m_9236_().f_46441_.m_188501_() < 0.2f) {
            this.applySmokeBombEffects(itemstack, sourceEntity, sourceEntity.m_9236_());
        }
        return true;
    }

    public void m_5551_(ItemStack itemstack, Level level, LivingEntity sourceEntity, int time) {
        if (sourceEntity == null) {
            return;
        }
        if (!level.m_5776_()) {
            this.applySmokeBombEffects(itemstack, sourceEntity, level);
        }
    }

    private void applySmokeBombEffects(ItemStack itemstack, LivingEntity sourceEntity, Level level) {
        this.applyBlindnessEffects(sourceEntity, level);
        this.spawnParticlesAndSound(sourceEntity, level);
        this.applyPushAndCooldown(itemstack, sourceEntity);
    }

    private void applyBlindnessEffects(LivingEntity sourceEntity, Level level) {
        if (sourceEntity instanceof Player) {
            Player player = (Player)sourceEntity;
            if (level.f_46441_.m_188501_() < 0.1f) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 1, false, false, true));
            }
        }
        Vec3 center = sourceEntity.m_20182_();
        List<Entity> nearbyEntities = level.m_45976_(Entity.class, new AABB(center, center).m_82400_(2.0)).stream().sorted(Comparator.comparingDouble(ent -> ent.m_20238_(center))).toList();
        for (Entity nearbyEntity : nearbyEntities) {
            Monster monster;
            TamableAnimal tamable;
            if (nearbyEntity == sourceEntity || !(nearbyEntity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)nearbyEntity;
            boolean isTamedByEntity = nearbyEntity instanceof TamableAnimal && (tamable = (TamableAnimal)nearbyEntity).m_21830_(sourceEntity);
            if (isTamedByEntity) continue;
            if (nearbyEntity instanceof Player) {
                Player player = (Player)nearbyEntity;
                if (level.f_46441_.m_188501_() < 0.5f) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 1, false, false, true));
                    continue;
                }
            }
            if (!(livingEntity instanceof Monster) || (monster = (Monster)livingEntity).m_5448_() != sourceEntity) continue;
            monster.m_6710_(null);
        }
    }

    private void spawnParticlesAndSound(LivingEntity sourceEntity, Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SimpleParticleType primaryParticleType = sourceEntity.m_5842_() ? ParticleTypes.f_123795_ : ParticleTypes.f_123755_;
            int particleCount = sourceEntity.m_5842_() ? 240 : 120;
            double particleRange = sourceEntity.m_5842_() ? 4.5 : 3.0;
            SmokeBombItem.generateParticles(serverLevel, (Entity)sourceEntity, (ParticleOptions)primaryParticleType, particleCount, particleRange);
            if (!sourceEntity.m_5842_()) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, sourceEntity.m_20185_(), sourceEntity.m_20186_() + 0.1, sourceEntity.m_20189_(), 10, 0.5, 0.5, 0.5, 0.0);
            }
            if (sourceEntity.m_5842_()) {
                int smokeParticleCount = 60;
                SmokeBombItem.generateParticles(serverLevel, (Entity)sourceEntity, (ParticleOptions)ParticleTypes.f_123762_, smokeParticleCount, 3.0);
            }
            ModUtils.playSound((Entity)sourceEntity, "jaams_weaponry:smoke_bomb");
        }
    }

    private void applyPushAndCooldown(ItemStack itemstack, LivingEntity sourceEntity) {
        SmokeBombItem.applyDynamicPush((Entity)sourceEntity, 1.5f, 0.8f);
        if (sourceEntity instanceof Player) {
            Player player = (Player)sourceEntity;
            player.m_36335_().m_41524_(itemstack.m_41720_(), SmokeBombItem.calculateCooldown((Entity)sourceEntity));
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
        }
    }

    public static void applyDynamicPush(Entity sourceEntity, float pushForce, float upwardPushForce) {
        Vec3 lookDirection = sourceEntity.m_20154_().m_82541_();
        double pushX = -lookDirection.f_82479_ * (double)pushForce;
        double pushZ = -lookDirection.f_82481_ * (double)pushForce;
        double downThreshold = -0.8;
        double pushY = lookDirection.f_82480_ <= downThreshold ? (double)upwardPushForce : 0.0;
        Vec3 finalPush = new Vec3(pushX, pushY, pushZ);
        sourceEntity.m_20256_(finalPush);
        sourceEntity.f_19864_ = true;
    }

    private static void generateParticles(ServerLevel level, Entity sourceEntity, ParticleOptions particleType, int count, double range) {
        double playerX = sourceEntity.m_20185_();
        double playerY = sourceEntity.m_20186_() + (double)sourceEntity.m_20192_();
        double playerZ = sourceEntity.m_20189_();
        RandomSource random = level.f_46441_;
        for (int i = 0; i < count; ++i) {
            double xOffset = (random.m_188500_() - 0.5) * range;
            double yOffset = (random.m_188500_() - 0.5) * range;
            double zOffset = (random.m_188500_() - 0.5) * range;
            level.m_8767_(particleType, playerX + xOffset, playerY + yOffset, playerZ + zOffset, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static int calculateCooldown(Entity sourceEntity) {
        return sourceEntity.m_20142_() ? 20 : 40;
    }
}

