/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import java.util.ArrayList;
import java.util.List;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.entity.StakeProjectileEntity;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class StakeCrossbowItem
extends CrossbowItem {
    public static final float maxVelocity = 2.5f;
    public static final int loadTime = 20;
    public boolean startSoundPlayed = false;
    public boolean midLoadSoundPlayed = false;

    public StakeCrossbowItem() {
        super(new Item.Properties().m_41503_(126).m_41497_(Rarity.COMMON));
    }

    public int m_6473_() {
        return 10;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        if (((Boolean)JaamsWeaponryCommonConfiguration.STAKECROSSBOWALT.get()).booleanValue()) {
            return UseAnim.BOW;
        }
        return UseAnim.CROSSBOW;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44990_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (StakeCrossbowItem.m_40932_((ItemStack)itemstack)) {
            StakeCrossbowItem.executeShooting(level, (LivingEntity)player, hand, itemstack, 2.5f, 1.0f);
            StakeCrossbowItem.m_40884_((ItemStack)itemstack, (boolean)false);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (StakeCrossbowItem.hasStake(player)) {
            if (!StakeCrossbowItem.m_40932_((ItemStack)itemstack)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                player.m_6672_(hand);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int slot, boolean isSelected) {
        if (!world.f_46443_ && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (((Boolean)JaamsWeaponryCommonConfiguration.STAKECROSSBOWALT.get()).booleanValue()) {
                boolean isBeingUsed;
                boolean bl = isBeingUsed = livingEntity.m_21211_() == itemStack;
                if (isBeingUsed && livingEntity.m_21212_() <= this.m_8105_(itemStack) - 20) {
                    if (!StakeCrossbowItem.m_40932_((ItemStack)itemStack)) {
                        StakeCrossbowItem.m_40884_((ItemStack)itemStack, (boolean)true);
                        world.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11841_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        livingEntity.m_21011_(livingEntity.m_7655_(), true);
                    }
                } else if (!isBeingUsed && StakeCrossbowItem.m_40932_((ItemStack)itemStack)) {
                    StakeCrossbowItem.m_40884_((ItemStack)itemStack, (boolean)false);
                }
            }
        }
    }

    public ItemStack m_5922_(ItemStack itemStack, Level world, LivingEntity entity) {
        if (!world.f_46443_ && StakeCrossbowItem.m_40932_((ItemStack)itemStack) && ((Boolean)JaamsWeaponryCommonConfiguration.STAKECROSSBOWALT.get()).booleanValue()) {
            StakeCrossbowItem.m_40884_((ItemStack)itemStack, (boolean)false);
        }
        return super.m_5922_(itemStack, world, entity);
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity entity, int ticks) {
        if (!(entity instanceof Player)) {
            int i = this.m_8105_(itemStack) - ticks;
            float power = StakeCrossbowItem.getPowerForTime(i);
            if (power >= 1.0f && !StakeCrossbowItem.m_40932_((ItemStack)itemStack) && StakeCrossbowItem.m_40859_(entity, itemStack) && entity instanceof CrossbowAttackMob) {
                CrossbowAttackMob crossbowAttackMob = (CrossbowAttackMob)entity;
                StakeCrossbowItem.m_40884_((ItemStack)itemStack, (boolean)true);
            }
            return;
        }
        Player player = (Player)entity;
        if (!((Boolean)JaamsWeaponryCommonConfiguration.STAKECROSSBOWALT.get()).booleanValue()) {
            int i = this.m_8105_(itemStack) - ticks;
            float power = StakeCrossbowItem.getPowerForTime(i);
            if (power >= 1.0f && !StakeCrossbowItem.m_40932_((ItemStack)itemStack) && StakeCrossbowItem.m_40859_((LivingEntity)player, itemStack)) {
                StakeCrossbowItem.m_40884_((ItemStack)itemStack, (boolean)true);
                SoundSource source = SoundSource.PLAYERS;
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11841_, source, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
            }
            return;
        }
        boolean isCreative = player.m_150110_().f_35937_;
        boolean hasInfinity = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)itemStack) > 0;
        boolean hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)itemStack) > 0;
        ItemStack stakeStack = ItemStack.f_41583_;
        int stakeCount = 0;
        if (!isCreative) {
            for (ItemStack testStack : player.m_150109_().f_35974_) {
                if (testStack.m_41720_() != JaamsWeaponryModItems.STAKE.get()) continue;
                stakeCount += testStack.m_41613_();
                if (!stakeStack.m_41619_()) continue;
                stakeStack = testStack;
            }
        }
        int i = this.m_8105_(itemStack) - ticks;
        if ((i = ForgeEventFactory.onArrowLoose((ItemStack)itemStack, (Level)level, (Player)player, (int)i, (stakeCount > 0 || hasInfinity ? 1 : 0) != 0)) < 0) {
            return;
        }
        float power = StakeCrossbowItem.getPowerForTime(i);
        if (power < 0.1f) {
            return;
        }
        int requiredStakes = 1;
        if ((isCreative || hasInfinity || stakeCount >= requiredStakes) && !level.f_46443_) {
            int projectileCount = hasMultishot ? 3 : 1;
            float[] shotPitches = StakeCrossbowItem.generateShotPitches(level.m_213780_(), projectileCount);
            for (int j = 0; j < projectileCount; ++j) {
                int pierceLevel;
                int flameLevel;
                int punchLevel;
                ItemStack stakeItem = new ItemStack((ItemLike)JaamsWeaponryModItems.STAKE.get());
                StakeProjectileEntity projectile = new StakeProjectileEntity((EntityType<? extends StakeProjectileEntity>)((EntityType)JaamsWeaponryModEntities.STAKE_PROJECTILE.get()), (LivingEntity)player, level, stakeItem);
                projectile.m_5602_((Entity)player);
                projectile.m_6034_(player.m_20185_(), player.m_20188_() - 0.1, player.m_20189_());
                int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)itemStack);
                if (powerLevel > 0) {
                    float baseDamage = projectile.getPersistentData().m_128457_("BaseWeaponDamage");
                    projectile.setWeaponDamage(baseDamage + (float)powerLevel * 0.3f + 0.3f);
                }
                if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)itemStack)) > 0) {
                    projectile.setWeaponKnockback(projectile.getPersistentData().m_128457_("WeaponKnockbackStrength") + (float)punchLevel * 0.5f);
                }
                if ((flameLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)itemStack)) > 0) {
                    projectile.m_20254_(60);
                }
                if ((pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)itemStack)) > 0) {
                    projectile.setPiercingLevel(pierceLevel);
                }
                if (power == 1.0f) {
                    projectile.m_36762_(true);
                }
                if (hasMultishot) {
                    projectile.f_36705_ = j == 0 ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED;
                } else {
                    AbstractArrow.Pickup pickup = projectile.f_36705_ = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                }
                if (hasMultishot) {
                    float spreadAngle = 10.0f;
                    float rotation = j == 0 ? 0.0f : (j == 1 ? -spreadAngle : spreadAngle);
                    Vec3 upVector = player.m_20289_(1.0f);
                    Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis((double)(rotation * (float)Math.PI / 180.0f), upVector.f_82479_, upVector.f_82480_, upVector.f_82481_);
                    Vec3 viewVector = player.m_20252_(1.0f);
                    Vector3f rotatedVector = viewVector.m_252839_().rotate((Quaternionfc)rotationQuaternion);
                    projectile.m_6686_(rotatedVector.x(), rotatedVector.y(), rotatedVector.z(), power * 2.5f, 1.0f);
                } else {
                    Vec3 viewVector = player.m_20252_(1.0f);
                    projectile.m_6686_(viewVector.f_82479_, viewVector.f_82480_, viewVector.f_82481_, power * 2.5f, 1.0f);
                }
                level.m_7967_((Entity)projectile);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, shotPitches[j]);
            }
            if (!isCreative) {
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
            }
            if (!(isCreative || hasInfinity || stakeStack.m_41619_())) {
                stakeStack.m_41774_(requiredStakes);
                if (stakeStack.m_41619_()) {
                    player.m_150109_().m_36057_(stakeStack);
                }
            }
            if (StakeCrossbowItem.m_40932_((ItemStack)itemStack)) {
                StakeCrossbowItem.m_40884_((ItemStack)itemStack, (boolean)false);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    public static boolean m_40859_(LivingEntity shooter, ItemStack crossbowStack) {
        boolean isCreative = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
        boolean hasInfinity = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)crossbowStack) > 0;
        int requiredStakes = 1;
        ItemStack stakeStack = StakeCrossbowItem.findStake(shooter);
        if (stakeStack.m_41619_() && !isCreative && !hasInfinity) {
            return false;
        }
        ItemStack ammo = new ItemStack((ItemLike)JaamsWeaponryModItems.STAKE.get());
        if (!isCreative && !hasInfinity && shooter instanceof Player) {
            Player player = (Player)shooter;
            stakeStack.m_41774_(requiredStakes);
            if (stakeStack.m_41619_()) {
                player.m_150109_().m_36057_(stakeStack);
            }
        }
        StakeCrossbowItem.m_40928_(crossbowStack, ammo);
        return true;
    }

    private static ItemStack findStake(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (stack.m_41720_() != JaamsWeaponryModItems.STAKE.get()) continue;
                return stack;
            }
        } else {
            return new ItemStack((ItemLike)JaamsWeaponryModItems.STAKE.get());
        }
        return ItemStack.f_41583_;
    }

    private static boolean hasStake(Player player) {
        return !StakeCrossbowItem.findStake((LivingEntity)player).m_41619_() || player.m_150110_().f_35937_;
    }

    public static void m_40928_(ItemStack crossbowStack, ItemStack ammoStack) {
        CompoundTag compoundtag = crossbowStack.m_41784_();
        ListTag listtag = compoundtag.m_128425_("ChargedProjectiles", 9) ? compoundtag.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag ammoTag = new CompoundTag();
        ammoStack.m_41739_(ammoTag);
        listtag.add((Object)ammoTag);
        compoundtag.m_128365_("ChargedProjectiles", (Tag)listtag);
    }

    public static void executeShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack crossbowStack, float velocity, float inaccuracy) {
        List<ItemStack> projectiles = StakeCrossbowItem.m_40941_(crossbowStack);
        float[] pitches = StakeCrossbowItem.generateShotPitches(shooter.m_217043_());
        boolean hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)crossbowStack) > 0;
        int projectileCount = hasMultishot ? 3 : 1;
        ItemStack projectileStack = projectiles.isEmpty() ? new ItemStack((ItemLike)JaamsWeaponryModItems.STAKE.get()) : projectiles.get(0);
        boolean isCreative = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
        for (int i = 0; i < projectileCount; ++i) {
            if (projectileStack.m_41619_()) continue;
            float rotation = hasMultishot ? (i == 0 ? 0.0f : (i == 1 ? -10.0f : 10.0f)) : 0.0f;
            StakeCrossbowItem.fireProjectile(level, shooter, hand, crossbowStack, projectileStack, pitches[i], isCreative, velocity, inaccuracy, rotation);
        }
        StakeCrossbowItem.handleCrossbowShot(level, shooter, crossbowStack);
    }

    private static void fireProjectile(Level level, LivingEntity shooter, InteractionHand hand, ItemStack crossbowStack, ItemStack projectileStack, float soundPitch, boolean isCreative, float velocity, float inaccuracy, float rotation) {
        if (!level.f_46443_) {
            boolean hasMultishot;
            int pierceLevel;
            int punchLevel;
            ItemStack stakeItem = new ItemStack((ItemLike)JaamsWeaponryModItems.STAKE.get());
            StakeProjectileEntity projectile = new StakeProjectileEntity((EntityType<? extends StakeProjectileEntity>)((EntityType)JaamsWeaponryModEntities.STAKE_PROJECTILE.get()), shooter, level, stakeItem);
            projectile.m_5602_((Entity)shooter);
            projectile.m_6034_(shooter.m_20185_(), shooter.m_20188_() - 0.15, shooter.m_20189_());
            int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)crossbowStack);
            if (powerLevel > 0) {
                float baseDamage = projectile.getPersistentData().m_128457_("BaseWeaponDamage");
                projectile.setWeaponDamage(baseDamage + (float)powerLevel * 0.3f + 0.3f);
            }
            if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)crossbowStack)) > 0) {
                projectile.setWeaponKnockback(projectile.getPersistentData().m_128457_("WeaponKnockbackStrength") + (float)punchLevel * 0.5f);
            }
            if ((pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crossbowStack)) > 0) {
                projectile.setPiercingLevel(pierceLevel);
            }
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)crossbowStack) > 0) {
                projectile.m_20254_(60);
            }
            if (shooter instanceof Player) {
                projectile.m_36762_(true);
            }
            projectile.m_36740_(SoundEvents.f_11840_);
            projectile.m_36793_(true);
            boolean bl = hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)crossbowStack) > 0;
            projectile.f_36705_ = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : (hasMultishot ? (rotation == 0.0f ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED) : AbstractArrow.Pickup.ALLOWED);
            if (shooter instanceof CrossbowAttackMob) {
                CrossbowAttackMob crossbowAttackMob = (CrossbowAttackMob)shooter;
                crossbowAttackMob.m_5811_(crossbowAttackMob.m_5448_(), crossbowStack, (Projectile)projectile, rotation);
            } else {
                Vec3 upVector = shooter.m_20289_(1.0f);
                Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis((double)(rotation * (float)Math.PI / 180.0f), upVector.f_82479_, upVector.f_82480_, upVector.f_82481_);
                Vec3 viewVector = shooter.m_20252_(1.0f);
                Vector3f rotatedVector = viewVector.m_252839_().rotate((Quaternionfc)rotationQuaternion);
                projectile.m_6686_(rotatedVector.x(), rotatedVector.y(), rotatedVector.z(), velocity, inaccuracy);
            }
            crossbowStack.m_41622_(1, shooter, e -> e.m_21190_(hand));
            level.m_7967_((Entity)projectile);
            level.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, soundPitch);
        }
    }

    private static void handleCrossbowShot(Level level, LivingEntity shooter, ItemStack crossbowStack) {
        if (shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            if (!level.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverPlayer, crossbowStack);
            }
            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)crossbowStack.m_41720_()));
        }
        StakeCrossbowItem.m_40943_(crossbowStack);
    }

    private static float[] generateShotPitches(RandomSource random, int projectileCount) {
        float[] pitches = new float[Math.max(projectileCount, 1)];
        for (int i = 0; i < pitches.length; ++i) {
            boolean flag = random.m_188499_();
            pitches[i] = 1.0f / (random.m_188501_() * 0.5f + 1.8f) + (flag ? 0.63f : 0.43f);
        }
        return pitches;
    }

    private static float[] generateShotPitches(RandomSource random) {
        boolean flag = random.m_188499_();
        return new float[]{1.0f, StakeCrossbowItem.m_220025_(flag, random), StakeCrossbowItem.m_220025_(!flag, random)};
    }

    private static float m_220025_(boolean flag, RandomSource random) {
        float f = flag ? 0.63f : 0.43f;
        return 1.0f / (random.m_188501_() * 0.5f + 1.8f) + f;
    }

    private static List<ItemStack> m_40941_(ItemStack crossbowStack) {
        ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
        CompoundTag tag = crossbowStack.m_41783_();
        if (tag != null && tag.m_128425_("ChargedProjectiles", 9)) {
            ListTag listTag = tag.m_128437_("ChargedProjectiles", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                projectiles.add(ItemStack.m_41712_((CompoundTag)listTag.m_128728_(i)));
            }
        }
        return projectiles;
    }

    private static void m_40943_(ItemStack crossbowStack) {
        CompoundTag tag = crossbowStack.m_41783_();
        if (tag != null) {
            ListTag listTag = tag.m_128437_("ChargedProjectiles", 9);
            listTag.clear();
            tag.m_128365_("ChargedProjectiles", (Tag)listTag);
        }
    }

    public static float getPowerForTime(int useTime) {
        float f = (float)useTime / 20.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int m_8105_(ItemStack stack) {
        return StakeCrossbowItem.m_40939_(stack) + 3;
    }

    public static int m_40939_(ItemStack crossbowStack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)crossbowStack);
        return i == 0 ? 20 : 20 - StakeCrossbowItem.getChargeTimeReductionPerQuickChargeLevel() * i;
    }

    public static int getChargeTimeReductionPerQuickChargeLevel() {
        return 3;
    }

    public int m_6615_() {
        return 8;
    }
}

