/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;

public class StakeItem
extends Item {
    public static final float BONUS_DAMAGE_MULTIPLIER = 6.0f;
    public static final float BREAK_CHANCE = 0.3f;
    public static final float UNDEAD_BREAK_CHANCE = 1.0f;
    public static final int ITEM_BREAK_PARTICLE_COUNT = 5;

    public StakeItem() {
        super(new Item.Properties().m_41487_(16).m_41497_(Rarity.COMMON));
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.m_7167_(equipmentSlot));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Item modifier", 0.5, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Item modifier", -2.4, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.m_7167_(equipmentSlot);
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean isUndead;
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null || !entity.m_6084_() || !(sourceentity instanceof Player)) {
            return false;
        }
        Player player = (Player)sourceentity;
        boolean isCritical = ModUtils.isCritical(player, (Entity)entity, player.m_36403_(0.5f));
        boolean isFullyCharged = player.m_36403_(0.5f) >= 1.0f;
        Level level = entity.m_9236_();
        boolean bl = isUndead = entity.m_6336_() == MobType.f_21641_;
        if (isUndead && isFullyCharged) {
            float baseDamage = (float)player.m_21133_(Attributes.f_22281_);
            float bonusDamage = baseDamage * 6.0f;
            ModUtils.applyBonusDamage((LivingEntity)player, entity, itemstack, bonusDamage);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (!player.m_7500_()) {
            float breakChance = isUndead ? 1.0f : 0.3f;
            ModUtils.handleItemBreak(itemstack, (LivingEntity)player, breakChance, 5, "jaams_weaponry:stake_hit");
        }
        return retval;
    }
}

