/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item;

import net.jaams.jaams_weaponry.handler.mechanics.BreakingHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class WarPickItem
extends PickaxeItem {
    public static final int ARMOR_DAMAGE_AMOUNT = 6;
    public static final float BASE_ARMOR_DAMAGE_CHANCE = 0.8f;
    public static final float CRIT_ARMOR_DAMAGE_CHANCE = 0.95f;
    public static final int HELD_ITEM_DAMAGE_AMOUNT = 6;
    public static final float BASE_HELD_ITEM_DAMAGE_CHANCE = 0.6f;
    public static final float CRIT_HELD_ITEM_DAMAGE_CHANCE = 0.85f;
    public static final int DURABILITY_PENALTY = 3;
    public static final float BREAK_CHANCE = 0.3f;
    public static final int ITEM_BREAK_PARTICLE_COUNT = 6;

    public WarPickItem() {
        super(new Tier(){

            public int m_6609_() {
                return 151;
            }

            public float m_6624_() {
                return 4.0f;
            }

            public float m_6631_() {
                return 6.0f;
            }

            public int m_6604_() {
                return 1;
            }

            public int m_6601_() {
                return 2;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)JaamsWeaponryModItems.SHARP_STONE.get())});
            }
        }, 1, -2.5f, new Item.Properties());
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SWORD_DIG) || toolAction.equals(ToolActions.PICKAXE_DIG);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44978_ || enchantment == Enchantments.f_44979_ || enchantment == Enchantments.f_44977_ || enchantment == Enchantments.f_44981_ || enchantment == Enchantments.f_44982_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        Level level = entity.m_9236_();
        boolean isCritical = sourceentity instanceof Player && ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f));
        boolean isFullyCharged = sourceentity instanceof Player && ((Player)sourceentity).m_36403_(0.5f) >= 1.0f;
        ModUtils.playSound((Entity)entity, "jaams_weaponry:war_pick_hit");
        if (isFullyCharged) {
            float armorDamageChance = isCritical ? 0.95f : 0.8f;
            float heldItemDamageChance = isCritical ? 0.85f : 0.6f;
            boolean damageApplied = false;
            if (level.f_46441_.m_188501_() < armorDamageChance) {
                BreakingHandler.damageArmorPieces(entity, 6, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
                damageApplied = true;
            }
            if (level.f_46441_.m_188501_() < heldItemDamageChance) {
                BreakingHandler.damageHeldItem(entity, 6);
                damageApplied = true;
            }
            if (damageApplied && !level.f_46443_) {
                itemstack.m_41622_(3, sourceentity, e -> e.m_21166_(EquipmentSlot.MAINHAND));
                if (itemstack.m_41773_() < itemstack.m_41776_()) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.spawnItemParticles(serverLevel, itemstack, entity, level.f_46441_, 5);
                }
            }
        }
        if (sourceentity instanceof Player) {
            Player player = (Player)sourceentity;
            if (!player.m_150110_().f_35937_ && itemstack.m_41773_() >= itemstack.m_41776_() / 2 && level.f_46441_.m_188501_() < 0.3f) {
                BreakingHandler.damageArmorPieces(entity, 18, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
                BreakingHandler.damageHeldItem(entity, 18);
                ModUtils.handleItemBreak(itemstack, (LivingEntity)player, 1.0f, 6, "minecraft:item.shield.break");
                Item sharpStone = (Item)JaamsWeaponryModItems.SHARP_STONE.get();
                int dropAmount = 1 + level.f_46441_.m_188503_(2);
                ItemStack dropStack = new ItemStack((ItemLike)sharpStone, dropAmount);
                Vec3 dropPos = player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() / 2.0f), 0.0);
                ItemEntity dropEntity = new ItemEntity(level, dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, dropStack);
                dropEntity.m_32060_();
                level.m_7967_((Entity)dropEntity);
            }
        }
        return retval;
    }

    private void spawnItemParticles(ServerLevel serverLevel, ItemStack itemstack, LivingEntity entity, RandomSource random, int particleCount) {
        if (itemstack == null || itemstack.m_41619_()) {
            return;
        }
        for (int i = 0; i < particleCount; ++i) {
            double xOffset = entity.m_20185_() + (random.m_188500_() - 0.5) * (double)entity.m_20205_();
            double yOffset = entity.m_20186_() + (double)entity.m_20206_() * 0.5 + (random.m_188500_() - 0.5) * (double)entity.m_20206_() * 0.5;
            double zOffset = entity.m_20189_() + (random.m_188500_() - 0.5) * (double)entity.m_20205_();
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), xOffset, yOffset, zOffset, 1, 0.1, 0.1, 0.1, 0.05);
        }
    }
}

