/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.item.inventory;

import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ShineritePistolInventoryCapability
implements ICapabilitySerializable<CompoundTag> {
    private final LazyOptional<ItemStackHandler> inventory = LazyOptional.of(this::createItemHandler);

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        return capability == ForgeCapabilities.ITEM_HANDLER ? this.inventory.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.getItemHandler().serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.getItemHandler().deserializeNBT(nbt);
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(9){

            public int getSlotLimit(int slot) {
                return 24;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (ModList.get().isLoaded("jaams_shinerite")) {
                    return stack.m_41720_() != JaamsWeaponryModItems.SHINERITE_PISTOL.get();
                }
                return stack.m_41720_() != JaamsWeaponryModItems.GOLDEN_PISTOL.get();
            }

            public void setSize(int size) {
            }
        };
    }

    private ItemStackHandler getItemHandler() {
        return (ItemStackHandler)this.inventory.orElseThrow(() -> new RuntimeException("ItemStackHandler not present"));
    }
}

