/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class AddWeaponryItemsModifier
extends LootModifier {
    public static final Supplier<Codec<AddWeaponryItemsModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddWeaponryItemsModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, AddWeaponryItemsModifier::new)));
    public static final float BARTERING_CHANCE = 0.35f;
    public static final float DUNGEON_CHANCE = 0.05f;
    public static final float VILLAGE_HOUSE_CHANCE = 0.05f;
    public static final float WEAPONSMITH_CHANCE = 0.15f;

    public AddWeaponryItemsModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ItemStack stack;
        ResourceLocation lootTableId = context.getQueriedLootTableId();
        if (lootTableId == null) {
            return generatedLoot;
        }
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        RandomSource random = context.m_230907_();
        if (lootTableId.equals((Object)new ResourceLocation("minecraft", "gameplay/piglin_bartering")) && random.m_188501_() < 0.35f) {
            generatedLoot.clear();
            ItemStack stack2 = this.getPiglinBarteringItem(random);
            if (!stack2.m_41619_()) {
                generatedLoot.add((Object)stack2);
            }
        } else if (lootTableId.equals((Object)new ResourceLocation("minecraft", "chests/simple_dungeon")) && random.m_188501_() < 0.05f) {
            ItemStack stack3 = this.getSimpleDungeonItem(random);
            if (!stack3.m_41619_()) {
                generatedLoot.add((Object)stack3);
            }
        } else if (lootTableId.m_135815_().startsWith("chests/village/") && !lootTableId.equals((Object)new ResourceLocation("minecraft", "chests/village/village_weaponsmith")) && !lootTableId.equals((Object)new ResourceLocation("minecraft", "chests/village/village_witch")) && random.m_188501_() < 0.05f) {
            ItemStack stack4 = this.getVillageHouseItem(random);
            if (!stack4.m_41619_()) {
                generatedLoot.add((Object)stack4);
            }
        } else if (lootTableId.equals((Object)new ResourceLocation("minecraft", "chests/village/village_weaponsmith")) && random.m_188501_() < 0.15f && !(stack = this.getWeaponsmithItem(random)).m_41619_()) {
            generatedLoot.add((Object)stack);
        }
        return generatedLoot;
    }

    private ItemStack getPiglinBarteringItem(RandomSource random) {
        int roll = random.m_188503_(100);
        if (roll < 50) {
            return new ItemStack((ItemLike)JaamsWeaponryModItems.STAKE.get(), random.m_188503_(3) + 3);
        }
        return new ItemStack((ItemLike)JaamsWeaponryModItems.RAGERS_BOTTLE.get(), 1);
    }

    private ItemStack getSimpleDungeonItem(RandomSource random) {
        int roll = random.m_188503_(2);
        return roll == 0 ? new ItemStack((ItemLike)JaamsWeaponryModItems.ARCHERS_BOTTLE.get()) : new ItemStack((ItemLike)JaamsWeaponryModItems.WARRIORS_BOTTLE.get());
    }

    private ItemStack getVillageHouseItem(RandomSource random) {
        return new ItemStack((ItemLike)JaamsWeaponryModItems.BROOM.get());
    }

    private ItemStack getWeaponsmithItem(RandomSource random) {
        return new ItemStack((ItemLike)JaamsWeaponryModItems.FLINT_HAMMER.get());
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

