/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.mixins;

import net.jaams.jaams_weaponry.item.GreatCrossbowItem;
import net.jaams.jaams_weaponry.item.HuntersCrossbowItem;
import net.jaams.jaams_weaponry.item.RoyalCrossbowItem;
import net.jaams.jaams_weaponry.item.StakeCrossbowItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public class CrossbowItemMixin {
    @Inject(method={"getChargeDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private static void modifyChargeDuration(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (stack.m_41720_() instanceof GreatCrossbowItem) {
            cir.setReturnValue((Object)GreatCrossbowItem.m_40939_(stack));
        } else if (stack.m_41720_() instanceof HuntersCrossbowItem) {
            cir.setReturnValue((Object)HuntersCrossbowItem.m_40939_(stack));
        } else if (stack.m_41720_() instanceof RoyalCrossbowItem) {
            cir.setReturnValue((Object)RoyalCrossbowItem.m_40939_(stack));
        } else if (stack.m_41720_() instanceof StakeCrossbowItem) {
            cir.setReturnValue((Object)StakeCrossbowItem.m_40939_(stack));
        }
    }

    @Inject(method={"performShooting"}, at={@At(value="HEAD")}, cancellable=true)
    private static void modifyPerformShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, float velocity, float inaccuracy, CallbackInfo ci) {
        Item item = crossbow.m_41720_();
        if (item instanceof GreatCrossbowItem) {
            GreatCrossbowItem.executeShooting(level, shooter, hand, crossbow, velocity, inaccuracy);
            ci.cancel();
        } else if (item instanceof HuntersCrossbowItem) {
            HuntersCrossbowItem.executeShooting(level, shooter, hand, crossbow, velocity, inaccuracy);
            ci.cancel();
        } else if (item instanceof RoyalCrossbowItem) {
            RoyalCrossbowItem.executeShooting(level, shooter, hand, crossbow, velocity, inaccuracy);
            ci.cancel();
        } else if (item instanceof StakeCrossbowItem) {
            StakeCrossbowItem.executeShooting(level, shooter, hand, crossbow, velocity, inaccuracy);
            ci.cancel();
        }
    }
}

