/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryClientConfiguration;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.weapons.ButterflySwordItem;
import net.jaams.jaams_weaponry.weapons.GreatswordItem;
import net.jaams.jaams_weaponry.weapons.TwinbladeItem;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public abstract class GuiGraphicsMixin {
    private static final TagKey<Item> GUNS = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation("jaams_weaponry:guns"));
    private static final String NBT_HITS_BUTTERFLY = "ButterflyHits";
    private static final String NBT_HITS_TWINBLADE = "TwinbladeHits";
    private static final String NBT_HITS_GREATSWORD = "GreatswordHits";

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="TAIL")})
    public void renderItemDecorations(Font font, ItemStack itemStack, int x, int y, String customText, CallbackInfo ci) {
        int hits;
        int hits2;
        GuiGraphics guiGraphics;
        int hits3;
        CompoundTag nbt;
        ItemStack bulletStack;
        if (!((Boolean)JaamsWeaponryCommonConfiguration.AMMOFROMGUN.get()).booleanValue()) {
            return;
        }
        if (itemStack.m_204117_(GUNS) && ((Boolean)JaamsWeaponryClientConfiguration.SHOWGUNBAR.get()).booleanValue() && !(bulletStack = GuiGraphicsMixin.getBulletFromGun(itemStack)).m_41619_()) {
            GuiGraphics guiGraphics2 = (GuiGraphics)this;
            guiGraphics2.m_280168_().m_85836_();
            RenderSystem.disableDepthTest();
            this.renderGunBar(itemStack, x, y);
            RenderSystem.enableDepthTest();
            guiGraphics2.m_280168_().m_85849_();
        }
        if (itemStack.m_41720_() instanceof ButterflySwordItem && ((Boolean)JaamsWeaponryClientConfiguration.SHOWBUTTERFLYBAR.get()).booleanValue() && (nbt = itemStack.m_41783_()) != null && nbt.m_128441_(NBT_HITS_BUTTERFLY) && (hits3 = nbt.m_128451_(NBT_HITS_BUTTERFLY)) > 0) {
            guiGraphics = (GuiGraphics)this;
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.disableDepthTest();
            this.renderButterflyHitBar(itemStack, x, y);
            RenderSystem.enableDepthTest();
            guiGraphics.m_280168_().m_85849_();
        }
        if (itemStack.m_41720_() instanceof TwinbladeItem && ((Boolean)JaamsWeaponryClientConfiguration.SHOWTWINBLADEBAR.get()).booleanValue() && (nbt = itemStack.m_41783_()) != null && nbt.m_128441_(NBT_HITS_TWINBLADE) && (hits2 = nbt.m_128451_(NBT_HITS_TWINBLADE)) > 0) {
            guiGraphics = (GuiGraphics)this;
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.disableDepthTest();
            this.renderTwinbladeHitBar(itemStack, x, y);
            RenderSystem.enableDepthTest();
            guiGraphics.m_280168_().m_85849_();
        }
        if (itemStack.m_41720_() instanceof GreatswordItem && ((Boolean)JaamsWeaponryClientConfiguration.SHOWGREATSWORDBAR.get()).booleanValue() && (nbt = itemStack.m_41783_()) != null && nbt.m_128441_(NBT_HITS_GREATSWORD) && (hits = nbt.m_128451_(NBT_HITS_GREATSWORD)) > 0) {
            guiGraphics = (GuiGraphics)this;
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.disableDepthTest();
            this.renderGreatswordHitBar(itemStack, x, y);
            RenderSystem.enableDepthTest();
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private void renderGunBar(ItemStack itemStack, int x, int y) {
        int barWidth;
        int durability = itemStack.m_41776_() - itemStack.m_41773_();
        float durabilityPercentage = (float)durability / (float)itemStack.m_41776_();
        float gunBarPercentage = this.getCustomBarPercentage(itemStack);
        int gunBarWidth = (int)(gunBarPercentage * (float)(barWidth = 13));
        if (gunBarWidth == 0 && gunBarPercentage > 0.0f) {
            gunBarWidth = 1;
        }
        int barHeight = 2;
        int barX = x + (Integer)JaamsWeaponryClientConfiguration.GUNBARX.get();
        int barY = y + (Integer)JaamsWeaponryClientConfiguration.GUNBARY.get();
        int gunBarColor = (Boolean)JaamsWeaponryClientConfiguration.GUNDEFAULTCOLOR.get() != false ? -26368 : this.getBarColorByBulletType(GuiGraphicsMixin.getBulletFromGun(itemStack));
        GuiGraphics guiGraphics = (GuiGraphics)this;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        guiGraphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -16777216);
        guiGraphics.m_280509_(barX, barY, barX + gunBarWidth, barY + barHeight - 1, gunBarColor);
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderButterflyHitBar(ItemStack itemStack, int x, int y) {
        int barWidth;
        CompoundTag nbt = itemStack.m_41783_();
        int hits = nbt != null ? nbt.m_128451_(NBT_HITS_BUTTERFLY) : 0;
        float hitPercentage = (float)hits / 3.0f;
        int customBarWidth = (int)(hitPercentage * (float)(barWidth = 13));
        if (customBarWidth == 0 && hitPercentage > 0.0f) {
            customBarWidth = 1;
        }
        int barHeight = 2;
        int barX = x + (Integer)JaamsWeaponryClientConfiguration.WEAPONBARX.get();
        int barY = y + (Integer)JaamsWeaponryClientConfiguration.WEAPONBARY.get();
        int customBarColor = -1;
        GuiGraphics guiGraphics = (GuiGraphics)this;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        guiGraphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -16777216);
        guiGraphics.m_280509_(barX, barY, barX + customBarWidth, barY + barHeight - 1, customBarColor);
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderTwinbladeHitBar(ItemStack itemStack, int x, int y) {
        int barWidth;
        CompoundTag nbt = itemStack.m_41783_();
        int hits = nbt != null ? nbt.m_128451_(NBT_HITS_TWINBLADE) : 0;
        float hitPercentage = (float)hits / 2.0f;
        int customBarWidth = (int)(hitPercentage * (float)(barWidth = 13));
        if (customBarWidth == 0 && hitPercentage > 0.0f) {
            customBarWidth = 1;
        }
        int barHeight = 2;
        int barX = x + (Integer)JaamsWeaponryClientConfiguration.WEAPONBARX.get();
        int barY = y + (Integer)JaamsWeaponryClientConfiguration.WEAPONBARY.get();
        int customBarColor = -1;
        GuiGraphics guiGraphics = (GuiGraphics)this;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        guiGraphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -16777216);
        guiGraphics.m_280509_(barX, barY, barX + customBarWidth, barY + barHeight - 1, customBarColor);
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderGreatswordHitBar(ItemStack itemStack, int x, int y) {
        int barWidth;
        CompoundTag nbt = itemStack.m_41783_();
        int hits = nbt != null ? nbt.m_128451_(NBT_HITS_GREATSWORD) : 0;
        float hitPercentage = (float)hits / 3.0f;
        int customBarWidth = (int)(hitPercentage * (float)(barWidth = 13));
        if (customBarWidth == 0 && hitPercentage > 0.0f) {
            customBarWidth = 1;
        }
        int barHeight = 2;
        int barX = x + (Integer)JaamsWeaponryClientConfiguration.WEAPONBARX.get();
        int barY = y + (Integer)JaamsWeaponryClientConfiguration.WEAPONBARY.get();
        int customBarColor = -1;
        GuiGraphics guiGraphics = (GuiGraphics)this;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        guiGraphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -16777216);
        guiGraphics.m_280509_(barX, barY, barX + customBarWidth, barY + barHeight - 1, customBarColor);
        guiGraphics.m_280168_().m_85849_();
    }

    private int getBarColorByBulletType(ItemStack bulletStack) {
        if (bulletStack.m_150930_((Item)JaamsWeaponryModItems.BULLET.get())) {
            return -10496;
        }
        if (bulletStack.m_150930_((Item)JaamsWeaponryModItems.FIRE_BULLET.get())) {
            return -47872;
        }
        if (bulletStack.m_150930_((Item)JaamsWeaponryModItems.HEAVY_BULLET.get())) {
            return -2894893;
        }
        if (bulletStack.m_150930_((Item)JaamsWeaponryModItems.GLOWING_BULLET.get())) {
            return -1146130;
        }
        if (bulletStack.m_150930_((Item)JaamsWeaponryModItems.ECHO_BULLET.get())) {
            return -16741493;
        }
        if (bulletStack.m_150930_((Item)JaamsWeaponryModItems.SHARP_BULLET.get())) {
            return -16711681;
        }
        if (bulletStack.m_150930_((Item)JaamsWeaponryModItems.SHOTSHELL.get())) {
            return -10496;
        }
        if (bulletStack.m_150930_((Item)JaamsWeaponryModItems.FIRE_SHOTSHELL.get())) {
            return -47872;
        }
        if (bulletStack.m_150930_((Item)JaamsWeaponryModItems.HEAVY_SHOTSHELL.get())) {
            return -2894893;
        }
        if (bulletStack.m_150930_((Item)JaamsWeaponryModItems.GLOWING_SHOTSHELL.get())) {
            return -1146130;
        }
        if (bulletStack.m_150930_((Item)JaamsWeaponryModItems.ECHO_SHOTSHELL.get())) {
            return -16741493;
        }
        if (bulletStack.m_150930_((Item)JaamsWeaponryModItems.SHARP_SHOTSHELL.get())) {
            return -16711681;
        }
        return -26368;
    }

    private float getCustomBarPercentage(ItemStack itemStack) {
        ItemStack bulletStack = GuiGraphicsMixin.getBulletFromGun(itemStack);
        int maxBullets = this.getMaxBullets(itemStack);
        return (float)bulletStack.m_41613_() / (float)maxBullets;
    }

    private int getMaxBullets(ItemStack itemStack) {
        return itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(capability -> capability.getSlotLimit(1)).orElse(1);
    }

    private static ItemStack getBulletFromGun(ItemStack gunStack) {
        return gunStack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(capability -> {
            ItemStack bulletItem = capability.getStackInSlot(1);
            if (GuiGraphicsMixin.isValidBullet(bulletItem)) {
                return bulletItem;
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
    }

    private static boolean isValidBullet(ItemStack bulletItem) {
        return !bulletItem.m_41619_();
    }
}

