/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jaams.jaams_weaponry.handler.events.BlockingHandler;
import net.jaams.jaams_weaponry.item.BokkenItem;
import net.jaams.jaams_weaponry.item.FlatBowItem;
import net.jaams.jaams_weaponry.item.GauntletItem;
import net.jaams.jaams_weaponry.item.KunaiItem;
import net.jaams.jaams_weaponry.item.NunchakuItem;
import net.jaams.jaams_weaponry.item.ProngedKunaiItem;
import net.jaams.jaams_weaponry.item.RoyalRapierItem;
import net.jaams.jaams_weaponry.item.RoyalSpearItem;
import net.jaams.jaams_weaponry.item.RoyalSwordItem;
import net.jaams.jaams_weaponry.item.SharpStoneBladeItem;
import net.jaams.jaams_weaponry.item.SharpStoneItem;
import net.jaams.jaams_weaponry.item.WarPickItem;
import net.jaams.jaams_weaponry.util.ModTags;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.jaams.jaams_weaponry.weapons.BroomBaseItem;
import net.jaams.jaams_weaponry.weapons.KatanaItem;
import net.jaams.jaams_weaponry.weapons.KatarItem;
import net.jaams.jaams_weaponry.weapons.SlingshotItem;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandRenderer.class})
public abstract class ItemInHandRendererMixin {
    private static final Set<String> TRIDENT_FIX_SET = new HashSet<String>(List.of("jaams_weaponry:dynamite", "jaams_weaponry:smoke_bomb", "jaams_weaponry:shuriken", "jaams_weaponry:giant_shuriken", "#jaams_weaponry:brooms", "jaams_weaponry:sharp_stone"));
    private static final Set<String> GREATSWORD_FIX_SET = new HashSet<String>(List.of("#jaams_weaponry:busters", "#jaams_weaponry:greathammers", "jaams_ac:tremorzilla_buster_sword", "jaams_weaponry:war_pick"));

    @Shadow
    private void m_269530_(LivingEntity entity, ItemStack itemStack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
    }

    @Inject(method={"renderItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderItem(LivingEntity entity, ItemStack itemStack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, CallbackInfo ci) {
        int direction;
        HumanoidArm arm;
        if (entity == null || itemStack == null || itemStack.m_41619_() || transformType == null || poseStack == null || bufferSource == null) {
            return;
        }
        Item item = itemStack.m_41720_();
        if (item == null) {
            return;
        }
        boolean isMainHand = !leftHand;
        boolean isUsingItem = entity.m_6117_() && itemStack.equals(entity.m_21211_());
        ItemStack mainHandItem = entity.m_21205_();
        ItemStack offHandItem = entity.m_21206_();
        boolean isInHand = mainHandItem != null && mainHandItem.equals(itemStack) || offHandItem != null && offHandItem.equals(itemStack);
        boolean isItemInHand = mainHandItem != null && mainHandItem.m_41720_() == item || offHandItem != null && offHandItem.m_41720_() == item;
        HumanoidArm mainArm = entity.m_5737_();
        Object object = isMainHand ? mainArm : (arm = mainArm != null ? mainArm.m_20828_() : null);
        if (arm == null) {
            return;
        }
        int horizontal = arm == HumanoidArm.RIGHT ? 1 : -1;
        int n = direction = transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND ? 1 : -1;
        if (transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            this.applyFirstPersonTransformations(entity, itemStack, item, transformType, isMainHand, isUsingItem, isInHand, horizontal, direction, poseStack);
        } else if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            this.applyThirdPersonTransformations(entity, itemStack, item, transformType, isMainHand, isUsingItem, isInHand, isItemInHand, horizontal, direction, poseStack);
        }
    }

    private void applyCustomItemTransformations(LivingEntity entity, ItemStack itemStack, Item item, boolean isInHand, PoseStack poseStack, ItemDisplayContext transformType) {
        String animation;
        if (!isInHand || entity == null || itemStack == null || item == null || poseStack == null || transformType == null) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            v0 = ModUtils.getPlayerAnimation(player);
        } else {
            v0 = animation = "";
        }
        if (item instanceof KatanaItem && "katana".equals(animation)) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-45.0f));
        }
    }

    private void applyFirstPersonTransformations(LivingEntity entity, ItemStack itemStack, Item item, ItemDisplayContext transformType, boolean isMainHand, boolean isUsingItem, boolean isInHand, int horizontal, int direction, PoseStack poseStack) {
        if (entity == null || itemStack == null || item == null || transformType == null || poseStack == null) {
            return;
        }
        this.applyFirstPersonItemUseTransformations(entity, itemStack, item, transformType, isUsingItem, horizontal, direction, poseStack);
        this.applyCustomItemTransformations(entity, itemStack, item, isInHand, poseStack, transformType);
        if (isInHand && item instanceof NunchakuItem) {
            poseStack.m_85837_(0.0, 0.05, -0.1);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
            poseStack.m_85841_(0.95f, 0.95f, 0.95f);
        } else if (isInHand && item instanceof BokkenItem) {
            poseStack.m_85837_(0.0, 0.1, 0.0);
        }
    }

    private void applyThirdPersonTransformations(LivingEntity entity, ItemStack itemStack, Item item, ItemDisplayContext transformType, boolean isMainHand, boolean isUsingItem, boolean isInHand, boolean isItemInHand, int horizontal, int direction, PoseStack poseStack) {
        if (entity == null || itemStack == null || item == null || transformType == null || poseStack == null) {
            return;
        }
        this.applyThirdPersonItemUseTransformations(entity, itemStack, item, transformType, isUsingItem, horizontal, direction, poseStack);
        this.applyCustomItemTransformations(entity, itemStack, item, isInHand, poseStack, transformType);
        if (isItemInHand && item instanceof BroomBaseItem) {
            ItemStack useItem = entity.m_21211_();
            if (!isUsingItem || useItem == null || !(useItem.m_41720_() instanceof BroomBaseItem)) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-25.0f * (float)direction));
                poseStack.m_85837_(0.03 * (double)direction, -0.01, -0.01);
            }
        } else if (isInHand && itemStack.m_204117_(ModTags.KATANAS)) {
            CompoundTag tag = itemStack.m_41784_();
            if (tag != null && "inosuke".equalsIgnoreCase(tag.m_128461_("WeaponSkin"))) {
                poseStack.m_85837_(0.0, -0.01, -0.016);
            } else {
                poseStack.m_85837_(0.0, 0.01, -0.034);
            }
        } else if (isInHand && itemStack.m_41720_() instanceof RoyalRapierItem && !ModUtils.isEntityInBattleMode((Entity)entity)) {
            String animation;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                v0 = ModUtils.getPlayerAnimation(player);
            } else {
                v0 = animation = "";
            }
            if ("rapier".equals(animation)) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-80.0f));
                poseStack.m_85837_(0.0, 0.0, -0.2);
            }
        } else if (isItemInHand && item instanceof NunchakuItem) {
            poseStack.m_85837_(0.0, 0.01, -0.025);
        } else if (isItemInHand && item instanceof RoyalSpearItem) {
            poseStack.m_85837_(0.0, -0.067, 0.009);
        } else if (isItemInHand && item instanceof RoyalSwordItem) {
            poseStack.m_85837_(0.0, -0.08, 0.02);
        } else if (isItemInHand && item instanceof WarPickItem) {
            poseStack.m_85837_(0.0, 0.102, 0.009);
        } else if (isInHand && itemStack.m_204117_(ModTags.SPEARS)) {
            poseStack.m_85837_(0.0, -0.23, 0.026);
        } else if (isInHand && itemStack.m_204117_(ModTags.TWINBLADES)) {
            poseStack.m_85837_(0.0, -0.33, 0.02);
        } else if (isInHand && itemStack.m_204117_(ModTags.SCYTHES)) {
            poseStack.m_85837_(0.0, -0.183, 0.057);
        } else if (isInHand && itemStack.m_204117_(ModTags.GREATSWORDS)) {
            poseStack.m_85837_(0.0, 0.03, -0.04);
        } else if (isInHand && itemStack.m_204117_(ModTags.BROADSWORDS)) {
            poseStack.m_85837_(0.0, 0.045, -0.04);
        } else if (isInHand && itemStack.m_204117_(ModTags.BATTLEAXES)) {
            poseStack.m_85837_(0.0, 0.05, 0.015);
        } else if (isInHand && itemStack.m_204117_(ModTags.KATARS)) {
            poseStack.m_85837_(0.0, -0.18, 0.16);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-80.0f));
        } else if (isInHand && itemStack.m_204117_(ModTags.REVERSEDAGGERS)) {
            poseStack.m_85837_(0.0, -0.66, 0.1);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(5.0f));
        } else if (isInHand && itemStack.m_204117_(ModTags.KNUCKLES)) {
            poseStack.m_85837_(0.0, -0.23, 0.24);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-80.0f));
        } else if (isInHand && itemStack.m_204117_(ModTags.CLAWS)) {
            poseStack.m_85837_(0.0, -0.26, 0.22);
            poseStack.m_85841_(1.2f, 1.2f, 1.0f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-80.0f));
        } else if (isInHand && itemStack.m_204117_(ModTags.RINGS)) {
            poseStack.m_85837_(0.0, -0.2, 0.08);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-80.0f));
        } else if (isInHand && itemStack.m_204117_(ModTags.SICKLES)) {
            poseStack.m_85837_(0.0, -0.03, 0.045);
        } else if (isInHand && itemStack.m_204117_(ModTags.KAMAS)) {
            poseStack.m_85837_(0.0, -0.118, -0.018);
        } else if (isItemInHand && item instanceof KunaiItem) {
            poseStack.m_85837_(0.0, -0.02, 0.04);
        } else if (isItemInHand && item instanceof ProngedKunaiItem) {
            poseStack.m_85837_(0.0, -0.03, 0.04);
        } else if (isItemInHand && item instanceof SharpStoneBladeItem) {
            poseStack.m_85837_(0.0, -0.02, 0.0);
        }
        if (entity.m_6117_() && itemStack == entity.m_21211_()) {
            if (item instanceof KunaiItem) {
                poseStack.m_85837_(0.0, 0.1, 0.0);
            } else if (item instanceof ProngedKunaiItem) {
                poseStack.m_85837_(0.0, 0.2, 0.0);
            }
        }
        if (ModList.get() != null && ModList.get().isLoaded("epicfight") && (ModUtils.isEntityInBattleMode((Entity)entity) || ModUtils.hasEpicFightAttribute(entity))) {
            this.applyEpicFightTransformations(entity, itemStack, item, isInHand, isItemInHand, isUsingItem, poseStack);
        }
    }

    private void applyFirstPersonItemUseTransformations(LivingEntity entity, ItemStack itemStack, Item item, ItemDisplayContext transformType, boolean isUsingItem, int horizontal, int direction, PoseStack poseStack) {
        if (!isUsingItem || entity == null || itemStack == null || item == null || transformType == null || poseStack == null) {
            return;
        }
        if (itemStack.m_41780_() == UseAnim.BLOCK && !BlockingHandler.isBannedItem(item) && BlockingHandler.isBlockingWeapon(itemStack)) {
            float yTranslation = itemStack.m_41720_() instanceof GauntletItem || itemStack.m_204117_(ModTags.SWORDS) ? 0.05f : 0.25f;
            poseStack.m_252880_((float)horizontal * -0.00142136f, yTranslation, 0.14142136f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-88.25f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)horizontal * 13.365f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)horizontal * 88.05f));
        } else if (item instanceof SlingshotItem) {
            poseStack.m_85837_(0.0, 0.0, -0.1);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f * (float)horizontal));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(60.0f * (float)horizontal));
        } else if (item instanceof FlatBowItem) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(15.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-12.0f * (float)direction));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(98.0f * (float)direction));
        } else if (item instanceof BroomBaseItem) {
            poseStack.m_85837_(0.0, -0.2, -0.3);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(20.0f));
        } else if (item instanceof SharpStoneItem) {
            poseStack.m_85837_(0.0, 0.2, -0.2);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(135.0f));
        } else if (itemStack.m_204117_(ModTags.SPEARFIX)) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-30.0f));
        }
    }

    private void applyThirdPersonItemUseTransformations(LivingEntity entity, ItemStack itemStack, Item item, ItemDisplayContext transformType, boolean isUsingItem, int horizontal, int direction, PoseStack poseStack) {
        if (!isUsingItem || entity == null || itemStack == null || item == null || transformType == null || poseStack == null) {
            return;
        }
        if (itemStack.m_41780_() == UseAnim.BLOCK && !BlockingHandler.isBannedItem(item) && BlockingHandler.isBlockingWeapon(itemStack) && !(item instanceof GauntletItem) && !ModUtils.isEntityInBattleMode((Entity)entity)) {
            poseStack.m_252880_((float)horizontal * -0.09f, 0.0f, 0.05f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(5.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)horizontal * 45.0f));
        } else if (item instanceof FlatBowItem) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-2.0f * (float)direction));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(80.0f * (float)direction));
            poseStack.m_85837_(0.0, 0.05, 0.0);
        } else if (item instanceof SlingshotItem) {
            poseStack.m_85837_(0.08 * (double)direction, 0.0, 0.06);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-80.0f * (float)horizontal));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f * (float)horizontal));
        } else if (item instanceof KunaiItem) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            poseStack.m_85837_(0.0, 0.11, 0.0);
        } else if (itemStack.m_204117_(ModTags.SPEARFIX)) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }

    private void applyEpicFightTransformations(LivingEntity entity, ItemStack itemStack, Item item, boolean isInHand, boolean isItemInHand, boolean isUsingItem, PoseStack poseStack) {
        if (entity == null || itemStack == null || item == null || poseStack == null) {
            return;
        }
        ResourceLocation itemKey = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        if (itemKey == null) {
            return;
        }
        if (isUsingItem && item instanceof FlatBowItem) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-5.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-15.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(5.0f));
            poseStack.m_85837_(0.0, 0.0, -0.05);
        } else if (isItemInHand && item instanceof GauntletItem) {
            poseStack.m_85841_(1.05f, 1.05f, 1.05f);
            poseStack.m_85837_(0.0, 0.01, -0.08);
        } else if (isInHand && itemStack.m_204117_(ModTags.SCYTHES)) {
            poseStack.m_85837_(0.0, 0.15, -0.07);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(17.0f));
        } else if (isItemInHand && item instanceof WarPickItem) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(17.0f));
        } else if (isItemInHand && item instanceof KatarItem) {
            poseStack.m_85837_(0.0, 0.05, 0.0);
        } else if (isInHand && itemStack.m_204117_(ModTags.HOOKSWORDS)) {
            poseStack.m_85837_(0.0, 0.07, -0.07);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(17.0f));
        } else if (isInHand && itemStack.m_204117_(ModTags.GREATSWORDS)) {
            poseStack.m_85837_(0.0, 0.07, 0.02);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(15.0f));
        } else if (isItemInHand && item instanceof RoyalSwordItem) {
            poseStack.m_85837_(0.0, 0.07, 0.02);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(15.0f));
        } else if (isInHand && itemStack.m_204117_(ModTags.LONGSWORDS)) {
            poseStack.m_85837_(0.0, 0.02, -0.01);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(15.0f));
        } else if (isInHand && itemStack.m_204117_(ModTags.ZWEIHANDERS)) {
            poseStack.m_85837_(0.0, 0.02, -0.01);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(15.0f));
        } else if (isItemInHand && (item instanceof KunaiItem || item instanceof ProngedKunaiItem) && !isUsingItem) {
            poseStack.m_85837_(0.0, -0.44, 0.0);
        } else if (isInHand && ModUtils.matchesList(TRIDENT_FIX_SET, itemKey, item, true) && !isUsingItem) {
            poseStack.m_85837_(0.0, -0.34, 0.0);
        } else if (isInHand && ModUtils.matchesList(GREATSWORD_FIX_SET, itemKey, item, true)) {
            poseStack.m_85837_(0.0, 0.0, -0.14);
        }
    }
}

