/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryClientConfiguration;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    private static final TagKey<Item> GUNS = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation("jaams_weaponry:guns"));

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void render(ItemStack itemStack, ItemDisplayContext context, boolean leftHanded, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, BakedModel model, CallbackInfo ci) {
        if (itemStack.m_204117_(GUNS) && context == ItemDisplayContext.GUI) {
            if (!((Boolean)JaamsWeaponryClientConfiguration.GUIBULLET.get()).booleanValue() || !((Boolean)JaamsWeaponryCommonConfiguration.AMMOFROMGUN.get()).booleanValue()) {
                return;
            }
            ItemStack bulletStack = ItemRendererMixin.getBulletFromGun(itemStack);
            if (!bulletStack.m_41619_()) {
                poseStack.m_85836_();
                double translateX = (Double)JaamsWeaponryClientConfiguration.GUIBULLETX.get();
                double translateY = (Double)JaamsWeaponryClientConfiguration.GUIBULLETY.get();
                double scale = (Double)JaamsWeaponryClientConfiguration.GUIBULLETSCALE.get();
                poseStack.m_85837_(translateX, translateY, 0.1);
                poseStack.m_85841_((float)scale, (float)scale, (float)scale);
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                itemRenderer.m_269128_(bulletStack, ItemDisplayContext.GUI, light, overlay, poseStack, bufferSource, (Level)Minecraft.m_91087_().f_91073_, 0);
                poseStack.m_85849_();
            }
        }
    }

    private static ItemStack getBulletFromGun(ItemStack gunStack) {
        return gunStack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(capability -> {
            ItemStack bulletItem = capability.getStackInSlot(1);
            if (ItemRendererMixin.isValidBullet(bulletItem)) {
                return bulletItem;
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
    }

    private static boolean isValidBullet(ItemStack bulletItem) {
        return !bulletItem.m_41619_();
    }
}

