/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.mixins;

import net.jaams.jaams_weaponry.enchantment.OverdriveEnchantment;
import net.jaams.jaams_weaponry.entity.AxeProjectileEntity;
import net.jaams.jaams_weaponry.handler.mechanics.BackstabHandler;
import net.jaams.jaams_weaponry.handler.mechanics.BreakingHandler;
import net.jaams.jaams_weaponry.handler.mechanics.SmashAttackHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEnchantments;
import net.jaams.jaams_weaponry.util.ModTags;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    private static final int ARMOR_DAMAGE_AMOUNT = 6;
    private static final float BASE_ARMOR_DAMAGE_CHANCE = 0.5f;
    private static final float CRIT_ARMOR_DAMAGE_CHANCE = 0.75f;
    private static final int DURABILITY_PENALTY = 1;
    private static final int PARTICLE_COUNT = 5;
    private static final float MAX_DRAW_DURATION = 20.0f;
    private static final float MIN_PROJECTILE_SPEED = 0.5f;
    private static final float MAX_PROJECTILE_SPEED = 1.0f;
    private static final float DAMAGE_PER_BLOCK = 0.4f;
    private static final float MAX_BONUS_DAMAGE = 30.0f;
    private static final float RESIDUAL_DAMAGE_BASE = 0.8f;
    private static final float RESIDUAL_DAMAGE_PER_BLOCK = 0.15f;
    private static final float MAX_RESIDUAL_DAMAGE = 15.0f;
    private static final float SMASH_RADIUS = 0.5f;
    private static final float MIN_KNOCKBACK_STRENGTH = 0.08f;
    private static final float MAX_KNOCKBACK_STRENGTH = 0.15f;
    private static final float KNOCKBACK_SCALING_FACTOR = 0.008f;
    private static final float MIN_FALL_DISTANCE = 2.0f;
    private static final float MAX_EFFECTIVE_FALL_DISTANCE = 80.0f;
    private static final float SHAKE_INTENSITY = 1.2f;
    private static final int SHAKE_RESET_DELAY = 4;
    private static final float ALLY_DAMAGE_MULTIPLIER = 0.08f;
    private static final int SMASH_DURABILITY_DAMAGE_BASE = 4;
    private static final float SMASH_DURABILITY_DAMAGE_PER_BLOCK = 0.8f;
    private static final int SMASH_MAX_DURABILITY_DAMAGE = 800;
    private static final float KNOCKED_UP_BASE_CHANCE = 0.04f;
    private static final float KNOCKED_UP_CHANCE_PER_BLOCK = 0.008f;
    private static final float KNOCKED_UP_CRITICAL_CHANCE = 0.08f;
    private static final int KNOCKED_UP_DURATION = 40;
    private static final int KNOCKED_UP_LEVEL = 1;
    private static final boolean ENABLE_DEPLETION = false;
    private static final float BACKSTAB_MULTIPLIER_NORMAL = 2.5f;
    private static final float BACKSTAB_MULTIPLIER_SNEAKING = 3.0f;
    private static final float BACKSTAB_MULTIPLIER_INVISIBLE = 3.5f;
    private static final float BACKSTAB_MULTIPLIER_SNEAKING_INVISIBLE = 4.0f;
    private static final float BACKSTAB_DURABILITY_PENALTY = 5.0f;
    private static final float RIGHT_CLICK_DURABILITY_MULTIPLIER = 2.0f;
    private static final float RIGHT_CLICK_FORWARD_IMPULSE = 0.8f;
    private static final float WEAKNESS_CHANCE = 0.0f;
    private static final int WEAKNESS_DURATION = 60;
    private static final int WEAKNESS_LEVEL = 1;
    private static final float DARKNESS_BONUS = 1.5f;
    private static final float MOVING_TARGET_PENALTY = 0.5f;
    private static final double BACKSTAB_MAX_DISTANCE = 2.0;
    private static final double BACKSTAB_MAX_ANGLE = Math.toRadians(45.0);
    private static final int RIGHT_CLICK_COOLDOWN = 40;
    private static final float RIGHT_CLICK_DAMAGE_BONUS = 5.0f;

    @Inject(method={"hurtEnemy"}, at={@At(value="HEAD")})
    private void injectHurtEnemy(LivingEntity entity, Player attacker, CallbackInfo ci) {
        if (entity == null || attacker == null) {
            return;
        }
        ItemStack itemStack = (ItemStack)this;
        Level level = attacker.m_9236_();
        if (level == null) {
            return;
        }
        int overdriveLevel = itemStack.getEnchantmentLevel((Enchantment)JaamsWeaponryModEnchantments.OVERDRIVE.get());
        if (overdriveLevel > 0) {
            int extraDamage = OverdriveEnchantment.getDurabilityCost(overdriveLevel);
            itemStack.m_41622_(extraDamage, (LivingEntity)attacker, player -> player.m_21190_(player.m_7655_()));
        }
        if (itemStack.m_204117_(ModTags.PICKAXES) && !level.m_5776_()) {
            this.applyPickaxeArmorDamage(itemStack, entity, attacker, level);
        }
        if (itemStack.m_204117_(ModTags.SHOVELS) && !level.m_5776_()) {
            boolean isCritical = ModUtils.isCritical(attacker, (Entity)entity, attacker.m_36403_(0.5f));
            float attackStrength = attacker.m_36403_(0.5f);
            this.applyShovelSmashLogic(attacker, entity, itemStack, attackStrength);
            this.applyShovelAttackEffects(attacker, entity, itemStack, attackStrength);
        }
        if (itemStack.m_204117_(ModTags.HOES) && !level.m_5776_()) {
            boolean isFullyCharged;
            boolean bl = isFullyCharged = attacker.m_36403_(0.5f) >= 1.0f;
            if (isFullyCharged && BackstabHandler.isBackstab((LivingEntity)attacker, entity, 2.0, BACKSTAB_MAX_ANGLE)) {
                BackstabHandler.performBackstab((LivingEntity)attacker, entity, itemStack, level, 5.0f, 0.0f, 60, 1, 2.5f, 3.0f, 3.5f, 4.0f, 1.5f, 0.5f);
            }
        }
    }

    private void applyShovelSmashLogic(Player player, LivingEntity entity, ItemStack itemStack, float attackStrength) {
        if (player.f_19789_ >= 2.0f && !player.m_20069_() && !player.m_20077_()) {
            SmashAttackHandler.applySmashLogic((LivingEntity)player, entity, itemStack, attackStrength, player.f_19789_, 0.4f, 30.0f, 0.8f, 0.15f, 15.0f, 0.5f, 0.08f, 0.15f, 0.008f, 5, 80.0f, 1.2f, 4, 0.08f, 4, 0.8f, 800, 0.04f, 0.008f, 40, 1, 0.0f, 0, 0, 0.0f, 0.0f, 0, 0, false);
        }
    }

    private void applyShovelAttackEffects(Player player, LivingEntity entity, ItemStack itemStack, float attackStrength) {
        boolean isCritical = ModUtils.isCritical(player, (Entity)entity, attackStrength);
        if (isCritical) {
            SmashAttackHandler.applyCriticalKnockedUpEffect((LivingEntity)player, entity, 0.08f, 40, 1);
        }
    }

    private void applyPickaxeArmorDamage(ItemStack itemStack, LivingEntity entity, Player attacker, Level level) {
        boolean isFullyCharged;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean bl = isFullyCharged = attacker.m_36403_(0.5f) >= 1.0f;
        if (!isFullyCharged) {
            return;
        }
        boolean isCritical = ModUtils.isCritical(attacker, (Entity)entity, attacker.m_36403_(0.5f));
        float armorDamageChance = isCritical ? 0.75f : 0.5f;
        boolean damageApplied = false;
        RandomSource random = level.f_46441_;
        if (random.m_188501_() < armorDamageChance) {
            BreakingHandler.damageArmorPieces(entity, 6, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
            damageApplied = true;
        }
        if (damageApplied) {
            itemStack.m_41622_(1, (LivingEntity)attacker, player -> player.m_21166_(EquipmentSlot.MAINHAND));
            this.spawnItemParticles(serverLevel, itemStack, entity, random);
        }
    }

    private void spawnItemParticles(ServerLevel serverLevel, ItemStack itemStack, LivingEntity entity, RandomSource random) {
        for (int i = 0; i < 5; ++i) {
            double xOffset = entity.m_20185_() + (random.m_188500_() - 0.5) * (double)entity.m_20205_();
            double yOffset = entity.m_20186_() + (double)entity.m_20206_() * 0.5 + (random.m_188500_() - 0.5) * (double)entity.m_20206_() * 0.5;
            double zOffset = entity.m_20189_() + (random.m_188500_() - 0.5) * (double)entity.m_20205_();
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), xOffset, yOffset, zOffset, 1, 0.1, 0.1, 0.1, 0.05);
        }
    }

    private float calculateDamage(ItemStack itemStack) {
        AttributeModifier modifier = itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().findFirst().orElse(null);
        return modifier != null ? (float)modifier.m_22218_() : 1.0f;
    }

    @Inject(method={"interactLivingEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectInteractLivingEntity(Player player, LivingEntity target, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (player == null || target == null) {
            return;
        }
        ItemStack itemStack = player.m_21120_(hand);
        Level level = player.m_9236_();
        if (level == null || level.m_5776_()) {
            return;
        }
        if (itemStack.m_204117_(ModTags.HOES)) {
            Player targetPlayer;
            if (target instanceof Player && (targetPlayer = (Player)target).m_7500_()) {
                cir.setReturnValue((Object)InteractionResult.PASS);
                return;
            }
            if (!player.m_36335_().m_41519_(itemStack.m_41720_()) && BackstabHandler.isBackstab((LivingEntity)player, target, 2.0, BACKSTAB_MAX_ANGLE)) {
                float baseDamage = this.calculateDamage(itemStack) + (float)(player.m_21133_(Attributes.f_22281_) / 2.0);
                BackstabHandler.performRightClickBackstab((LivingEntity)player, target, itemStack, level, baseDamage, 5.0f, 2.0f, 0.8f, 0.0f, 60, 1, 2.5f, 3.0f, 3.5f, 4.0f, 1.5f, 0.5f, 5.0f);
                player.m_36335_().m_41524_(itemStack.m_41720_(), 40);
                player.m_6674_(hand);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            } else {
                cir.setReturnValue((Object)InteractionResult.PASS);
            }
        }
    }

    @Inject(method={"getUseAnimation"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyUseAnimation(CallbackInfoReturnable<UseAnim> cir) {
        ItemStack itemStack = (ItemStack)this;
        if (itemStack.m_204117_(ModTags.AXES)) {
            cir.setReturnValue((Object)UseAnim.SPEAR);
        } else if (itemStack.m_204117_(ModTags.SWORDS)) {
            cir.setReturnValue((Object)UseAnim.BLOCK);
        }
    }

    @Inject(method={"getUseDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyUseDuration(CallbackInfoReturnable<Integer> cir) {
        ItemStack itemStack = (ItemStack)this;
        if (itemStack.m_204117_(ModTags.AXES) || itemStack.m_204117_(ModTags.SWORDS)) {
            cir.setReturnValue((Object)72000);
        }
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectUse(Level level, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_204117_(ModTags.AXES)) {
            if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
                cir.setReturnValue((Object)InteractionResultHolder.m_19100_((Object)itemStack));
                return;
            }
            player.m_6672_(hand);
            cir.setReturnValue((Object)InteractionResultHolder.m_19096_((Object)itemStack));
        } else if (itemStack.m_204117_(ModTags.SWORDS) && !ModUtils.isEntityInBattleMode((Entity)player)) {
            player.m_6672_(hand);
            cir.setReturnValue((Object)new InteractionResultHolder(InteractionResult.CONSUME, (Object)itemStack));
        }
    }

    @Inject(method={"releaseUsing"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectReleaseUsing(Level level, LivingEntity entity, int durationUsed, CallbackInfo ci) {
        ItemStack itemStack = (ItemStack)this;
        if (!itemStack.m_204117_(ModTags.AXES)) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int remainingDuration = itemStack.m_41779_() - durationUsed;
        if (remainingDuration >= 5 && !level.f_46443_) {
            float power = ItemStackMixin.getPowerForTime(remainingDuration);
            float speed = this.calculateProjectileSpeed(power);
            boolean isCreative = player.m_150110_().f_35937_;
            boolean hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)itemStack) > 0;
            int projectileCount = hasMultishot ? 3 : 1;
            float[] shotPitches = this.generateShotPitches(level.m_213780_(), projectileCount);
            int pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)itemStack);
            for (int i = 0; i < projectileCount; ++i) {
                AxeProjectileEntity projectile = new AxeProjectileEntity(level, (LivingEntity)player, itemStack.m_41777_());
                int slotIndex = entity.m_7655_() == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40;
                projectile.setOriginalSlotIndex(slotIndex);
                if (ModUtils.isProjectileCritical(player, power)) {
                    projectile.setCritical(true);
                }
                projectile.setPiercingLevel(projectile.getPiercingLevel() + pierceLevel);
                if (hasMultishot) {
                    AbstractArrow.Pickup pickup = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : (projectile.f_36705_ = i == 0 ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED);
                    if (i != 0) {
                        projectile.getPersistentData().m_128379_("IsMultishotClone", true);
                    }
                    float spreadAngle = 10.0f;
                    float rotation = i == 0 ? 0.0f : (i == 1 ? -spreadAngle : spreadAngle);
                    Vec3 upVector = player.m_20289_(1.0f);
                    Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis(rotation * (float)Math.PI / 180.0f, (float)upVector.f_82479_, (float)upVector.f_82480_, (float)upVector.f_82481_);
                    Vec3 viewVector = player.m_20252_(1.0f);
                    Vector3f rotatedVector = new Vector3f((float)viewVector.f_82479_, (float)viewVector.f_82480_, (float)viewVector.f_82481_).rotate((Quaternionfc)rotationQuaternion);
                    if (i == 0) {
                        float forwardOffset = 1.0f;
                        Vec3 offset = viewVector.m_82490_((double)forwardOffset);
                        projectile.m_6034_(player.m_20185_() + offset.f_82479_, player.m_20188_() + offset.f_82480_, player.m_20189_() + offset.f_82481_);
                    }
                    projectile.m_6686_(rotatedVector.x(), rotatedVector.y(), rotatedVector.z(), speed, 1.0f);
                } else {
                    projectile.f_36705_ = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                    projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, speed, 1.0f);
                }
                projectile.setWeaponItem(itemStack.m_41777_());
                level.m_7967_((Entity)projectile);
                SoundEvent shootSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:axe_throw"));
                level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), shootSound != null ? shootSound : SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, shotPitches[i]);
            }
            if (!isCreative) {
                itemStack.m_41622_(1, (LivingEntity)player, brokenItemStack -> brokenItemStack.m_21190_(entity.m_7655_()));
                itemStack.m_41774_(1);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
            ci.cancel();
        }
    }

    private static float getPowerForTime(int duration) {
        float f = (float)duration / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    private float calculateProjectileSpeed(float power) {
        float speedRange = 0.5f;
        float scaledPower = power * power;
        return 0.5f + speedRange * scaledPower;
    }

    private float[] generateShotPitches(RandomSource random, int projectileCount) {
        float[] pitches = new float[projectileCount];
        for (int i = 0; i < projectileCount; ++i) {
            boolean flag = random.m_188499_();
            pitches[i] = 1.0f / (random.m_188501_() * 0.5f + 1.8f) + (flag ? 0.63f : 0.43f);
        }
        return pitches;
    }
}

