/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.mixins;

import net.jaams.jaams_weaponry.item.GreatCrossbowItem;
import net.jaams.jaams_weaponry.item.HuntersCrossbowItem;
import net.jaams.jaams_weaponry.mixins.BaseMobMixin;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Pillager.class})
public abstract class PillagerMixin
extends BaseMobMixin {
    @Inject(at={@At(value="HEAD")}, method={"canFireProjectileWeapon(Lnet/minecraft/world/item/ProjectileWeaponItem;)Z"}, cancellable=true)
    public void canFireProjectileWeapon(ProjectileWeaponItem weaponItem, CallbackInfoReturnable<Boolean> callback) {
        if (weaponItem instanceof CrossbowItem) {
            callback.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"performRangedAttack(Lnet/minecraft/world/entity/LivingEntity;F)V"}, cancellable=true)
    public void performRangedAttack(LivingEntity target, float velocity, CallbackInfo callback) {
        Pillager pillager = (Pillager)this;
        ItemStack mainHandItem = pillager.m_21205_();
        if (mainHandItem.m_41720_() instanceof CrossbowItem) {
            CrossbowItem.m_40887_((Level)pillager.m_9236_(), (LivingEntity)pillager, (InteractionHand)InteractionHand.MAIN_HAND, (ItemStack)mainHandItem, (float)velocity, (float)1.0f);
            pillager.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (pillager.m_217043_().m_188501_() * 0.4f + 0.8f));
            callback.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"shootCrossbowProjectile(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/projectile/Projectile;F)V"})
    private void shootCrossbowProjectile(LivingEntity target, ItemStack crossbow, Projectile projectile, float velocity, CallbackInfo info) {
        if (crossbow.m_41720_() instanceof GreatCrossbowItem && projectile instanceof Arrow) {
            float damageMultiplier = 2.5f;
            Arrow arrow = (Arrow)projectile;
            arrow.m_36781_(arrow.m_36789_() * (double)damageMultiplier);
        }
        if (crossbow.m_41720_() instanceof HuntersCrossbowItem && projectile instanceof Arrow) {
            Arrow arrow = (Arrow)projectile;
            arrow.m_36781_(Math.min(arrow.m_36789_(), 2.0));
        }
    }

    @Inject(method={"populateDefaultEquipmentSlots"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty, CallbackInfo ci) {
        if (random.m_188501_() < 0.9f) {
            ci.cancel();
        } else {
            ((Pillager)this).m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
            ci.cancel();
        }
    }
}

