/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.mixins;

import net.jaams.jaams_weaponry.capability.dualwield.DualWieldProvider;
import net.jaams.jaams_weaponry.capability.dualwield.IDualWield;
import net.jaams.jaams_weaponry.mixins.LivingEntityAccessorMixin;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @Inject(method={"getAttackStrengthScale(F)F"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyAttackStrengthScale(float adjustTicks, CallbackInfoReturnable<Float> cir) {
        if (ModList.get().isLoaded("bettercombat")) {
            return;
        }
        Player player = (Player)this;
        LivingEntityAccessorMixin accessor = (LivingEntityAccessorMixin)((Object)this);
        ItemStack mainHandItem = player.m_6844_(EquipmentSlot.MAINHAND);
        ItemStack offhandItem = player.m_6844_(EquipmentSlot.OFFHAND);
        LazyOptional stateCap = player.getCapability(DualWieldProvider.DUAL_WIELD);
        if (!stateCap.isPresent()) {
            return;
        }
        IDualWield state = (IDualWield)stateCap.orElse(null);
        if (state == null || !state.isOffhandTurn()) {
            return;
        }
        if (mainHandItem.m_41619_() && !offhandItem.m_41619_()) {
            double attackSpeed = 4.0;
            attackSpeed = offhandItem.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_).stream().mapToDouble(modifier -> modifier.m_22218_()).sum() + attackSpeed;
            float attackDelay = (float)(1.0 / attackSpeed * 20.0);
            float scale = Mth.m_14036_((float)(((float)accessor.getAttackStrengthTicker() + adjustTicks) / attackDelay), (float)0.0f, (float)1.0f);
            cir.setReturnValue((Object)Float.valueOf(scale));
        }
    }
}

