/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.mixins;

import net.jaams.jaams_weaponry.mixins.BaseMobMixin;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractSkeleton.class})
public abstract class SkeletonMixin
extends BaseMobMixin {
    @Shadow
    @Final
    private RangedBowAttackGoal<AbstractSkeleton> f_32130_;
    @Shadow
    @Final
    private MeleeAttackGoal f_32131_;

    @Override
    @Shadow
    public abstract void m_8061_(EquipmentSlot var1, ItemStack var2);

    @Inject(at={@At(value="HEAD")}, method={"reassessWeaponGoal()V"}, cancellable=true)
    private void reassessWeaponGoal(CallbackInfo callback) {
        AbstractSkeleton skeleton = (AbstractSkeleton)this;
        if (skeleton.m_9236_() != null && !skeleton.m_9236_().f_46443_) {
            ItemStack mainHandStack = skeleton.m_21120_(InteractionHand.MAIN_HAND);
            skeleton.f_21345_.m_25363_(this.f_32130_);
            skeleton.f_21345_.m_25363_((Goal)this.f_32131_);
            if (mainHandStack.m_41720_() instanceof BowItem) {
                int attackInterval = skeleton.m_9236_().m_46791_() == Difficulty.HARD ? 20 : 40;
                this.f_32130_.m_25797_(attackInterval);
                skeleton.f_21345_.m_25352_(4, this.f_32130_);
                callback.cancel();
            } else {
                skeleton.f_21345_.m_25352_(4, (Goal)this.f_32131_);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canFireProjectileWeapon(Lnet/minecraft/world/item/ProjectileWeaponItem;)Z"}, cancellable=true)
    public void canFireProjectileWeapon(ProjectileWeaponItem weaponItem, CallbackInfoReturnable<Boolean> callback) {
        if (weaponItem instanceof BowItem) {
            callback.setReturnValue((Object)true);
        }
    }

    @Inject(method={"populateDefaultEquipmentSlots"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyDefaultEquipment(RandomSource random, DifficultyInstance difficulty, CallbackInfo ci) {
        if (random.m_188501_() < 0.9f) {
            ci.cancel();
        } else {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
            ci.cancel();
        }
    }
}

