/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.mixins;

import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.entity.TridentProjectileEntity;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TridentItem.class})
public abstract class TridentItemMixin {
    private static final int MAX_DRAW_DURATION = 20;
    private static final float MIN_PROJECTILE_SPEED = 0.4f;
    private static final float MAX_PROJECTILE_SPEED = 2.5f;
    private static final int THROW_THRESHOLD_TIME = 10;

    @Inject(method={"releaseUsing"}, at={@At(value="HEAD")}, cancellable=true)
    private void customReleaseUsing(ItemStack itemStack, Level level, LivingEntity entity, int durationUsed, CallbackInfo ci) {
        if (!((Boolean)JaamsWeaponryCommonConfiguration.USECUSTOMTRIDENT.get()).booleanValue()) {
            return;
        }
        if (!(entity instanceof Player)) {
            ci.cancel();
            return;
        }
        Player player = (Player)entity;
        int remainingDuration = ((TridentItem)this).m_8105_(itemStack) - durationUsed;
        if (remainingDuration < 10) {
            ci.cancel();
            return;
        }
        int riptideLevel = EnchantmentHelper.m_44932_((ItemStack)itemStack);
        if (riptideLevel > 0 && !player.m_20070_()) {
            ci.cancel();
            return;
        }
        if (!level.f_46443_) {
            itemStack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(player.m_7655_()));
            if (riptideLevel == 0) {
                float power = this.getPowerForTime(remainingDuration);
                float speed = this.calculateProjectileSpeed(power);
                boolean isCreative = player.m_150110_().f_35937_;
                boolean hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)itemStack) > 0;
                int projectileCount = hasMultishot ? 3 : 1;
                float[] shotPitches = this.generateShotPitches(level.m_213780_(), projectileCount);
                int pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)itemStack);
                for (int i = 0; i < projectileCount; ++i) {
                    TridentProjectileEntity projectile = new TridentProjectileEntity(level, (LivingEntity)player, itemStack.m_41777_());
                    int slotIndex = player.m_7655_() == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40;
                    projectile.setOriginalSlotIndex(slotIndex);
                    if (ModUtils.isProjectileCritical(player, power)) {
                        projectile.m_36762_(true);
                    }
                    projectile.setPiercingLevel(projectile.getPiercingLevel() + pierceLevel);
                    if (hasMultishot) {
                        AbstractArrow.Pickup pickup = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : (projectile.f_36705_ = i == 0 ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED);
                        if (i != 0) {
                            projectile.getPersistentData().m_128379_("IsMultishotClone", true);
                        }
                        float spreadAngle = 10.0f;
                        float rotation = i == 0 ? 0.0f : (i == 1 ? -spreadAngle : spreadAngle);
                        Vec3 upVector = player.m_20289_(1.0f);
                        Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis(rotation * (float)Math.PI / 180.0f, (float)upVector.f_82479_, (float)upVector.f_82480_, (float)upVector.f_82481_);
                        Vec3 viewVector = player.m_20252_(1.0f);
                        Vector3f rotatedVector = new Vector3f((float)viewVector.f_82479_, (float)viewVector.f_82480_, (float)viewVector.f_82481_).rotate((Quaternionfc)rotationQuaternion);
                        if (i == 0) {
                            float forwardOffset = 1.0f;
                            Vec3 offset = viewVector.m_82490_((double)forwardOffset);
                            projectile.m_6034_(player.m_20185_() + offset.f_82479_, player.m_20188_() + offset.f_82480_, player.m_20189_() + offset.f_82481_);
                        }
                        projectile.m_6686_(rotatedVector.x(), rotatedVector.y(), rotatedVector.z(), speed, 1.0f);
                    } else {
                        projectile.f_36705_ = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                        projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, speed, 1.0f);
                    }
                    level.m_7967_((Entity)projectile);
                    level.m_6269_(null, (Entity)projectile, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, shotPitches[i]);
                    if (isCreative) continue;
                    player.m_150109_().m_36057_(itemStack);
                }
            } else {
                float yRot = player.m_146908_();
                float xRot = player.m_146909_();
                float xMotion = -Mth.m_14031_((float)(yRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(xRot * ((float)Math.PI / 180)));
                float yMotion = -Mth.m_14031_((float)(xRot * ((float)Math.PI / 180)));
                float zMotion = Mth.m_14089_((float)(yRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(xRot * ((float)Math.PI / 180)));
                float magnitude = Mth.m_14116_((float)(xMotion * xMotion + yMotion * yMotion + zMotion * zMotion));
                float riptideSpeed = 3.0f * ((1.0f + (float)riptideLevel) / 4.0f);
                player.m_20334_((double)(xMotion *= riptideSpeed / magnitude), (double)(yMotion *= riptideSpeed / magnitude), (double)(zMotion *= riptideSpeed / magnitude));
                player.f_19864_ = true;
                player.m_204079_(20);
                if (player.m_20096_()) {
                    player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                }
                SoundEvent riptideSound = riptideLevel >= 3 ? SoundEvents.f_12519_ : (riptideLevel == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                level.m_6269_(null, (Entity)player, riptideSound, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)((TridentItem)this)));
        ci.cancel();
    }

    private float getPowerForTime(int duration) {
        float f = (float)duration / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    private float calculateProjectileSpeed(float power) {
        float speedRange = 2.1f;
        float scaledPower = power * power;
        return 0.4f + speedRange * scaledPower;
    }

    private float[] generateShotPitches(RandomSource random, int projectileCount) {
        float[] pitches = new float[projectileCount];
        for (int i = 0; i < projectileCount; ++i) {
            boolean flag = random.m_188499_();
            pitches[i] = 1.0f / (random.m_188501_() * 0.5f + 1.8f) + (flag ? 0.63f : 0.43f);
        }
        return pitches;
    }
}

