/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.jaams.jaams_weaponry.JaamsWeaponryMod;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryClientConfiguration;
import net.jaams.jaams_weaponry.world.inventory.PistolGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PistolGUISlotMessage {
    private final int slotID;
    private final int x;
    private final int y;
    private final int z;
    private final int changeType;
    private final int meta;

    public PistolGUISlotMessage(int slotID, int x, int y, int z, int changeType, int meta) {
        this.slotID = slotID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.changeType = changeType;
        this.meta = meta;
    }

    public PistolGUISlotMessage(FriendlyByteBuf buffer) {
        this.slotID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.changeType = buffer.readInt();
        this.meta = buffer.readInt();
    }

    public static void buffer(PistolGUISlotMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }

    public static void handler(PistolGUISlotMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int slotID = message.slotID;
            int changeType = message.changeType;
            int meta = message.meta;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            PistolGUISlotMessage.handleSlotAction((Player)entity, slotID, changeType, meta, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = PistolGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 0 && changeType == 0) {
            PistolGUISlotMessage.playClientSound((LevelAccessor)world, x, y, z, new ResourceLocation("jaams_weaponry:gun_system_pistol_attachment"));
        }
        if (slot == 1 && changeType == 0) {
            PistolGUISlotMessage.playClientSound((LevelAccessor)world, x, y, z, new ResourceLocation("jaams_weaponry:gun_system_pistol_bullet"));
        }
        if (slot == 2 && changeType == 0) {
            PistolGUISlotMessage.playClientSound((LevelAccessor)world, x, y, z, new ResourceLocation("jaams_weaponry:gun_system_pistol_attachment"));
        }
    }

    private static void playClientSound(LevelAccessor world, double x, double y, double z, ResourceLocation sound) {
        if (((Boolean)JaamsWeaponryClientConfiguration.GUNINVSOUNDS.get()).booleanValue() && world.m_5776_()) {
            ((Level)world).m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(sound), SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JaamsWeaponryMod.addNetworkMessage(PistolGUISlotMessage.class, PistolGUISlotMessage::buffer, PistolGUISlotMessage::new, PistolGUISlotMessage::handler);
    }
}

