/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.packets;

import java.util.function.Supplier;
import net.jaams.jaams_weaponry.packets.ClientPacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class AnimationPacket {
    private final int playerId;
    private final String animation;
    private final int duration;

    public AnimationPacket(int playerId, String animation, int duration) {
        this.playerId = playerId;
        this.animation = animation;
        this.duration = duration;
    }

    public static void encode(AnimationPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.playerId);
        buf.m_130070_(packet.animation);
        buf.writeInt(packet.duration);
    }

    public static AnimationPacket decode(FriendlyByteBuf buf) {
        int playerId = buf.readInt();
        String animation = buf.m_130277_();
        int duration = buf.readInt();
        return new AnimationPacket(playerId, animation, duration);
    }

    public static void handle(AnimationPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleAnimationPacket(packet.playerId, packet.animation, packet.duration));
        }
        ctx.get().setPacketHandled(true);
    }
}

