/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.packets;

import net.jaams.jaams_weaponry.capability.aberration.AberrationProvider;
import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.capability.animation.AnimationProvider;
import net.jaams.jaams_weaponry.capability.dualwield.DualWieldProvider;
import net.jaams.jaams_weaponry.guns.util.GunUtils;
import net.jaams.jaams_weaponry.util.ModEnums;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientPacketHandler {
    public static void handleAmountPacket(int entityId, float damage) {
        Entity entity;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ != null && (entity = minecraft.f_91073_.m_6815_(entityId)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.getCapability(AmountProvider.AMOUNT).ifPresent(amount -> amount.setDamage(damage));
        }
    }

    public static void handleGunCooldownPacket(InteractionHand hand, int cooldownTicks) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ItemStack itemStack = player.m_21120_(hand);
            if (!player.m_36335_().m_41519_(itemStack.m_41720_()) && cooldownTicks > 0) {
                player.m_36335_().m_41524_(itemStack.m_41720_(), cooldownTicks);
            }
        }
    }

    public static void handleVisualRecoilPacket(float xRotRecoilIntensity) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            GunUtils.applyVisualRecoil((Player)player, xRotRecoilIntensity);
        }
    }

    public static void handleDualWieldPacket(int playerId, boolean isOffhandTurn) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(playerId)) instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(DualWieldProvider.DUAL_WIELD).ifPresent(dualWield -> dualWield.setOffhandTurn(isOffhandTurn));
        }
    }

    public static void handleAberrationPacket(int playerId, ModEnums.AberrationType effectType, double intensity, int duration) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(playerId)) instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(AberrationProvider.ABERRATION).ifPresent(aberration -> {
                aberration.setEffectType(effectType);
                aberration.setIntensity(intensity);
                aberration.setDuration(duration);
            });
        }
    }

    public static void handleAnimationPacket(int playerId, String animation, int duration) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(playerId)) instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(AnimationProvider.ANIMATION).ifPresent(animationCap -> {
                animationCap.setAnimation(animation);
                animationCap.setDuration(duration);
            });
        }
    }
}

