/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.packets;

import java.util.function.Supplier;
import net.jaams.jaams_weaponry.packets.ClientPacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class DualWieldPacket {
    private final int playerId;
    private final boolean isOffhandTurn;

    public DualWieldPacket(int playerId, boolean isOffhandTurn) {
        this.playerId = playerId;
        this.isOffhandTurn = isOffhandTurn;
    }

    public static void encode(DualWieldPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.playerId);
        buf.writeBoolean(packet.isOffhandTurn);
    }

    public static DualWieldPacket decode(FriendlyByteBuf buf) {
        int playerId = buf.readInt();
        boolean isOffhandTurn = buf.readBoolean();
        return new DualWieldPacket(playerId, isOffhandTurn);
    }

    public static void handle(DualWieldPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleDualWieldPacket(packet.playerId, packet.isOffhandTurn));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

