/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.packets;

import java.util.function.Supplier;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.guns.util.GunUtils;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class GunInventoryPacket {
    private final InteractionHand hand;

    public GunInventoryPacket(InteractionHand hand) {
        this.hand = hand;
    }

    public static void encode(GunInventoryPacket packet, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)packet.hand);
    }

    public static GunInventoryPacket decode(FriendlyByteBuf buf) {
        InteractionHand hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        return new GunInventoryPacket(hand);
    }

    public static void handle(GunInventoryPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
                if (serverPlayer == null) {
                    return;
                }
                Level world = serverPlayer.m_9236_();
                ItemStack itemStack = serverPlayer.m_21120_(packet.hand);
                if (!((Boolean)JaamsWeaponryCommonConfiguration.ENABLEGUNINVENTORY.get()).booleanValue() || packet.hand == InteractionHand.OFF_HAND && ModUtils.isEntityInBattleMode((Entity)serverPlayer)) {
                    return;
                }
                if (itemStack.m_204117_(TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation("jaams_weaponry:pistols")))) {
                    GunUtils.openPistolInventory(serverPlayer, itemStack, packet.hand);
                } else if (itemStack.m_204117_(TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation("jaams_weaponry:scatterguns")))) {
                    GunUtils.openScattergunInventory(serverPlayer, itemStack, packet.hand);
                } else if (itemStack.m_204117_(TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation("jaams_weaponry:shotguns")))) {
                    GunUtils.openShotgunInventory(serverPlayer, itemStack, packet.hand);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

